/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeRaidArrays</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeRaidArraysResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeRaidArraysResponse.Builder, DescribeRaidArraysResponse> {
    private final List<RaidArray> raidArrays;

    private DescribeRaidArraysResponse(BuilderImpl builder) {
        this.raidArrays = builder.raidArrays;
    }

    /**
     * <p>
     * A <code>RaidArrays</code> object that describes the specified RAID arrays.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A <code>RaidArrays</code> object that describes the specified RAID arrays.
     */
    public List<RaidArray> raidArrays() {
        return raidArrays;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((raidArrays() == null) ? 0 : raidArrays().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRaidArraysResponse)) {
            return false;
        }
        DescribeRaidArraysResponse other = (DescribeRaidArraysResponse) obj;
        if (other.raidArrays() == null ^ this.raidArrays() == null) {
            return false;
        }
        if (other.raidArrays() != null && !other.raidArrays().equals(this.raidArrays())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (raidArrays() != null) {
            sb.append("RaidArrays: ").append(raidArrays()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RaidArrays":
            return Optional.of(clazz.cast(raidArrays()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeRaidArraysResponse> {
        /**
         * <p>
         * A <code>RaidArrays</code> object that describes the specified RAID arrays.
         * </p>
         * 
         * @param raidArrays
         *        A <code>RaidArrays</code> object that describes the specified RAID arrays.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder raidArrays(Collection<RaidArray> raidArrays);

        /**
         * <p>
         * A <code>RaidArrays</code> object that describes the specified RAID arrays.
         * </p>
         * 
         * @param raidArrays
         *        A <code>RaidArrays</code> object that describes the specified RAID arrays.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder raidArrays(RaidArray... raidArrays);
    }

    static final class BuilderImpl implements Builder {
        private List<RaidArray> raidArrays;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRaidArraysResponse model) {
            raidArrays(model.raidArrays);
        }

        public final Collection<RaidArray.Builder> getRaidArrays() {
            return raidArrays != null ? raidArrays.stream().map(RaidArray::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder raidArrays(Collection<RaidArray> raidArrays) {
            this.raidArrays = RaidArraysCopier.copy(raidArrays);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder raidArrays(RaidArray... raidArrays) {
            raidArrays(Arrays.asList(raidArrays));
            return this;
        }

        public final void setRaidArrays(Collection<RaidArray.BuilderImpl> raidArrays) {
            this.raidArrays = RaidArraysCopier.copyFromBuilder(raidArrays);
        }

        @Override
        public DescribeRaidArraysResponse build() {
            return new DescribeRaidArraysResponse(this);
        }
    }
}
