/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeInstances</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeInstancesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeInstancesResponse.Builder, DescribeInstancesResponse> {
    private final List<Instance> instances;

    private DescribeInstancesResponse(BuilderImpl builder) {
        this.instances = builder.instances;
    }

    /**
     * <p>
     * An array of <code>Instance</code> objects that describe the instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>Instance</code> objects that describe the instances.
     */
    public List<Instance> instances() {
        return instances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instances() == null) ? 0 : instances().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeInstancesResponse)) {
            return false;
        }
        DescribeInstancesResponse other = (DescribeInstancesResponse) obj;
        if (other.instances() == null ^ this.instances() == null) {
            return false;
        }
        if (other.instances() != null && !other.instances().equals(this.instances())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (instances() != null) {
            sb.append("Instances: ").append(instances()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Instances":
            return Optional.of(clazz.cast(instances()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeInstancesResponse> {
        /**
         * <p>
         * An array of <code>Instance</code> objects that describe the instances.
         * </p>
         * 
         * @param instances
         *        An array of <code>Instance</code> objects that describe the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Collection<Instance> instances);

        /**
         * <p>
         * An array of <code>Instance</code> objects that describe the instances.
         * </p>
         * 
         * @param instances
         *        An array of <code>Instance</code> objects that describe the instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instances(Instance... instances);
    }

    static final class BuilderImpl implements Builder {
        private List<Instance> instances;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeInstancesResponse model) {
            instances(model.instances);
        }

        public final Collection<Instance.Builder> getInstances() {
            return instances != null ? instances.stream().map(Instance::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder instances(Collection<Instance> instances) {
            this.instances = InstancesCopier.copy(instances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instances(Instance... instances) {
            instances(Arrays.asList(instances));
            return this;
        }

        public final void setInstances(Collection<Instance.BuilderImpl> instances) {
            this.instances = InstancesCopier.copyFromBuilder(instances);
        }

        @Override
        public DescribeInstancesResponse build() {
            return new DescribeInstancesResponse(this);
        }
    }
}
