/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeElasticLoadBalancers</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeElasticLoadBalancersResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeElasticLoadBalancersResponse.Builder, DescribeElasticLoadBalancersResponse> {
    private final List<ElasticLoadBalancer> elasticLoadBalancers;

    private DescribeElasticLoadBalancersResponse(BuilderImpl builder) {
        this.elasticLoadBalancers = builder.elasticLoadBalancers;
    }

    /**
     * <p>
     * A list of <code>ElasticLoadBalancer</code> objects that describe the specified Elastic Load Balancing instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of <code>ElasticLoadBalancer</code> objects that describe the specified Elastic Load Balancing
     *         instances.
     */
    public List<ElasticLoadBalancer> elasticLoadBalancers() {
        return elasticLoadBalancers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((elasticLoadBalancers() == null) ? 0 : elasticLoadBalancers().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeElasticLoadBalancersResponse)) {
            return false;
        }
        DescribeElasticLoadBalancersResponse other = (DescribeElasticLoadBalancersResponse) obj;
        if (other.elasticLoadBalancers() == null ^ this.elasticLoadBalancers() == null) {
            return false;
        }
        if (other.elasticLoadBalancers() != null && !other.elasticLoadBalancers().equals(this.elasticLoadBalancers())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (elasticLoadBalancers() != null) {
            sb.append("ElasticLoadBalancers: ").append(elasticLoadBalancers()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ElasticLoadBalancers":
            return Optional.of(clazz.cast(elasticLoadBalancers()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeElasticLoadBalancersResponse> {
        /**
         * <p>
         * A list of <code>ElasticLoadBalancer</code> objects that describe the specified Elastic Load Balancing
         * instances.
         * </p>
         * 
         * @param elasticLoadBalancers
         *        A list of <code>ElasticLoadBalancer</code> objects that describe the specified Elastic Load Balancing
         *        instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticLoadBalancers(Collection<ElasticLoadBalancer> elasticLoadBalancers);

        /**
         * <p>
         * A list of <code>ElasticLoadBalancer</code> objects that describe the specified Elastic Load Balancing
         * instances.
         * </p>
         * 
         * @param elasticLoadBalancers
         *        A list of <code>ElasticLoadBalancer</code> objects that describe the specified Elastic Load Balancing
         *        instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticLoadBalancers(ElasticLoadBalancer... elasticLoadBalancers);
    }

    static final class BuilderImpl implements Builder {
        private List<ElasticLoadBalancer> elasticLoadBalancers;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeElasticLoadBalancersResponse model) {
            elasticLoadBalancers(model.elasticLoadBalancers);
        }

        public final Collection<ElasticLoadBalancer.Builder> getElasticLoadBalancers() {
            return elasticLoadBalancers != null ? elasticLoadBalancers.stream().map(ElasticLoadBalancer::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder elasticLoadBalancers(Collection<ElasticLoadBalancer> elasticLoadBalancers) {
            this.elasticLoadBalancers = ElasticLoadBalancersCopier.copy(elasticLoadBalancers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder elasticLoadBalancers(ElasticLoadBalancer... elasticLoadBalancers) {
            elasticLoadBalancers(Arrays.asList(elasticLoadBalancers));
            return this;
        }

        public final void setElasticLoadBalancers(Collection<ElasticLoadBalancer.BuilderImpl> elasticLoadBalancers) {
            this.elasticLoadBalancers = ElasticLoadBalancersCopier.copyFromBuilder(elasticLoadBalancers);
        }

        @Override
        public DescribeElasticLoadBalancersResponse build() {
            return new DescribeElasticLoadBalancersResponse(this);
        }
    }
}
