/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeCommandsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeCommandsRequest.Builder, DescribeCommandsRequest> {
    private final String deploymentId;

    private final String instanceId;

    private final List<String> commandIds;

    private DescribeCommandsRequest(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
        this.instanceId = builder.instanceId;
        this.commandIds = builder.commandIds;
    }

    /**
     * <p>
     * The deployment ID. If you include this parameter, <code>DescribeCommands</code> returns a description of the
     * commands associated with the specified deployment.
     * </p>
     * 
     * @return The deployment ID. If you include this parameter, <code>DescribeCommands</code> returns a description of
     *         the commands associated with the specified deployment.
     */
    public String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * The instance ID. If you include this parameter, <code>DescribeCommands</code> returns a description of the
     * commands associated with the specified instance.
     * </p>
     * 
     * @return The instance ID. If you include this parameter, <code>DescribeCommands</code> returns a description of
     *         the commands associated with the specified instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * An array of command IDs. If you include this parameter, <code>DescribeCommands</code> returns a description of
     * the specified commands. Otherwise, it returns a description of every command.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of command IDs. If you include this parameter, <code>DescribeCommands</code> returns a
     *         description of the specified commands. Otherwise, it returns a description of every command.
     */
    public List<String> commandIds() {
        return commandIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deploymentId() == null) ? 0 : deploymentId().hashCode());
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((commandIds() == null) ? 0 : commandIds().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCommandsRequest)) {
            return false;
        }
        DescribeCommandsRequest other = (DescribeCommandsRequest) obj;
        if (other.deploymentId() == null ^ this.deploymentId() == null) {
            return false;
        }
        if (other.deploymentId() != null && !other.deploymentId().equals(this.deploymentId())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.commandIds() == null ^ this.commandIds() == null) {
            return false;
        }
        if (other.commandIds() != null && !other.commandIds().equals(this.commandIds())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (deploymentId() != null) {
            sb.append("DeploymentId: ").append(deploymentId()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (commandIds() != null) {
            sb.append("CommandIds: ").append(commandIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeploymentId":
            return Optional.of(clazz.cast(deploymentId()));
        case "InstanceId":
            return Optional.of(clazz.cast(instanceId()));
        case "CommandIds":
            return Optional.of(clazz.cast(commandIds()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeCommandsRequest> {
        /**
         * <p>
         * The deployment ID. If you include this parameter, <code>DescribeCommands</code> returns a description of the
         * commands associated with the specified deployment.
         * </p>
         * 
         * @param deploymentId
         *        The deployment ID. If you include this parameter, <code>DescribeCommands</code> returns a description
         *        of the commands associated with the specified deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * The instance ID. If you include this parameter, <code>DescribeCommands</code> returns a description of the
         * commands associated with the specified instance.
         * </p>
         * 
         * @param instanceId
         *        The instance ID. If you include this parameter, <code>DescribeCommands</code> returns a description of
         *        the commands associated with the specified instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * An array of command IDs. If you include this parameter, <code>DescribeCommands</code> returns a description
         * of the specified commands. Otherwise, it returns a description of every command.
         * </p>
         * 
         * @param commandIds
         *        An array of command IDs. If you include this parameter, <code>DescribeCommands</code> returns a
         *        description of the specified commands. Otherwise, it returns a description of every command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandIds(Collection<String> commandIds);

        /**
         * <p>
         * An array of command IDs. If you include this parameter, <code>DescribeCommands</code> returns a description
         * of the specified commands. Otherwise, it returns a description of every command.
         * </p>
         * 
         * @param commandIds
         *        An array of command IDs. If you include this parameter, <code>DescribeCommands</code> returns a
         *        description of the specified commands. Otherwise, it returns a description of every command.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commandIds(String... commandIds);
    }

    static final class BuilderImpl implements Builder {
        private String deploymentId;

        private String instanceId;

        private List<String> commandIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCommandsRequest model) {
            deploymentId(model.deploymentId);
            instanceId(model.instanceId);
            commandIds(model.commandIds);
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Collection<String> getCommandIds() {
            return commandIds;
        }

        @Override
        public final Builder commandIds(Collection<String> commandIds) {
            this.commandIds = StringsCopier.copy(commandIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commandIds(String... commandIds) {
            commandIds(Arrays.asList(commandIds));
            return this;
        }

        public final void setCommandIds(Collection<String> commandIds) {
            this.commandIds = StringsCopier.copy(commandIds);
        }

        @Override
        public DescribeCommandsRequest build() {
            return new DescribeCommandsRequest(this);
        }
    }
}
