/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeregisterRdsDbInstanceRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeregisterRdsDbInstanceRequest.Builder, DeregisterRdsDbInstanceRequest> {
    private final String rdsDbInstanceArn;

    private DeregisterRdsDbInstanceRequest(BuilderImpl builder) {
        this.rdsDbInstanceArn = builder.rdsDbInstanceArn;
    }

    /**
     * <p>
     * The Amazon RDS instance's ARN.
     * </p>
     * 
     * @return The Amazon RDS instance's ARN.
     */
    public String rdsDbInstanceArn() {
        return rdsDbInstanceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((rdsDbInstanceArn() == null) ? 0 : rdsDbInstanceArn().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterRdsDbInstanceRequest)) {
            return false;
        }
        DeregisterRdsDbInstanceRequest other = (DeregisterRdsDbInstanceRequest) obj;
        if (other.rdsDbInstanceArn() == null ^ this.rdsDbInstanceArn() == null) {
            return false;
        }
        if (other.rdsDbInstanceArn() != null && !other.rdsDbInstanceArn().equals(this.rdsDbInstanceArn())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (rdsDbInstanceArn() != null) {
            sb.append("RdsDbInstanceArn: ").append(rdsDbInstanceArn()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RdsDbInstanceArn":
            return Optional.of(clazz.cast(rdsDbInstanceArn()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeregisterRdsDbInstanceRequest> {
        /**
         * <p>
         * The Amazon RDS instance's ARN.
         * </p>
         * 
         * @param rdsDbInstanceArn
         *        The Amazon RDS instance's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rdsDbInstanceArn(String rdsDbInstanceArn);
    }

    static final class BuilderImpl implements Builder {
        private String rdsDbInstanceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterRdsDbInstanceRequest model) {
            rdsDbInstanceArn(model.rdsDbInstanceArn);
        }

        public final String getRdsDbInstanceArn() {
            return rdsDbInstanceArn;
        }

        @Override
        public final Builder rdsDbInstanceArn(String rdsDbInstanceArn) {
            this.rdsDbInstanceArn = rdsDbInstanceArn;
            return this;
        }

        public final void setRdsDbInstanceArn(String rdsDbInstanceArn) {
            this.rdsDbInstanceArn = rdsDbInstanceArn;
        }

        @Override
        public DeregisterRdsDbInstanceRequest build() {
            return new DeregisterRdsDbInstanceRequest(this);
        }
    }
}
