/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeleteAppRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeleteAppRequest.Builder, DeleteAppRequest> {
    private final String appId;

    private DeleteAppRequest(BuilderImpl builder) {
        this.appId = builder.appId;
    }

    /**
     * <p>
     * The app ID.
     * </p>
     * 
     * @return The app ID.
     */
    public String appId() {
        return appId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((appId() == null) ? 0 : appId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAppRequest)) {
            return false;
        }
        DeleteAppRequest other = (DeleteAppRequest) obj;
        if (other.appId() == null ^ this.appId() == null) {
            return false;
        }
        if (other.appId() != null && !other.appId().equals(this.appId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (appId() != null) {
            sb.append("AppId: ").append(appId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppId":
            return Optional.of(clazz.cast(appId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, DeleteAppRequest> {
        /**
         * <p>
         * The app ID.
         * </p>
         * 
         * @param appId
         *        The app ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);
    }

    static final class BuilderImpl implements Builder {
        private String appId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAppRequest model) {
            appId(model.appId);
        }

        public final String getAppId() {
            return appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        @Override
        public DeleteAppRequest build() {
            return new DeleteAppRequest(this);
        }
    }
}
