/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.DataSourceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an app's data source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DataSource implements StructuredPojo, ToCopyableBuilder<DataSource.Builder, DataSource> {
    private final String type;

    private final String arn;

    private final String databaseName;

    private DataSource(BuilderImpl builder) {
        this.type = builder.type;
        this.arn = builder.arn;
        this.databaseName = builder.databaseName;
    }

    /**
     * <p>
     * The data source's type, <code>AutoSelectOpsworksMysqlInstance</code>, <code>OpsworksMysqlInstance</code>, or
     * <code>RdsDbInstance</code>.
     * </p>
     * 
     * @return The data source's type, <code>AutoSelectOpsworksMysqlInstance</code>, <code>OpsworksMysqlInstance</code>,
     *         or <code>RdsDbInstance</code>.
     */
    public String type() {
        return type;
    }

    /**
     * <p>
     * The data source's ARN.
     * </p>
     * 
     * @return The data source's ARN.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The database name.
     * </p>
     * 
     * @return The database name.
     */
    public String databaseName() {
        return databaseName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((type() == null) ? 0 : type().hashCode());
        hashCode = 31 * hashCode + ((arn() == null) ? 0 : arn().hashCode());
        hashCode = 31 * hashCode + ((databaseName() == null) ? 0 : databaseName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSource)) {
            return false;
        }
        DataSource other = (DataSource) obj;
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.databaseName() == null ^ this.databaseName() == null) {
            return false;
        }
        if (other.databaseName() != null && !other.databaseName().equals(this.databaseName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (type() != null) {
            sb.append("Type: ").append(type()).append(",");
        }
        if (arn() != null) {
            sb.append("Arn: ").append(arn()).append(",");
        }
        if (databaseName() != null) {
            sb.append("DatabaseName: ").append(databaseName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.of(clazz.cast(type()));
        case "Arn":
            return Optional.of(clazz.cast(arn()));
        case "DatabaseName":
            return Optional.of(clazz.cast(databaseName()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DataSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DataSource> {
        /**
         * <p>
         * The data source's type, <code>AutoSelectOpsworksMysqlInstance</code>, <code>OpsworksMysqlInstance</code>, or
         * <code>RdsDbInstance</code>.
         * </p>
         * 
         * @param type
         *        The data source's type, <code>AutoSelectOpsworksMysqlInstance</code>,
         *        <code>OpsworksMysqlInstance</code>, or <code>RdsDbInstance</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);

        /**
         * <p>
         * The data source's ARN.
         * </p>
         * 
         * @param arn
         *        The data source's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The database name.
         * </p>
         * 
         * @param databaseName
         *        The database name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseName(String databaseName);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String arn;

        private String databaseName;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSource model) {
            type(model.type);
            arn(model.arn);
            databaseName(model.databaseName);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getDatabaseName() {
            return databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public DataSource build() {
            return new DataSource(this);
        }
    }
}
