/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateLayerRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateLayerRequest.Builder, CreateLayerRequest> {
    private final String stackId;

    private final String type;

    private final String name;

    private final String shortname;

    private final Map<String, String> attributes;

    private final CloudWatchLogsConfiguration cloudWatchLogsConfiguration;

    private final String customInstanceProfileArn;

    private final String customJson;

    private final List<String> customSecurityGroupIds;

    private final List<String> packages;

    private final List<VolumeConfiguration> volumeConfigurations;

    private final Boolean enableAutoHealing;

    private final Boolean autoAssignElasticIps;

    private final Boolean autoAssignPublicIps;

    private final Recipes customRecipes;

    private final Boolean installUpdatesOnBoot;

    private final Boolean useEbsOptimizedInstances;

    private final LifecycleEventConfiguration lifecycleEventConfiguration;

    private CreateLayerRequest(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.type = builder.type;
        this.name = builder.name;
        this.shortname = builder.shortname;
        this.attributes = builder.attributes;
        this.cloudWatchLogsConfiguration = builder.cloudWatchLogsConfiguration;
        this.customInstanceProfileArn = builder.customInstanceProfileArn;
        this.customJson = builder.customJson;
        this.customSecurityGroupIds = builder.customSecurityGroupIds;
        this.packages = builder.packages;
        this.volumeConfigurations = builder.volumeConfigurations;
        this.enableAutoHealing = builder.enableAutoHealing;
        this.autoAssignElasticIps = builder.autoAssignElasticIps;
        this.autoAssignPublicIps = builder.autoAssignPublicIps;
        this.customRecipes = builder.customRecipes;
        this.installUpdatesOnBoot = builder.installUpdatesOnBoot;
        this.useEbsOptimizedInstances = builder.useEbsOptimizedInstances;
        this.lifecycleEventConfiguration = builder.lifecycleEventConfiguration;
    }

    /**
     * <p>
     * The layer stack ID.
     * </p>
     * 
     * @return The layer stack ID.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The layer type. A stack cannot have more than one built-in layer of the same type. It can have any number of
     * custom layers. Built-in layers are not available in Chef 12 stacks.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link LayerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The layer type. A stack cannot have more than one built-in layer of the same type. It can have any number
     *         of custom layers. Built-in layers are not available in Chef 12 stacks.
     * @see LayerType
     */
    public LayerType type() {
        return LayerType.fromValue(type);
    }

    /**
     * <p>
     * The layer type. A stack cannot have more than one built-in layer of the same type. It can have any number of
     * custom layers. Built-in layers are not available in Chef 12 stacks.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link LayerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The layer type. A stack cannot have more than one built-in layer of the same type. It can have any number
     *         of custom layers. Built-in layers are not available in Chef 12 stacks.
     * @see LayerType
     */
    public String typeString() {
        return type;
    }

    /**
     * <p>
     * The layer name, which is used by the console.
     * </p>
     * 
     * @return The layer name, which is used by the console.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * For custom layers only, use this parameter to specify the layer's short name, which is used internally by AWS
     * OpsWorks Stacks and by Chef recipes. The short name is also used as the name for the directory where your app
     * files are installed. It can have a maximum of 200 characters, which are limited to the alphanumeric characters,
     * '-', '_', and '.'.
     * </p>
     * <p>
     * The built-in layers' short names are defined by AWS OpsWorks Stacks. For more information, see the <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/layers.html">Layer Reference</a>.
     * </p>
     * 
     * @return For custom layers only, use this parameter to specify the layer's short name, which is used internally by
     *         AWS OpsWorks Stacks and by Chef recipes. The short name is also used as the name for the directory where
     *         your app files are installed. It can have a maximum of 200 characters, which are limited to the
     *         alphanumeric characters, '-', '_', and '.'.</p>
     *         <p>
     *         The built-in layers' short names are defined by AWS OpsWorks Stacks. For more information, see the <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/layers.html">Layer Reference</a>.
     */
    public String shortname() {
        return shortname;
    }

    /**
     * <p>
     * One or more user-defined key-value pairs to be added to the stack attributes.
     * </p>
     * <p>
     * To create a cluster layer, set the <code>EcsClusterArn</code> attribute to the cluster's ARN.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more user-defined key-value pairs to be added to the stack attributes.</p>
     *         <p>
     *         To create a cluster layer, set the <code>EcsClusterArn</code> attribute to the cluster's ARN.
     */
    public Map<LayerAttributesKeys, String> attributes() {
        return TypeConverter.convert(attributes, LayerAttributesKeys::fromValue, Function.identity(),
                (k, v) -> !Objects.equals(k, LayerAttributesKeys.UNKNOWN_TO_SDK_VERSION));
    }

    /**
     * <p>
     * One or more user-defined key-value pairs to be added to the stack attributes.
     * </p>
     * <p>
     * To create a cluster layer, set the <code>EcsClusterArn</code> attribute to the cluster's ARN.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more user-defined key-value pairs to be added to the stack attributes.</p>
     *         <p>
     *         To create a cluster layer, set the <code>EcsClusterArn</code> attribute to the cluster's ARN.
     */
    public Map<String, String> attributesStrings() {
        return attributes;
    }

    /**
     * <p>
     * Specifies CloudWatch Logs configuration options for the layer. For more information, see
     * <a>CloudWatchLogsLogStream</a>.
     * </p>
     * 
     * @return Specifies CloudWatch Logs configuration options for the layer. For more information, see
     *         <a>CloudWatchLogsLogStream</a>.
     */
    public CloudWatchLogsConfiguration cloudWatchLogsConfiguration() {
        return cloudWatchLogsConfiguration;
    }

    /**
     * <p>
     * The ARN of an IAM profile to be used for the layer's EC2 instances. For more information about IAM ARNs, see <a
     * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
     * </p>
     * 
     * @return The ARN of an IAM profile to be used for the layer's EC2 instances. For more information about IAM ARNs,
     *         see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using
     *         Identifiers</a>.
     */
    public String customInstanceProfileArn() {
        return customInstanceProfileArn;
    }

    /**
     * <p>
     * A JSON-formatted string containing custom stack configuration and deployment attributes to be installed on the
     * layer's instances. For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html"> Using Custom
     * JSON</a>. This feature is supported as of version 1.7.42 of the AWS CLI.
     * </p>
     * 
     * @return A JSON-formatted string containing custom stack configuration and deployment attributes to be installed
     *         on the layer's instances. For more information, see <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html"> Using
     *         Custom JSON</a>. This feature is supported as of version 1.7.42 of the AWS CLI.
     */
    public String customJson() {
        return customJson;
    }

    /**
     * <p>
     * An array containing the layer custom security group IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array containing the layer custom security group IDs.
     */
    public List<String> customSecurityGroupIds() {
        return customSecurityGroupIds;
    }

    /**
     * <p>
     * An array of <code>Package</code> objects that describes the layer packages.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>Package</code> objects that describes the layer packages.
     */
    public List<String> packages() {
        return packages;
    }

    /**
     * <p>
     * A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.
     */
    public List<VolumeConfiguration> volumeConfigurations() {
        return volumeConfigurations;
    }

    /**
     * <p>
     * Whether to disable auto healing for the layer.
     * </p>
     * 
     * @return Whether to disable auto healing for the layer.
     */
    public Boolean enableAutoHealing() {
        return enableAutoHealing;
    }

    /**
     * <p>
     * Whether to automatically assign an <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP address</a> to
     * the layer's instances. For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a
     * Layer</a>.
     * </p>
     * 
     * @return Whether to automatically assign an <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP
     *         address</a> to the layer's instances. For more information, see <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a
     *         Layer</a>.
     */
    public Boolean autoAssignElasticIps() {
        return autoAssignElasticIps;
    }

    /**
     * <p>
     * For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's
     * instances. For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a
     * Layer</a>.
     * </p>
     * 
     * @return For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's
     *         instances. For more information, see <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a
     *         Layer</a>.
     */
    public Boolean autoAssignPublicIps() {
        return autoAssignPublicIps;
    }

    /**
     * <p>
     * A <code>LayerCustomRecipes</code> object that specifies the layer custom recipes.
     * </p>
     * 
     * @return A <code>LayerCustomRecipes</code> object that specifies the layer custom recipes.
     */
    public Recipes customRecipes() {
        return customRecipes;
    }

    /**
     * <p>
     * Whether to install operating system and package updates when the instance boots. The default value is
     * <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must then
     * update your instances manually by using <a>CreateDeployment</a> to run the <code>update_dependencies</code> stack
     * command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances.
     * </p>
     * <note>
     * <p>
     * To ensure that your instances have the latest security updates, we strongly recommend using the default value of
     * <code>true</code>.
     * </p>
     * </note>
     * 
     * @return Whether to install operating system and package updates when the instance boots. The default value is
     *         <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must
     *         then update your instances manually by using <a>CreateDeployment</a> to run the
     *         <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux) or
     *         <code>apt-get</code> (Ubuntu) on the instances. </p> <note>
     *         <p>
     *         To ensure that your instances have the latest security updates, we strongly recommend using the default
     *         value of <code>true</code>.
     *         </p>
     */
    public Boolean installUpdatesOnBoot() {
        return installUpdatesOnBoot;
    }

    /**
     * <p>
     * Whether to use Amazon EBS-optimized instances.
     * </p>
     * 
     * @return Whether to use Amazon EBS-optimized instances.
     */
    public Boolean useEbsOptimizedInstances() {
        return useEbsOptimizedInstances;
    }

    /**
     * <p>
     * A <code>LifeCycleEventConfiguration</code> object that you can use to configure the Shutdown event to specify an
     * execution timeout and enable or disable Elastic Load Balancer connection draining.
     * </p>
     * 
     * @return A <code>LifeCycleEventConfiguration</code> object that you can use to configure the Shutdown event to
     *         specify an execution timeout and enable or disable Elastic Load Balancer connection draining.
     */
    public LifecycleEventConfiguration lifecycleEventConfiguration() {
        return lifecycleEventConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stackId() == null) ? 0 : stackId().hashCode());
        hashCode = 31 * hashCode + ((typeString() == null) ? 0 : typeString().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((shortname() == null) ? 0 : shortname().hashCode());
        hashCode = 31 * hashCode + ((attributesStrings() == null) ? 0 : attributesStrings().hashCode());
        hashCode = 31 * hashCode + ((cloudWatchLogsConfiguration() == null) ? 0 : cloudWatchLogsConfiguration().hashCode());
        hashCode = 31 * hashCode + ((customInstanceProfileArn() == null) ? 0 : customInstanceProfileArn().hashCode());
        hashCode = 31 * hashCode + ((customJson() == null) ? 0 : customJson().hashCode());
        hashCode = 31 * hashCode + ((customSecurityGroupIds() == null) ? 0 : customSecurityGroupIds().hashCode());
        hashCode = 31 * hashCode + ((packages() == null) ? 0 : packages().hashCode());
        hashCode = 31 * hashCode + ((volumeConfigurations() == null) ? 0 : volumeConfigurations().hashCode());
        hashCode = 31 * hashCode + ((enableAutoHealing() == null) ? 0 : enableAutoHealing().hashCode());
        hashCode = 31 * hashCode + ((autoAssignElasticIps() == null) ? 0 : autoAssignElasticIps().hashCode());
        hashCode = 31 * hashCode + ((autoAssignPublicIps() == null) ? 0 : autoAssignPublicIps().hashCode());
        hashCode = 31 * hashCode + ((customRecipes() == null) ? 0 : customRecipes().hashCode());
        hashCode = 31 * hashCode + ((installUpdatesOnBoot() == null) ? 0 : installUpdatesOnBoot().hashCode());
        hashCode = 31 * hashCode + ((useEbsOptimizedInstances() == null) ? 0 : useEbsOptimizedInstances().hashCode());
        hashCode = 31 * hashCode + ((lifecycleEventConfiguration() == null) ? 0 : lifecycleEventConfiguration().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLayerRequest)) {
            return false;
        }
        CreateLayerRequest other = (CreateLayerRequest) obj;
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.typeString() == null ^ this.typeString() == null) {
            return false;
        }
        if (other.typeString() != null && !other.typeString().equals(this.typeString())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.shortname() == null ^ this.shortname() == null) {
            return false;
        }
        if (other.shortname() != null && !other.shortname().equals(this.shortname())) {
            return false;
        }
        if (other.attributesStrings() == null ^ this.attributesStrings() == null) {
            return false;
        }
        if (other.attributesStrings() != null && !other.attributesStrings().equals(this.attributesStrings())) {
            return false;
        }
        if (other.cloudWatchLogsConfiguration() == null ^ this.cloudWatchLogsConfiguration() == null) {
            return false;
        }
        if (other.cloudWatchLogsConfiguration() != null
                && !other.cloudWatchLogsConfiguration().equals(this.cloudWatchLogsConfiguration())) {
            return false;
        }
        if (other.customInstanceProfileArn() == null ^ this.customInstanceProfileArn() == null) {
            return false;
        }
        if (other.customInstanceProfileArn() != null && !other.customInstanceProfileArn().equals(this.customInstanceProfileArn())) {
            return false;
        }
        if (other.customJson() == null ^ this.customJson() == null) {
            return false;
        }
        if (other.customJson() != null && !other.customJson().equals(this.customJson())) {
            return false;
        }
        if (other.customSecurityGroupIds() == null ^ this.customSecurityGroupIds() == null) {
            return false;
        }
        if (other.customSecurityGroupIds() != null && !other.customSecurityGroupIds().equals(this.customSecurityGroupIds())) {
            return false;
        }
        if (other.packages() == null ^ this.packages() == null) {
            return false;
        }
        if (other.packages() != null && !other.packages().equals(this.packages())) {
            return false;
        }
        if (other.volumeConfigurations() == null ^ this.volumeConfigurations() == null) {
            return false;
        }
        if (other.volumeConfigurations() != null && !other.volumeConfigurations().equals(this.volumeConfigurations())) {
            return false;
        }
        if (other.enableAutoHealing() == null ^ this.enableAutoHealing() == null) {
            return false;
        }
        if (other.enableAutoHealing() != null && !other.enableAutoHealing().equals(this.enableAutoHealing())) {
            return false;
        }
        if (other.autoAssignElasticIps() == null ^ this.autoAssignElasticIps() == null) {
            return false;
        }
        if (other.autoAssignElasticIps() != null && !other.autoAssignElasticIps().equals(this.autoAssignElasticIps())) {
            return false;
        }
        if (other.autoAssignPublicIps() == null ^ this.autoAssignPublicIps() == null) {
            return false;
        }
        if (other.autoAssignPublicIps() != null && !other.autoAssignPublicIps().equals(this.autoAssignPublicIps())) {
            return false;
        }
        if (other.customRecipes() == null ^ this.customRecipes() == null) {
            return false;
        }
        if (other.customRecipes() != null && !other.customRecipes().equals(this.customRecipes())) {
            return false;
        }
        if (other.installUpdatesOnBoot() == null ^ this.installUpdatesOnBoot() == null) {
            return false;
        }
        if (other.installUpdatesOnBoot() != null && !other.installUpdatesOnBoot().equals(this.installUpdatesOnBoot())) {
            return false;
        }
        if (other.useEbsOptimizedInstances() == null ^ this.useEbsOptimizedInstances() == null) {
            return false;
        }
        if (other.useEbsOptimizedInstances() != null && !other.useEbsOptimizedInstances().equals(this.useEbsOptimizedInstances())) {
            return false;
        }
        if (other.lifecycleEventConfiguration() == null ^ this.lifecycleEventConfiguration() == null) {
            return false;
        }
        if (other.lifecycleEventConfiguration() != null
                && !other.lifecycleEventConfiguration().equals(this.lifecycleEventConfiguration())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (stackId() != null) {
            sb.append("StackId: ").append(stackId()).append(",");
        }
        if (typeString() != null) {
            sb.append("Type: ").append(typeString()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (shortname() != null) {
            sb.append("Shortname: ").append(shortname()).append(",");
        }
        if (attributesStrings() != null) {
            sb.append("Attributes: ").append(attributesStrings()).append(",");
        }
        if (cloudWatchLogsConfiguration() != null) {
            sb.append("CloudWatchLogsConfiguration: ").append(cloudWatchLogsConfiguration()).append(",");
        }
        if (customInstanceProfileArn() != null) {
            sb.append("CustomInstanceProfileArn: ").append(customInstanceProfileArn()).append(",");
        }
        if (customJson() != null) {
            sb.append("CustomJson: ").append(customJson()).append(",");
        }
        if (customSecurityGroupIds() != null) {
            sb.append("CustomSecurityGroupIds: ").append(customSecurityGroupIds()).append(",");
        }
        if (packages() != null) {
            sb.append("Packages: ").append(packages()).append(",");
        }
        if (volumeConfigurations() != null) {
            sb.append("VolumeConfigurations: ").append(volumeConfigurations()).append(",");
        }
        if (enableAutoHealing() != null) {
            sb.append("EnableAutoHealing: ").append(enableAutoHealing()).append(",");
        }
        if (autoAssignElasticIps() != null) {
            sb.append("AutoAssignElasticIps: ").append(autoAssignElasticIps()).append(",");
        }
        if (autoAssignPublicIps() != null) {
            sb.append("AutoAssignPublicIps: ").append(autoAssignPublicIps()).append(",");
        }
        if (customRecipes() != null) {
            sb.append("CustomRecipes: ").append(customRecipes()).append(",");
        }
        if (installUpdatesOnBoot() != null) {
            sb.append("InstallUpdatesOnBoot: ").append(installUpdatesOnBoot()).append(",");
        }
        if (useEbsOptimizedInstances() != null) {
            sb.append("UseEbsOptimizedInstances: ").append(useEbsOptimizedInstances()).append(",");
        }
        if (lifecycleEventConfiguration() != null) {
            sb.append("LifecycleEventConfiguration: ").append(lifecycleEventConfiguration()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackId":
            return Optional.of(clazz.cast(stackId()));
        case "Type":
            return Optional.of(clazz.cast(typeString()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "Shortname":
            return Optional.of(clazz.cast(shortname()));
        case "Attributes":
            return Optional.of(clazz.cast(attributesStrings()));
        case "CloudWatchLogsConfiguration":
            return Optional.of(clazz.cast(cloudWatchLogsConfiguration()));
        case "CustomInstanceProfileArn":
            return Optional.of(clazz.cast(customInstanceProfileArn()));
        case "CustomJson":
            return Optional.of(clazz.cast(customJson()));
        case "CustomSecurityGroupIds":
            return Optional.of(clazz.cast(customSecurityGroupIds()));
        case "Packages":
            return Optional.of(clazz.cast(packages()));
        case "VolumeConfigurations":
            return Optional.of(clazz.cast(volumeConfigurations()));
        case "EnableAutoHealing":
            return Optional.of(clazz.cast(enableAutoHealing()));
        case "AutoAssignElasticIps":
            return Optional.of(clazz.cast(autoAssignElasticIps()));
        case "AutoAssignPublicIps":
            return Optional.of(clazz.cast(autoAssignPublicIps()));
        case "CustomRecipes":
            return Optional.of(clazz.cast(customRecipes()));
        case "InstallUpdatesOnBoot":
            return Optional.of(clazz.cast(installUpdatesOnBoot()));
        case "UseEbsOptimizedInstances":
            return Optional.of(clazz.cast(useEbsOptimizedInstances()));
        case "LifecycleEventConfiguration":
            return Optional.of(clazz.cast(lifecycleEventConfiguration()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateLayerRequest> {
        /**
         * <p>
         * The layer stack ID.
         * </p>
         * 
         * @param stackId
         *        The layer stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The layer type. A stack cannot have more than one built-in layer of the same type. It can have any number of
         * custom layers. Built-in layers are not available in Chef 12 stacks.
         * </p>
         * 
         * @param type
         *        The layer type. A stack cannot have more than one built-in layer of the same type. It can have any
         *        number of custom layers. Built-in layers are not available in Chef 12 stacks.
         * @see LayerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LayerType
         */
        Builder type(String type);

        /**
         * <p>
         * The layer type. A stack cannot have more than one built-in layer of the same type. It can have any number of
         * custom layers. Built-in layers are not available in Chef 12 stacks.
         * </p>
         * 
         * @param type
         *        The layer type. A stack cannot have more than one built-in layer of the same type. It can have any
         *        number of custom layers. Built-in layers are not available in Chef 12 stacks.
         * @see LayerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LayerType
         */
        Builder type(LayerType type);

        /**
         * <p>
         * The layer name, which is used by the console.
         * </p>
         * 
         * @param name
         *        The layer name, which is used by the console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * For custom layers only, use this parameter to specify the layer's short name, which is used internally by AWS
         * OpsWorks Stacks and by Chef recipes. The short name is also used as the name for the directory where your app
         * files are installed. It can have a maximum of 200 characters, which are limited to the alphanumeric
         * characters, '-', '_', and '.'.
         * </p>
         * <p>
         * The built-in layers' short names are defined by AWS OpsWorks Stacks. For more information, see the <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/layers.html">Layer Reference</a>.
         * </p>
         * 
         * @param shortname
         *        For custom layers only, use this parameter to specify the layer's short name, which is used internally
         *        by AWS OpsWorks Stacks and by Chef recipes. The short name is also used as the name for the directory
         *        where your app files are installed. It can have a maximum of 200 characters, which are limited to the
         *        alphanumeric characters, '-', '_', and '.'.</p>
         *        <p>
         *        The built-in layers' short names are defined by AWS OpsWorks Stacks. For more information, see the <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/layers.html">Layer Reference</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shortname(String shortname);

        /**
         * <p>
         * One or more user-defined key-value pairs to be added to the stack attributes.
         * </p>
         * <p>
         * To create a cluster layer, set the <code>EcsClusterArn</code> attribute to the cluster's ARN.
         * </p>
         * 
         * @param attributes
         *        One or more user-defined key-value pairs to be added to the stack attributes.</p>
         *        <p>
         *        To create a cluster layer, set the <code>EcsClusterArn</code> attribute to the cluster's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * Specifies CloudWatch Logs configuration options for the layer. For more information, see
         * <a>CloudWatchLogsLogStream</a>.
         * </p>
         * 
         * @param cloudWatchLogsConfiguration
         *        Specifies CloudWatch Logs configuration options for the layer. For more information, see
         *        <a>CloudWatchLogsLogStream</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLogsConfiguration(CloudWatchLogsConfiguration cloudWatchLogsConfiguration);

        /**
         * <p>
         * The ARN of an IAM profile to be used for the layer's EC2 instances. For more information about IAM ARNs, see
         * <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
         * </p>
         * 
         * @param customInstanceProfileArn
         *        The ARN of an IAM profile to be used for the layer's EC2 instances. For more information about IAM
         *        ARNs, see <a href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using
         *        Identifiers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customInstanceProfileArn(String customInstanceProfileArn);

        /**
         * <p>
         * A JSON-formatted string containing custom stack configuration and deployment attributes to be installed on
         * the layer's instances. For more information, see <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html"> Using Custom
         * JSON</a>. This feature is supported as of version 1.7.42 of the AWS CLI.
         * </p>
         * 
         * @param customJson
         *        A JSON-formatted string containing custom stack configuration and deployment attributes to be
         *        installed on the layer's instances. For more information, see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingcookbook-json-override.html"> Using
         *        Custom JSON</a>. This feature is supported as of version 1.7.42 of the AWS CLI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customJson(String customJson);

        /**
         * <p>
         * An array containing the layer custom security group IDs.
         * </p>
         * 
         * @param customSecurityGroupIds
         *        An array containing the layer custom security group IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customSecurityGroupIds(Collection<String> customSecurityGroupIds);

        /**
         * <p>
         * An array containing the layer custom security group IDs.
         * </p>
         * 
         * @param customSecurityGroupIds
         *        An array containing the layer custom security group IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customSecurityGroupIds(String... customSecurityGroupIds);

        /**
         * <p>
         * An array of <code>Package</code> objects that describes the layer packages.
         * </p>
         * 
         * @param packages
         *        An array of <code>Package</code> objects that describes the layer packages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packages(Collection<String> packages);

        /**
         * <p>
         * An array of <code>Package</code> objects that describes the layer packages.
         * </p>
         * 
         * @param packages
         *        An array of <code>Package</code> objects that describes the layer packages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packages(String... packages);

        /**
         * <p>
         * A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.
         * </p>
         * 
         * @param volumeConfigurations
         *        A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeConfigurations(Collection<VolumeConfiguration> volumeConfigurations);

        /**
         * <p>
         * A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.
         * </p>
         * 
         * @param volumeConfigurations
         *        A <code>VolumeConfigurations</code> object that describes the layer's Amazon EBS volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeConfigurations(VolumeConfiguration... volumeConfigurations);

        /**
         * <p>
         * Whether to disable auto healing for the layer.
         * </p>
         * 
         * @param enableAutoHealing
         *        Whether to disable auto healing for the layer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableAutoHealing(Boolean enableAutoHealing);

        /**
         * <p>
         * Whether to automatically assign an <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP
         * address</a> to the layer's instances. For more information, see <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a
         * Layer</a>.
         * </p>
         * 
         * @param autoAssignElasticIps
         *        Whether to automatically assign an <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP
         *        address</a> to the layer's instances. For more information, see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit
         *        a Layer</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoAssignElasticIps(Boolean autoAssignElasticIps);

        /**
         * <p>
         * For stacks that are running in a VPC, whether to automatically assign a public IP address to the layer's
         * instances. For more information, see <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit a
         * Layer</a>.
         * </p>
         * 
         * @param autoAssignPublicIps
         *        For stacks that are running in a VPC, whether to automatically assign a public IP address to the
         *        layer's instances. For more information, see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinglayers-basics-edit.html">How to Edit
         *        a Layer</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoAssignPublicIps(Boolean autoAssignPublicIps);

        /**
         * <p>
         * A <code>LayerCustomRecipes</code> object that specifies the layer custom recipes.
         * </p>
         * 
         * @param customRecipes
         *        A <code>LayerCustomRecipes</code> object that specifies the layer custom recipes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customRecipes(Recipes customRecipes);

        /**
         * <p>
         * Whether to install operating system and package updates when the instance boots. The default value is
         * <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You must then
         * update your instances manually by using <a>CreateDeployment</a> to run the <code>update_dependencies</code>
         * stack command or by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the
         * instances.
         * </p>
         * <note>
         * <p>
         * To ensure that your instances have the latest security updates, we strongly recommend using the default value
         * of <code>true</code>.
         * </p>
         * </note>
         * 
         * @param installUpdatesOnBoot
         *        Whether to install operating system and package updates when the instance boots. The default value is
         *        <code>true</code>. To control when updates are installed, set this value to <code>false</code>. You
         *        must then update your instances manually by using <a>CreateDeployment</a> to run the
         *        <code>update_dependencies</code> stack command or by manually running <code>yum</code> (Amazon Linux)
         *        or <code>apt-get</code> (Ubuntu) on the instances. </p> <note>
         *        <p>
         *        To ensure that your instances have the latest security updates, we strongly recommend using the
         *        default value of <code>true</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder installUpdatesOnBoot(Boolean installUpdatesOnBoot);

        /**
         * <p>
         * Whether to use Amazon EBS-optimized instances.
         * </p>
         * 
         * @param useEbsOptimizedInstances
         *        Whether to use Amazon EBS-optimized instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useEbsOptimizedInstances(Boolean useEbsOptimizedInstances);

        /**
         * <p>
         * A <code>LifeCycleEventConfiguration</code> object that you can use to configure the Shutdown event to specify
         * an execution timeout and enable or disable Elastic Load Balancer connection draining.
         * </p>
         * 
         * @param lifecycleEventConfiguration
         *        A <code>LifeCycleEventConfiguration</code> object that you can use to configure the Shutdown event to
         *        specify an execution timeout and enable or disable Elastic Load Balancer connection draining.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleEventConfiguration(LifecycleEventConfiguration lifecycleEventConfiguration);
    }

    static final class BuilderImpl implements Builder {
        private String stackId;

        private String type;

        private String name;

        private String shortname;

        private Map<String, String> attributes;

        private CloudWatchLogsConfiguration cloudWatchLogsConfiguration;

        private String customInstanceProfileArn;

        private String customJson;

        private List<String> customSecurityGroupIds;

        private List<String> packages;

        private List<VolumeConfiguration> volumeConfigurations;

        private Boolean enableAutoHealing;

        private Boolean autoAssignElasticIps;

        private Boolean autoAssignPublicIps;

        private Recipes customRecipes;

        private Boolean installUpdatesOnBoot;

        private Boolean useEbsOptimizedInstances;

        private LifecycleEventConfiguration lifecycleEventConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLayerRequest model) {
            stackId(model.stackId);
            type(model.type);
            name(model.name);
            shortname(model.shortname);
            attributes(model.attributes);
            cloudWatchLogsConfiguration(model.cloudWatchLogsConfiguration);
            customInstanceProfileArn(model.customInstanceProfileArn);
            customJson(model.customJson);
            customSecurityGroupIds(model.customSecurityGroupIds);
            packages(model.packages);
            volumeConfigurations(model.volumeConfigurations);
            enableAutoHealing(model.enableAutoHealing);
            autoAssignElasticIps(model.autoAssignElasticIps);
            autoAssignPublicIps(model.autoAssignPublicIps);
            customRecipes(model.customRecipes);
            installUpdatesOnBoot(model.installUpdatesOnBoot);
            useEbsOptimizedInstances(model.useEbsOptimizedInstances);
            lifecycleEventConfiguration(model.lifecycleEventConfiguration);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(LayerType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getShortname() {
            return shortname;
        }

        @Override
        public final Builder shortname(String shortname) {
            this.shortname = shortname;
            return this;
        }

        public final void setShortname(String shortname) {
            this.shortname = shortname;
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = LayerAttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = LayerAttributesCopier.copy(attributes);
        }

        public final CloudWatchLogsConfiguration.Builder getCloudWatchLogsConfiguration() {
            return cloudWatchLogsConfiguration != null ? cloudWatchLogsConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder cloudWatchLogsConfiguration(CloudWatchLogsConfiguration cloudWatchLogsConfiguration) {
            this.cloudWatchLogsConfiguration = cloudWatchLogsConfiguration;
            return this;
        }

        public final void setCloudWatchLogsConfiguration(CloudWatchLogsConfiguration.BuilderImpl cloudWatchLogsConfiguration) {
            this.cloudWatchLogsConfiguration = cloudWatchLogsConfiguration != null ? cloudWatchLogsConfiguration.build() : null;
        }

        public final String getCustomInstanceProfileArn() {
            return customInstanceProfileArn;
        }

        @Override
        public final Builder customInstanceProfileArn(String customInstanceProfileArn) {
            this.customInstanceProfileArn = customInstanceProfileArn;
            return this;
        }

        public final void setCustomInstanceProfileArn(String customInstanceProfileArn) {
            this.customInstanceProfileArn = customInstanceProfileArn;
        }

        public final String getCustomJson() {
            return customJson;
        }

        @Override
        public final Builder customJson(String customJson) {
            this.customJson = customJson;
            return this;
        }

        public final void setCustomJson(String customJson) {
            this.customJson = customJson;
        }

        public final Collection<String> getCustomSecurityGroupIds() {
            return customSecurityGroupIds;
        }

        @Override
        public final Builder customSecurityGroupIds(Collection<String> customSecurityGroupIds) {
            this.customSecurityGroupIds = StringsCopier.copy(customSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customSecurityGroupIds(String... customSecurityGroupIds) {
            customSecurityGroupIds(Arrays.asList(customSecurityGroupIds));
            return this;
        }

        public final void setCustomSecurityGroupIds(Collection<String> customSecurityGroupIds) {
            this.customSecurityGroupIds = StringsCopier.copy(customSecurityGroupIds);
        }

        public final Collection<String> getPackages() {
            return packages;
        }

        @Override
        public final Builder packages(Collection<String> packages) {
            this.packages = StringsCopier.copy(packages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packages(String... packages) {
            packages(Arrays.asList(packages));
            return this;
        }

        public final void setPackages(Collection<String> packages) {
            this.packages = StringsCopier.copy(packages);
        }

        public final Collection<VolumeConfiguration.Builder> getVolumeConfigurations() {
            return volumeConfigurations != null ? volumeConfigurations.stream().map(VolumeConfiguration::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder volumeConfigurations(Collection<VolumeConfiguration> volumeConfigurations) {
            this.volumeConfigurations = VolumeConfigurationsCopier.copy(volumeConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumeConfigurations(VolumeConfiguration... volumeConfigurations) {
            volumeConfigurations(Arrays.asList(volumeConfigurations));
            return this;
        }

        public final void setVolumeConfigurations(Collection<VolumeConfiguration.BuilderImpl> volumeConfigurations) {
            this.volumeConfigurations = VolumeConfigurationsCopier.copyFromBuilder(volumeConfigurations);
        }

        public final Boolean getEnableAutoHealing() {
            return enableAutoHealing;
        }

        @Override
        public final Builder enableAutoHealing(Boolean enableAutoHealing) {
            this.enableAutoHealing = enableAutoHealing;
            return this;
        }

        public final void setEnableAutoHealing(Boolean enableAutoHealing) {
            this.enableAutoHealing = enableAutoHealing;
        }

        public final Boolean getAutoAssignElasticIps() {
            return autoAssignElasticIps;
        }

        @Override
        public final Builder autoAssignElasticIps(Boolean autoAssignElasticIps) {
            this.autoAssignElasticIps = autoAssignElasticIps;
            return this;
        }

        public final void setAutoAssignElasticIps(Boolean autoAssignElasticIps) {
            this.autoAssignElasticIps = autoAssignElasticIps;
        }

        public final Boolean getAutoAssignPublicIps() {
            return autoAssignPublicIps;
        }

        @Override
        public final Builder autoAssignPublicIps(Boolean autoAssignPublicIps) {
            this.autoAssignPublicIps = autoAssignPublicIps;
            return this;
        }

        public final void setAutoAssignPublicIps(Boolean autoAssignPublicIps) {
            this.autoAssignPublicIps = autoAssignPublicIps;
        }

        public final Recipes.Builder getCustomRecipes() {
            return customRecipes != null ? customRecipes.toBuilder() : null;
        }

        @Override
        public final Builder customRecipes(Recipes customRecipes) {
            this.customRecipes = customRecipes;
            return this;
        }

        public final void setCustomRecipes(Recipes.BuilderImpl customRecipes) {
            this.customRecipes = customRecipes != null ? customRecipes.build() : null;
        }

        public final Boolean getInstallUpdatesOnBoot() {
            return installUpdatesOnBoot;
        }

        @Override
        public final Builder installUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
            return this;
        }

        public final void setInstallUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
        }

        public final Boolean getUseEbsOptimizedInstances() {
            return useEbsOptimizedInstances;
        }

        @Override
        public final Builder useEbsOptimizedInstances(Boolean useEbsOptimizedInstances) {
            this.useEbsOptimizedInstances = useEbsOptimizedInstances;
            return this;
        }

        public final void setUseEbsOptimizedInstances(Boolean useEbsOptimizedInstances) {
            this.useEbsOptimizedInstances = useEbsOptimizedInstances;
        }

        public final LifecycleEventConfiguration.Builder getLifecycleEventConfiguration() {
            return lifecycleEventConfiguration != null ? lifecycleEventConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder lifecycleEventConfiguration(LifecycleEventConfiguration lifecycleEventConfiguration) {
            this.lifecycleEventConfiguration = lifecycleEventConfiguration;
            return this;
        }

        public final void setLifecycleEventConfiguration(LifecycleEventConfiguration.BuilderImpl lifecycleEventConfiguration) {
            this.lifecycleEventConfiguration = lifecycleEventConfiguration != null ? lifecycleEventConfiguration.build() : null;
        }

        @Override
        public CreateLayerRequest build() {
            return new CreateLayerRequest(this);
        }
    }
}
