/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>CreateDeployment</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateDeploymentResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateDeploymentResponse.Builder, CreateDeploymentResponse> {
    private final String deploymentId;

    private CreateDeploymentResponse(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
    }

    /**
     * <p>
     * The deployment ID, which can be used with other requests to identify the deployment.
     * </p>
     * 
     * @return The deployment ID, which can be used with other requests to identify the deployment.
     */
    public String deploymentId() {
        return deploymentId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deploymentId() == null) ? 0 : deploymentId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentResponse)) {
            return false;
        }
        CreateDeploymentResponse other = (CreateDeploymentResponse) obj;
        if (other.deploymentId() == null ^ this.deploymentId() == null) {
            return false;
        }
        if (other.deploymentId() != null && !other.deploymentId().equals(this.deploymentId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (deploymentId() != null) {
            sb.append("DeploymentId: ").append(deploymentId()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeploymentId":
            return Optional.of(clazz.cast(deploymentId()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateDeploymentResponse> {
        /**
         * <p>
         * The deployment ID, which can be used with other requests to identify the deployment.
         * </p>
         * 
         * @param deploymentId
         *        The deployment ID, which can be used with other requests to identify the deployment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);
    }

    static final class BuilderImpl implements Builder {
        private String deploymentId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentResponse model) {
            deploymentId(model.deploymentId);
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        @Override
        public CreateDeploymentResponse build() {
            return new CreateDeploymentResponse(this);
        }
    }
}
