/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateDeploymentRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateDeploymentRequest.Builder, CreateDeploymentRequest> {
    private final String stackId;

    private final String appId;

    private final List<String> instanceIds;

    private final List<String> layerIds;

    private final DeploymentCommand command;

    private final String comment;

    private final String customJson;

    private CreateDeploymentRequest(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.appId = builder.appId;
        this.instanceIds = builder.instanceIds;
        this.layerIds = builder.layerIds;
        this.command = builder.command;
        this.comment = builder.comment;
        this.customJson = builder.customJson;
    }

    /**
     * <p>
     * The stack ID.
     * </p>
     * 
     * @return The stack ID.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The app ID. This parameter is required for app deployments, but not for other deployment commands.
     * </p>
     * 
     * @return The app ID. This parameter is required for app deployments, but not for other deployment commands.
     */
    public String appId() {
        return appId;
    }

    /**
     * <p>
     * The instance IDs for the deployment targets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The instance IDs for the deployment targets.
     */
    public List<String> instanceIds() {
        return instanceIds;
    }

    /**
     * <p>
     * The layer IDs for the deployment targets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The layer IDs for the deployment targets.
     */
    public List<String> layerIds() {
        return layerIds;
    }

    /**
     * <p>
     * A <code>DeploymentCommand</code> object that specifies the deployment command and any associated arguments.
     * </p>
     * 
     * @return A <code>DeploymentCommand</code> object that specifies the deployment command and any associated
     *         arguments.
     */
    public DeploymentCommand command() {
        return command;
    }

    /**
     * <p>
     * A user-defined comment.
     * </p>
     * 
     * @return A user-defined comment.
     */
    public String comment() {
        return comment;
    }

    /**
     * <p>
     * A string that contains user-defined, custom JSON. It is used to override the corresponding default stack
     * configuration JSON values. The string should be in the following format:
     * </p>
     * <p>
     * <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
     * </p>
     * <p>
     * For more information on custom JSON, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify the
     * Stack Configuration Attributes</a>.
     * </p>
     * 
     * @return A string that contains user-defined, custom JSON. It is used to override the corresponding default stack
     *         configuration JSON values. The string should be in the following format:</p>
     *         <p>
     *         <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
     *         </p>
     *         <p>
     *         For more information on custom JSON, see <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to
     *         Modify the Stack Configuration Attributes</a>.
     */
    public String customJson() {
        return customJson;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stackId() == null) ? 0 : stackId().hashCode());
        hashCode = 31 * hashCode + ((appId() == null) ? 0 : appId().hashCode());
        hashCode = 31 * hashCode + ((instanceIds() == null) ? 0 : instanceIds().hashCode());
        hashCode = 31 * hashCode + ((layerIds() == null) ? 0 : layerIds().hashCode());
        hashCode = 31 * hashCode + ((command() == null) ? 0 : command().hashCode());
        hashCode = 31 * hashCode + ((comment() == null) ? 0 : comment().hashCode());
        hashCode = 31 * hashCode + ((customJson() == null) ? 0 : customJson().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDeploymentRequest)) {
            return false;
        }
        CreateDeploymentRequest other = (CreateDeploymentRequest) obj;
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.appId() == null ^ this.appId() == null) {
            return false;
        }
        if (other.appId() != null && !other.appId().equals(this.appId())) {
            return false;
        }
        if (other.instanceIds() == null ^ this.instanceIds() == null) {
            return false;
        }
        if (other.instanceIds() != null && !other.instanceIds().equals(this.instanceIds())) {
            return false;
        }
        if (other.layerIds() == null ^ this.layerIds() == null) {
            return false;
        }
        if (other.layerIds() != null && !other.layerIds().equals(this.layerIds())) {
            return false;
        }
        if (other.command() == null ^ this.command() == null) {
            return false;
        }
        if (other.command() != null && !other.command().equals(this.command())) {
            return false;
        }
        if (other.comment() == null ^ this.comment() == null) {
            return false;
        }
        if (other.comment() != null && !other.comment().equals(this.comment())) {
            return false;
        }
        if (other.customJson() == null ^ this.customJson() == null) {
            return false;
        }
        if (other.customJson() != null && !other.customJson().equals(this.customJson())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (stackId() != null) {
            sb.append("StackId: ").append(stackId()).append(",");
        }
        if (appId() != null) {
            sb.append("AppId: ").append(appId()).append(",");
        }
        if (instanceIds() != null) {
            sb.append("InstanceIds: ").append(instanceIds()).append(",");
        }
        if (layerIds() != null) {
            sb.append("LayerIds: ").append(layerIds()).append(",");
        }
        if (command() != null) {
            sb.append("Command: ").append(command()).append(",");
        }
        if (comment() != null) {
            sb.append("Comment: ").append(comment()).append(",");
        }
        if (customJson() != null) {
            sb.append("CustomJson: ").append(customJson()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackId":
            return Optional.of(clazz.cast(stackId()));
        case "AppId":
            return Optional.of(clazz.cast(appId()));
        case "InstanceIds":
            return Optional.of(clazz.cast(instanceIds()));
        case "LayerIds":
            return Optional.of(clazz.cast(layerIds()));
        case "Command":
            return Optional.of(clazz.cast(command()));
        case "Comment":
            return Optional.of(clazz.cast(comment()));
        case "CustomJson":
            return Optional.of(clazz.cast(customJson()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateDeploymentRequest> {
        /**
         * <p>
         * The stack ID.
         * </p>
         * 
         * @param stackId
         *        The stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The app ID. This parameter is required for app deployments, but not for other deployment commands.
         * </p>
         * 
         * @param appId
         *        The app ID. This parameter is required for app deployments, but not for other deployment commands.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * The instance IDs for the deployment targets.
         * </p>
         * 
         * @param instanceIds
         *        The instance IDs for the deployment targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(Collection<String> instanceIds);

        /**
         * <p>
         * The instance IDs for the deployment targets.
         * </p>
         * 
         * @param instanceIds
         *        The instance IDs for the deployment targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(String... instanceIds);

        /**
         * <p>
         * The layer IDs for the deployment targets.
         * </p>
         * 
         * @param layerIds
         *        The layer IDs for the deployment targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerIds(Collection<String> layerIds);

        /**
         * <p>
         * The layer IDs for the deployment targets.
         * </p>
         * 
         * @param layerIds
         *        The layer IDs for the deployment targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerIds(String... layerIds);

        /**
         * <p>
         * A <code>DeploymentCommand</code> object that specifies the deployment command and any associated arguments.
         * </p>
         * 
         * @param command
         *        A <code>DeploymentCommand</code> object that specifies the deployment command and any associated
         *        arguments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder command(DeploymentCommand command);

        /**
         * <p>
         * A user-defined comment.
         * </p>
         * 
         * @param comment
         *        A user-defined comment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * A string that contains user-defined, custom JSON. It is used to override the corresponding default stack
         * configuration JSON values. The string should be in the following format:
         * </p>
         * <p>
         * <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
         * </p>
         * <p>
         * For more information on custom JSON, see <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify
         * the Stack Configuration Attributes</a>.
         * </p>
         * 
         * @param customJson
         *        A string that contains user-defined, custom JSON. It is used to override the corresponding default
         *        stack configuration JSON values. The string should be in the following format:</p>
         *        <p>
         *        <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
         *        </p>
         *        <p>
         *        For more information on custom JSON, see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to
         *        Modify the Stack Configuration Attributes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customJson(String customJson);
    }

    static final class BuilderImpl implements Builder {
        private String stackId;

        private String appId;

        private List<String> instanceIds;

        private List<String> layerIds;

        private DeploymentCommand command;

        private String comment;

        private String customJson;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDeploymentRequest model) {
            stackId(model.stackId);
            appId(model.appId);
            instanceIds(model.instanceIds);
            layerIds(model.layerIds);
            command(model.command);
            comment(model.comment);
            customJson(model.customJson);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getAppId() {
            return appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final Collection<String> getInstanceIds() {
            return instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = StringsCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String... instanceIds) {
            instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = StringsCopier.copy(instanceIds);
        }

        public final Collection<String> getLayerIds() {
            return layerIds;
        }

        @Override
        public final Builder layerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layerIds(String... layerIds) {
            layerIds(Arrays.asList(layerIds));
            return this;
        }

        public final void setLayerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
        }

        public final DeploymentCommand.Builder getCommand() {
            return command != null ? command.toBuilder() : null;
        }

        @Override
        public final Builder command(DeploymentCommand command) {
            this.command = command;
            return this;
        }

        public final void setCommand(DeploymentCommand.BuilderImpl command) {
            this.command = command != null ? command.build() : null;
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final String getCustomJson() {
            return customJson;
        }

        @Override
        public final Builder customJson(String customJson) {
            this.customJson = customJson;
            return this;
        }

        public final void setCustomJson(String customJson) {
            this.customJson = customJson;
        }

        @Override
        public CreateDeploymentRequest build() {
            return new CreateDeploymentRequest(this);
        }
    }
}
