/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Generated;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.runtime.TypeConverter;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateAppRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateAppRequest.Builder, CreateAppRequest> {
    private final String stackId;

    private final String shortname;

    private final String name;

    private final String description;

    private final List<DataSource> dataSources;

    private final String type;

    private final Source appSource;

    private final List<String> domains;

    private final Boolean enableSsl;

    private final SslConfiguration sslConfiguration;

    private final Map<String, String> attributes;

    private final List<EnvironmentVariable> environment;

    private CreateAppRequest(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.shortname = builder.shortname;
        this.name = builder.name;
        this.description = builder.description;
        this.dataSources = builder.dataSources;
        this.type = builder.type;
        this.appSource = builder.appSource;
        this.domains = builder.domains;
        this.enableSsl = builder.enableSsl;
        this.sslConfiguration = builder.sslConfiguration;
        this.attributes = builder.attributes;
        this.environment = builder.environment;
    }

    /**
     * <p>
     * The stack ID.
     * </p>
     * 
     * @return The stack ID.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The app's short name.
     * </p>
     * 
     * @return The app's short name.
     */
    public String shortname() {
        return shortname;
    }

    /**
     * <p>
     * The app name.
     * </p>
     * 
     * @return The app name.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * A description of the app.
     * </p>
     * 
     * @return A description of the app.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The app's data source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The app's data source.
     */
    public List<DataSource> dataSources() {
        return dataSources;
    }

    /**
     * <p>
     * The app type. Each supported type is associated with a particular layer. For example, PHP applications are
     * associated with a PHP layer. AWS OpsWorks Stacks deploys an application to those instances that are members of
     * the corresponding layer. If your app isn't one of the standard types, or you prefer to implement your own Deploy
     * recipes, specify <code>other</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AppType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The app type. Each supported type is associated with a particular layer. For example, PHP applications
     *         are associated with a PHP layer. AWS OpsWorks Stacks deploys an application to those instances that are
     *         members of the corresponding layer. If your app isn't one of the standard types, or you prefer to
     *         implement your own Deploy recipes, specify <code>other</code>.
     * @see AppType
     */
    public AppType type() {
        return AppType.fromValue(type);
    }

    /**
     * <p>
     * The app type. Each supported type is associated with a particular layer. For example, PHP applications are
     * associated with a PHP layer. AWS OpsWorks Stacks deploys an application to those instances that are members of
     * the corresponding layer. If your app isn't one of the standard types, or you prefer to implement your own Deploy
     * recipes, specify <code>other</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link AppType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeString}.
     * </p>
     * 
     * @return The app type. Each supported type is associated with a particular layer. For example, PHP applications
     *         are associated with a PHP layer. AWS OpsWorks Stacks deploys an application to those instances that are
     *         members of the corresponding layer. If your app isn't one of the standard types, or you prefer to
     *         implement your own Deploy recipes, specify <code>other</code>.
     * @see AppType
     */
    public String typeString() {
        return type;
    }

    /**
     * <p>
     * A <code>Source</code> object that specifies the app repository.
     * </p>
     * 
     * @return A <code>Source</code> object that specifies the app repository.
     */
    public Source appSource() {
        return appSource;
    }

    /**
     * <p>
     * The app virtual host settings, with multiple domains separated by commas. For example:
     * <code>'www.example.com, example.com'</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The app virtual host settings, with multiple domains separated by commas. For example:
     *         <code>'www.example.com, example.com'</code>
     */
    public List<String> domains() {
        return domains;
    }

    /**
     * <p>
     * Whether to enable SSL for the app.
     * </p>
     * 
     * @return Whether to enable SSL for the app.
     */
    public Boolean enableSsl() {
        return enableSsl;
    }

    /**
     * <p>
     * An <code>SslConfiguration</code> object with the SSL configuration.
     * </p>
     * 
     * @return An <code>SslConfiguration</code> object with the SSL configuration.
     */
    public SslConfiguration sslConfiguration() {
        return sslConfiguration;
    }

    /**
     * <p>
     * One or more user-defined key/value pairs to be added to the stack attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more user-defined key/value pairs to be added to the stack attributes.
     */
    public Map<AppAttributesKeys, String> attributes() {
        return TypeConverter.convert(attributes, AppAttributesKeys::fromValue, Function.identity(),
                (k, v) -> !Objects.equals(k, AppAttributesKeys.UNKNOWN_TO_SDK_VERSION));
    }

    /**
     * <p>
     * One or more user-defined key/value pairs to be added to the stack attributes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more user-defined key/value pairs to be added to the stack attributes.
     */
    public Map<String, String> attributesStrings() {
        return attributes;
    }

    /**
     * <p>
     * An array of <code>EnvironmentVariable</code> objects that specify environment variables to be associated with the
     * app. After you deploy the app, these variables are defined on the associated app server instance. For more
     * information, see <a href=
     * "http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"
     * > Environment Variables</a>.
     * </p>
     * <p>
     * There is no specific limit on the number of environment variables. However, the size of the associated data
     * structure - which includes the variables' names, values, and protected flag values - cannot exceed 10 KB (10240
     * Bytes). This limit should accommodate most if not all use cases. Exceeding it will cause an exception with the
     * message, "Environment: is too large (maximum is 10KB)."
     * </p>
     * <note>
     * <p>
     * This parameter is supported only by Chef 11.10 stacks. If you have specified one or more environment variables,
     * you cannot modify the stack's Chef version.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>EnvironmentVariable</code> objects that specify environment variables to be associated
     *         with the app. After you deploy the app, these variables are defined on the associated app server
     *         instance. For more information, see <a href=
     *         "http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"
     *         > Environment Variables</a>.</p>
     *         <p>
     *         There is no specific limit on the number of environment variables. However, the size of the associated
     *         data structure - which includes the variables' names, values, and protected flag values - cannot exceed
     *         10 KB (10240 Bytes). This limit should accommodate most if not all use cases. Exceeding it will cause an
     *         exception with the message, "Environment: is too large (maximum is 10KB)."
     *         </p>
     *         <note>
     *         <p>
     *         This parameter is supported only by Chef 11.10 stacks. If you have specified one or more environment
     *         variables, you cannot modify the stack's Chef version.
     *         </p>
     */
    public List<EnvironmentVariable> environment() {
        return environment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stackId() == null) ? 0 : stackId().hashCode());
        hashCode = 31 * hashCode + ((shortname() == null) ? 0 : shortname().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((dataSources() == null) ? 0 : dataSources().hashCode());
        hashCode = 31 * hashCode + ((typeString() == null) ? 0 : typeString().hashCode());
        hashCode = 31 * hashCode + ((appSource() == null) ? 0 : appSource().hashCode());
        hashCode = 31 * hashCode + ((domains() == null) ? 0 : domains().hashCode());
        hashCode = 31 * hashCode + ((enableSsl() == null) ? 0 : enableSsl().hashCode());
        hashCode = 31 * hashCode + ((sslConfiguration() == null) ? 0 : sslConfiguration().hashCode());
        hashCode = 31 * hashCode + ((attributesStrings() == null) ? 0 : attributesStrings().hashCode());
        hashCode = 31 * hashCode + ((environment() == null) ? 0 : environment().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAppRequest)) {
            return false;
        }
        CreateAppRequest other = (CreateAppRequest) obj;
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.shortname() == null ^ this.shortname() == null) {
            return false;
        }
        if (other.shortname() != null && !other.shortname().equals(this.shortname())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.dataSources() == null ^ this.dataSources() == null) {
            return false;
        }
        if (other.dataSources() != null && !other.dataSources().equals(this.dataSources())) {
            return false;
        }
        if (other.typeString() == null ^ this.typeString() == null) {
            return false;
        }
        if (other.typeString() != null && !other.typeString().equals(this.typeString())) {
            return false;
        }
        if (other.appSource() == null ^ this.appSource() == null) {
            return false;
        }
        if (other.appSource() != null && !other.appSource().equals(this.appSource())) {
            return false;
        }
        if (other.domains() == null ^ this.domains() == null) {
            return false;
        }
        if (other.domains() != null && !other.domains().equals(this.domains())) {
            return false;
        }
        if (other.enableSsl() == null ^ this.enableSsl() == null) {
            return false;
        }
        if (other.enableSsl() != null && !other.enableSsl().equals(this.enableSsl())) {
            return false;
        }
        if (other.sslConfiguration() == null ^ this.sslConfiguration() == null) {
            return false;
        }
        if (other.sslConfiguration() != null && !other.sslConfiguration().equals(this.sslConfiguration())) {
            return false;
        }
        if (other.attributesStrings() == null ^ this.attributesStrings() == null) {
            return false;
        }
        if (other.attributesStrings() != null && !other.attributesStrings().equals(this.attributesStrings())) {
            return false;
        }
        if (other.environment() == null ^ this.environment() == null) {
            return false;
        }
        if (other.environment() != null && !other.environment().equals(this.environment())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (stackId() != null) {
            sb.append("StackId: ").append(stackId()).append(",");
        }
        if (shortname() != null) {
            sb.append("Shortname: ").append(shortname()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (dataSources() != null) {
            sb.append("DataSources: ").append(dataSources()).append(",");
        }
        if (typeString() != null) {
            sb.append("Type: ").append(typeString()).append(",");
        }
        if (appSource() != null) {
            sb.append("AppSource: ").append(appSource()).append(",");
        }
        if (domains() != null) {
            sb.append("Domains: ").append(domains()).append(",");
        }
        if (enableSsl() != null) {
            sb.append("EnableSsl: ").append(enableSsl()).append(",");
        }
        if (sslConfiguration() != null) {
            sb.append("SslConfiguration: ").append(sslConfiguration()).append(",");
        }
        if (attributesStrings() != null) {
            sb.append("Attributes: ").append(attributesStrings()).append(",");
        }
        if (environment() != null) {
            sb.append("Environment: ").append(environment()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackId":
            return Optional.of(clazz.cast(stackId()));
        case "Shortname":
            return Optional.of(clazz.cast(shortname()));
        case "Name":
            return Optional.of(clazz.cast(name()));
        case "Description":
            return Optional.of(clazz.cast(description()));
        case "DataSources":
            return Optional.of(clazz.cast(dataSources()));
        case "Type":
            return Optional.of(clazz.cast(typeString()));
        case "AppSource":
            return Optional.of(clazz.cast(appSource()));
        case "Domains":
            return Optional.of(clazz.cast(domains()));
        case "EnableSsl":
            return Optional.of(clazz.cast(enableSsl()));
        case "SslConfiguration":
            return Optional.of(clazz.cast(sslConfiguration()));
        case "Attributes":
            return Optional.of(clazz.cast(attributesStrings()));
        case "Environment":
            return Optional.of(clazz.cast(environment()));
        default:
            return Optional.empty();
        }
    }

    public interface Builder extends CopyableBuilder<Builder, CreateAppRequest> {
        /**
         * <p>
         * The stack ID.
         * </p>
         * 
         * @param stackId
         *        The stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The app's short name.
         * </p>
         * 
         * @param shortname
         *        The app's short name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shortname(String shortname);

        /**
         * <p>
         * The app name.
         * </p>
         * 
         * @param name
         *        The app name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the app.
         * </p>
         * 
         * @param description
         *        A description of the app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The app's data source.
         * </p>
         * 
         * @param dataSources
         *        The app's data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(Collection<DataSource> dataSources);

        /**
         * <p>
         * The app's data source.
         * </p>
         * 
         * @param dataSources
         *        The app's data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(DataSource... dataSources);

        /**
         * <p>
         * The app type. Each supported type is associated with a particular layer. For example, PHP applications are
         * associated with a PHP layer. AWS OpsWorks Stacks deploys an application to those instances that are members
         * of the corresponding layer. If your app isn't one of the standard types, or you prefer to implement your own
         * Deploy recipes, specify <code>other</code>.
         * </p>
         * 
         * @param type
         *        The app type. Each supported type is associated with a particular layer. For example, PHP applications
         *        are associated with a PHP layer. AWS OpsWorks Stacks deploys an application to those instances that
         *        are members of the corresponding layer. If your app isn't one of the standard types, or you prefer to
         *        implement your own Deploy recipes, specify <code>other</code>.
         * @see AppType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppType
         */
        Builder type(String type);

        /**
         * <p>
         * The app type. Each supported type is associated with a particular layer. For example, PHP applications are
         * associated with a PHP layer. AWS OpsWorks Stacks deploys an application to those instances that are members
         * of the corresponding layer. If your app isn't one of the standard types, or you prefer to implement your own
         * Deploy recipes, specify <code>other</code>.
         * </p>
         * 
         * @param type
         *        The app type. Each supported type is associated with a particular layer. For example, PHP applications
         *        are associated with a PHP layer. AWS OpsWorks Stacks deploys an application to those instances that
         *        are members of the corresponding layer. If your app isn't one of the standard types, or you prefer to
         *        implement your own Deploy recipes, specify <code>other</code>.
         * @see AppType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AppType
         */
        Builder type(AppType type);

        /**
         * <p>
         * A <code>Source</code> object that specifies the app repository.
         * </p>
         * 
         * @param appSource
         *        A <code>Source</code> object that specifies the app repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appSource(Source appSource);

        /**
         * <p>
         * The app virtual host settings, with multiple domains separated by commas. For example:
         * <code>'www.example.com, example.com'</code>
         * </p>
         * 
         * @param domains
         *        The app virtual host settings, with multiple domains separated by commas. For example:
         *        <code>'www.example.com, example.com'</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domains(Collection<String> domains);

        /**
         * <p>
         * The app virtual host settings, with multiple domains separated by commas. For example:
         * <code>'www.example.com, example.com'</code>
         * </p>
         * 
         * @param domains
         *        The app virtual host settings, with multiple domains separated by commas. For example:
         *        <code>'www.example.com, example.com'</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domains(String... domains);

        /**
         * <p>
         * Whether to enable SSL for the app.
         * </p>
         * 
         * @param enableSsl
         *        Whether to enable SSL for the app.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableSsl(Boolean enableSsl);

        /**
         * <p>
         * An <code>SslConfiguration</code> object with the SSL configuration.
         * </p>
         * 
         * @param sslConfiguration
         *        An <code>SslConfiguration</code> object with the SSL configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sslConfiguration(SslConfiguration sslConfiguration);

        /**
         * <p>
         * One or more user-defined key/value pairs to be added to the stack attributes.
         * </p>
         * 
         * @param attributes
         *        One or more user-defined key/value pairs to be added to the stack attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Map<String, String> attributes);

        /**
         * <p>
         * An array of <code>EnvironmentVariable</code> objects that specify environment variables to be associated with
         * the app. After you deploy the app, these variables are defined on the associated app server instance. For
         * more information, see <a href=
         * "http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"
         * > Environment Variables</a>.
         * </p>
         * <p>
         * There is no specific limit on the number of environment variables. However, the size of the associated data
         * structure - which includes the variables' names, values, and protected flag values - cannot exceed 10 KB
         * (10240 Bytes). This limit should accommodate most if not all use cases. Exceeding it will cause an exception
         * with the message, "Environment: is too large (maximum is 10KB)."
         * </p>
         * <note>
         * <p>
         * This parameter is supported only by Chef 11.10 stacks. If you have specified one or more environment
         * variables, you cannot modify the stack's Chef version.
         * </p>
         * </note>
         * 
         * @param environment
         *        An array of <code>EnvironmentVariable</code> objects that specify environment variables to be
         *        associated with the app. After you deploy the app, these variables are defined on the associated app
         *        server instance. For more information, see <a href=
         *        "http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"
         *        > Environment Variables</a>.</p>
         *        <p>
         *        There is no specific limit on the number of environment variables. However, the size of the associated
         *        data structure - which includes the variables' names, values, and protected flag values - cannot
         *        exceed 10 KB (10240 Bytes). This limit should accommodate most if not all use cases. Exceeding it will
         *        cause an exception with the message, "Environment: is too large (maximum is 10KB)."
         *        </p>
         *        <note>
         *        <p>
         *        This parameter is supported only by Chef 11.10 stacks. If you have specified one or more environment
         *        variables, you cannot modify the stack's Chef version.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(Collection<EnvironmentVariable> environment);

        /**
         * <p>
         * An array of <code>EnvironmentVariable</code> objects that specify environment variables to be associated with
         * the app. After you deploy the app, these variables are defined on the associated app server instance. For
         * more information, see <a href=
         * "http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"
         * > Environment Variables</a>.
         * </p>
         * <p>
         * There is no specific limit on the number of environment variables. However, the size of the associated data
         * structure - which includes the variables' names, values, and protected flag values - cannot exceed 10 KB
         * (10240 Bytes). This limit should accommodate most if not all use cases. Exceeding it will cause an exception
         * with the message, "Environment: is too large (maximum is 10KB)."
         * </p>
         * <note>
         * <p>
         * This parameter is supported only by Chef 11.10 stacks. If you have specified one or more environment
         * variables, you cannot modify the stack's Chef version.
         * </p>
         * </note>
         * 
         * @param environment
         *        An array of <code>EnvironmentVariable</code> objects that specify environment variables to be
         *        associated with the app. After you deploy the app, these variables are defined on the associated app
         *        server instance. For more information, see <a href=
         *        "http://docs.aws.amazon.com/opsworks/latest/userguide/workingapps-creating.html#workingapps-creating-environment"
         *        > Environment Variables</a>.</p>
         *        <p>
         *        There is no specific limit on the number of environment variables. However, the size of the associated
         *        data structure - which includes the variables' names, values, and protected flag values - cannot
         *        exceed 10 KB (10240 Bytes). This limit should accommodate most if not all use cases. Exceeding it will
         *        cause an exception with the message, "Environment: is too large (maximum is 10KB)."
         *        </p>
         *        <note>
         *        <p>
         *        This parameter is supported only by Chef 11.10 stacks. If you have specified one or more environment
         *        variables, you cannot modify the stack's Chef version.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder environment(EnvironmentVariable... environment);
    }

    static final class BuilderImpl implements Builder {
        private String stackId;

        private String shortname;

        private String name;

        private String description;

        private List<DataSource> dataSources;

        private String type;

        private Source appSource;

        private List<String> domains;

        private Boolean enableSsl;

        private SslConfiguration sslConfiguration;

        private Map<String, String> attributes;

        private List<EnvironmentVariable> environment;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAppRequest model) {
            stackId(model.stackId);
            shortname(model.shortname);
            name(model.name);
            description(model.description);
            dataSources(model.dataSources);
            type(model.type);
            appSource(model.appSource);
            domains(model.domains);
            enableSsl(model.enableSsl);
            sslConfiguration(model.sslConfiguration);
            attributes(model.attributes);
            environment(model.environment);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getShortname() {
            return shortname;
        }

        @Override
        public final Builder shortname(String shortname) {
            this.shortname = shortname;
            return this;
        }

        public final void setShortname(String shortname) {
            this.shortname = shortname;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<DataSource.Builder> getDataSources() {
            return dataSources != null ? dataSources.stream().map(DataSource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dataSources(Collection<DataSource> dataSources) {
            this.dataSources = DataSourcesCopier.copy(dataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(DataSource... dataSources) {
            dataSources(Arrays.asList(dataSources));
            return this;
        }

        public final void setDataSources(Collection<DataSource.BuilderImpl> dataSources) {
            this.dataSources = DataSourcesCopier.copyFromBuilder(dataSources);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AppType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Source.Builder getAppSource() {
            return appSource != null ? appSource.toBuilder() : null;
        }

        @Override
        public final Builder appSource(Source appSource) {
            this.appSource = appSource;
            return this;
        }

        public final void setAppSource(Source.BuilderImpl appSource) {
            this.appSource = appSource != null ? appSource.build() : null;
        }

        public final Collection<String> getDomains() {
            return domains;
        }

        @Override
        public final Builder domains(Collection<String> domains) {
            this.domains = StringsCopier.copy(domains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(String... domains) {
            domains(Arrays.asList(domains));
            return this;
        }

        public final void setDomains(Collection<String> domains) {
            this.domains = StringsCopier.copy(domains);
        }

        public final Boolean getEnableSsl() {
            return enableSsl;
        }

        @Override
        public final Builder enableSsl(Boolean enableSsl) {
            this.enableSsl = enableSsl;
            return this;
        }

        public final void setEnableSsl(Boolean enableSsl) {
            this.enableSsl = enableSsl;
        }

        public final SslConfiguration.Builder getSslConfiguration() {
            return sslConfiguration != null ? sslConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder sslConfiguration(SslConfiguration sslConfiguration) {
            this.sslConfiguration = sslConfiguration;
            return this;
        }

        public final void setSslConfiguration(SslConfiguration.BuilderImpl sslConfiguration) {
            this.sslConfiguration = sslConfiguration != null ? sslConfiguration.build() : null;
        }

        public final Map<String, String> getAttributes() {
            return attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AppAttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AppAttributesCopier.copy(attributes);
        }

        public final Collection<EnvironmentVariable.Builder> getEnvironment() {
            return environment != null ? environment.stream().map(EnvironmentVariable::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder environment(Collection<EnvironmentVariable> environment) {
            this.environment = EnvironmentVariablesCopier.copy(environment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(EnvironmentVariable... environment) {
            environment(Arrays.asList(environment));
            return this;
        }

        public final void setEnvironment(Collection<EnvironmentVariable.BuilderImpl> environment) {
            this.environment = EnvironmentVariablesCopier.copyFromBuilder(environment);
        }

        @Override
        public CreateAppRequest build() {
            return new CreateAppRequest(this);
        }
    }
}
