/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.CloudWatchLogsLogStreamMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Amazon CloudWatch logs configuration for a layer. For detailed information about members of this data
 * type, see the <a href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AgentReference.html">CloudWatch Logs
 * Agent Reference</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CloudWatchLogsLogStream implements StructuredPojo,
        ToCopyableBuilder<CloudWatchLogsLogStream.Builder, CloudWatchLogsLogStream> {
    private final String logGroupName;

    private final String datetimeFormat;

    private final String timeZone;

    private final String file;

    private final String fileFingerprintLines;

    private final String multiLineStartPattern;

    private final String initialPosition;

    private final String encoding;

    private final Integer bufferDuration;

    private final Integer batchCount;

    private final Integer batchSize;

    private CloudWatchLogsLogStream(BuilderImpl builder) {
        this.logGroupName = builder.logGroupName;
        this.datetimeFormat = builder.datetimeFormat;
        this.timeZone = builder.timeZone;
        this.file = builder.file;
        this.fileFingerprintLines = builder.fileFingerprintLines;
        this.multiLineStartPattern = builder.multiLineStartPattern;
        this.initialPosition = builder.initialPosition;
        this.encoding = builder.encoding;
        this.bufferDuration = builder.bufferDuration;
        this.batchCount = builder.batchCount;
        this.batchSize = builder.batchSize;
    }

    /**
     * <p>
     * Specifies the destination log group. A log group is created automatically if it doesn't already exist. Log group
     * names can be between 1 and 512 characters long. Allowed characters include a-z, A-Z, 0-9, '_' (underscore), '-'
     * (hyphen), '/' (forward slash), and '.' (period).
     * </p>
     * 
     * @return Specifies the destination log group. A log group is created automatically if it doesn't already exist.
     *         Log group names can be between 1 and 512 characters long. Allowed characters include a-z, A-Z, 0-9, '_'
     *         (underscore), '-' (hyphen), '/' (forward slash), and '.' (period).
     */
    public String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * Specifies how the time stamp is extracted from logs. For more information, see the <a
     * href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AgentReference.html">CloudWatch Logs Agent
     * Reference</a>.
     * </p>
     * 
     * @return Specifies how the time stamp is extracted from logs. For more information, see the <a
     *         href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AgentReference.html">CloudWatch Logs Agent
     *         Reference</a>.
     */
    public String datetimeFormat() {
        return datetimeFormat;
    }

    /**
     * <p>
     * Specifies the time zone of log event time stamps.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeZone} will
     * return {@link CloudWatchLogsTimeZone#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #timeZoneString}.
     * </p>
     * 
     * @return Specifies the time zone of log event time stamps.
     * @see CloudWatchLogsTimeZone
     */
    public CloudWatchLogsTimeZone timeZone() {
        return CloudWatchLogsTimeZone.fromValue(timeZone);
    }

    /**
     * <p>
     * Specifies the time zone of log event time stamps.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #timeZone} will
     * return {@link CloudWatchLogsTimeZone#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #timeZoneString}.
     * </p>
     * 
     * @return Specifies the time zone of log event time stamps.
     * @see CloudWatchLogsTimeZone
     */
    public String timeZoneString() {
        return timeZone;
    }

    /**
     * <p>
     * Specifies log files that you want to push to CloudWatch Logs.
     * </p>
     * <p>
     * <code>File</code> can point to a specific file or multiple files (by using wild card characters such as
     * <code>/var/log/system.log*</code>). Only the latest file is pushed to CloudWatch Logs, based on file modification
     * time. We recommend that you use wild card characters to specify a series of files of the same type, such as
     * <code>access_log.2014-06-01-01</code>, <code>access_log.2014-06-01-02</code>, and so on by using a pattern like
     * <code>access_log.*</code>. Don't use a wildcard to match multiple file types, such as <code>access_log_80</code>
     * and <code>access_log_443</code>. To specify multiple, different file types, add another log stream entry to the
     * configuration file, so that each log file type is stored in a different log group.
     * </p>
     * <p>
     * Zipped files are not supported.
     * </p>
     * 
     * @return Specifies log files that you want to push to CloudWatch Logs.</p>
     *         <p>
     *         <code>File</code> can point to a specific file or multiple files (by using wild card characters such as
     *         <code>/var/log/system.log*</code>). Only the latest file is pushed to CloudWatch Logs, based on file
     *         modification time. We recommend that you use wild card characters to specify a series of files of the
     *         same type, such as <code>access_log.2014-06-01-01</code>, <code>access_log.2014-06-01-02</code>, and so
     *         on by using a pattern like <code>access_log.*</code>. Don't use a wildcard to match multiple file types,
     *         such as <code>access_log_80</code> and <code>access_log_443</code>. To specify multiple, different file
     *         types, add another log stream entry to the configuration file, so that each log file type is stored in a
     *         different log group.
     *         </p>
     *         <p>
     *         Zipped files are not supported.
     */
    public String file() {
        return file;
    }

    /**
     * <p>
     * Specifies the range of lines for identifying a file. The valid values are one number, or two dash-delimited
     * numbers, such as '1', '2-5'. The default value is '1', meaning the first line is used to calculate the
     * fingerprint. Fingerprint lines are not sent to CloudWatch Logs unless all specified lines are available.
     * </p>
     * 
     * @return Specifies the range of lines for identifying a file. The valid values are one number, or two
     *         dash-delimited numbers, such as '1', '2-5'. The default value is '1', meaning the first line is used to
     *         calculate the fingerprint. Fingerprint lines are not sent to CloudWatch Logs unless all specified lines
     *         are available.
     */
    public String fileFingerprintLines() {
        return fileFingerprintLines;
    }

    /**
     * <p>
     * Specifies the pattern for identifying the start of a log message.
     * </p>
     * 
     * @return Specifies the pattern for identifying the start of a log message.
     */
    public String multiLineStartPattern() {
        return multiLineStartPattern;
    }

    /**
     * <p>
     * Specifies where to start to read data (start_of_file or end_of_file). The default is start_of_file. This setting
     * is only used if there is no state persisted for that log stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #initialPosition}
     * will return {@link CloudWatchLogsInitialPosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #initialPositionString}.
     * </p>
     * 
     * @return Specifies where to start to read data (start_of_file or end_of_file). The default is start_of_file. This
     *         setting is only used if there is no state persisted for that log stream.
     * @see CloudWatchLogsInitialPosition
     */
    public CloudWatchLogsInitialPosition initialPosition() {
        return CloudWatchLogsInitialPosition.fromValue(initialPosition);
    }

    /**
     * <p>
     * Specifies where to start to read data (start_of_file or end_of_file). The default is start_of_file. This setting
     * is only used if there is no state persisted for that log stream.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #initialPosition}
     * will return {@link CloudWatchLogsInitialPosition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #initialPositionString}.
     * </p>
     * 
     * @return Specifies where to start to read data (start_of_file or end_of_file). The default is start_of_file. This
     *         setting is only used if there is no state persisted for that log stream.
     * @see CloudWatchLogsInitialPosition
     */
    public String initialPositionString() {
        return initialPosition;
    }

    /**
     * <p>
     * Specifies the encoding of the log file so that the file can be read correctly. The default is <code>utf_8</code>.
     * Encodings supported by Python <code>codecs.decode()</code> can be used here.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encoding} will
     * return {@link CloudWatchLogsEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encodingString}.
     * </p>
     * 
     * @return Specifies the encoding of the log file so that the file can be read correctly. The default is
     *         <code>utf_8</code>. Encodings supported by Python <code>codecs.decode()</code> can be used here.
     * @see CloudWatchLogsEncoding
     */
    public CloudWatchLogsEncoding encoding() {
        return CloudWatchLogsEncoding.fromValue(encoding);
    }

    /**
     * <p>
     * Specifies the encoding of the log file so that the file can be read correctly. The default is <code>utf_8</code>.
     * Encodings supported by Python <code>codecs.decode()</code> can be used here.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #encoding} will
     * return {@link CloudWatchLogsEncoding#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #encodingString}.
     * </p>
     * 
     * @return Specifies the encoding of the log file so that the file can be read correctly. The default is
     *         <code>utf_8</code>. Encodings supported by Python <code>codecs.decode()</code> can be used here.
     * @see CloudWatchLogsEncoding
     */
    public String encodingString() {
        return encoding;
    }

    /**
     * <p>
     * Specifies the time duration for the batching of log events. The minimum value is 5000ms and default value is
     * 5000ms.
     * </p>
     * 
     * @return Specifies the time duration for the batching of log events. The minimum value is 5000ms and default value
     *         is 5000ms.
     */
    public Integer bufferDuration() {
        return bufferDuration;
    }

    /**
     * <p>
     * Specifies the max number of log events in a batch, up to 10000. The default value is 1000.
     * </p>
     * 
     * @return Specifies the max number of log events in a batch, up to 10000. The default value is 1000.
     */
    public Integer batchCount() {
        return batchCount;
    }

    /**
     * <p>
     * Specifies the maximum size of log events in a batch, in bytes, up to 1048576 bytes. The default value is 32768
     * bytes. This size is calculated as the sum of all event messages in UTF-8, plus 26 bytes for each log event.
     * </p>
     * 
     * @return Specifies the maximum size of log events in a batch, in bytes, up to 1048576 bytes. The default value is
     *         32768 bytes. This size is calculated as the sum of all event messages in UTF-8, plus 26 bytes for each
     *         log event.
     */
    public Integer batchSize() {
        return batchSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((logGroupName() == null) ? 0 : logGroupName().hashCode());
        hashCode = 31 * hashCode + ((datetimeFormat() == null) ? 0 : datetimeFormat().hashCode());
        hashCode = 31 * hashCode + ((timeZoneString() == null) ? 0 : timeZoneString().hashCode());
        hashCode = 31 * hashCode + ((file() == null) ? 0 : file().hashCode());
        hashCode = 31 * hashCode + ((fileFingerprintLines() == null) ? 0 : fileFingerprintLines().hashCode());
        hashCode = 31 * hashCode + ((multiLineStartPattern() == null) ? 0 : multiLineStartPattern().hashCode());
        hashCode = 31 * hashCode + ((initialPositionString() == null) ? 0 : initialPositionString().hashCode());
        hashCode = 31 * hashCode + ((encodingString() == null) ? 0 : encodingString().hashCode());
        hashCode = 31 * hashCode + ((bufferDuration() == null) ? 0 : bufferDuration().hashCode());
        hashCode = 31 * hashCode + ((batchCount() == null) ? 0 : batchCount().hashCode());
        hashCode = 31 * hashCode + ((batchSize() == null) ? 0 : batchSize().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLogsLogStream)) {
            return false;
        }
        CloudWatchLogsLogStream other = (CloudWatchLogsLogStream) obj;
        if (other.logGroupName() == null ^ this.logGroupName() == null) {
            return false;
        }
        if (other.logGroupName() != null && !other.logGroupName().equals(this.logGroupName())) {
            return false;
        }
        if (other.datetimeFormat() == null ^ this.datetimeFormat() == null) {
            return false;
        }
        if (other.datetimeFormat() != null && !other.datetimeFormat().equals(this.datetimeFormat())) {
            return false;
        }
        if (other.timeZoneString() == null ^ this.timeZoneString() == null) {
            return false;
        }
        if (other.timeZoneString() != null && !other.timeZoneString().equals(this.timeZoneString())) {
            return false;
        }
        if (other.file() == null ^ this.file() == null) {
            return false;
        }
        if (other.file() != null && !other.file().equals(this.file())) {
            return false;
        }
        if (other.fileFingerprintLines() == null ^ this.fileFingerprintLines() == null) {
            return false;
        }
        if (other.fileFingerprintLines() != null && !other.fileFingerprintLines().equals(this.fileFingerprintLines())) {
            return false;
        }
        if (other.multiLineStartPattern() == null ^ this.multiLineStartPattern() == null) {
            return false;
        }
        if (other.multiLineStartPattern() != null && !other.multiLineStartPattern().equals(this.multiLineStartPattern())) {
            return false;
        }
        if (other.initialPositionString() == null ^ this.initialPositionString() == null) {
            return false;
        }
        if (other.initialPositionString() != null && !other.initialPositionString().equals(this.initialPositionString())) {
            return false;
        }
        if (other.encodingString() == null ^ this.encodingString() == null) {
            return false;
        }
        if (other.encodingString() != null && !other.encodingString().equals(this.encodingString())) {
            return false;
        }
        if (other.bufferDuration() == null ^ this.bufferDuration() == null) {
            return false;
        }
        if (other.bufferDuration() != null && !other.bufferDuration().equals(this.bufferDuration())) {
            return false;
        }
        if (other.batchCount() == null ^ this.batchCount() == null) {
            return false;
        }
        if (other.batchCount() != null && !other.batchCount().equals(this.batchCount())) {
            return false;
        }
        if (other.batchSize() == null ^ this.batchSize() == null) {
            return false;
        }
        if (other.batchSize() != null && !other.batchSize().equals(this.batchSize())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (logGroupName() != null) {
            sb.append("LogGroupName: ").append(logGroupName()).append(",");
        }
        if (datetimeFormat() != null) {
            sb.append("DatetimeFormat: ").append(datetimeFormat()).append(",");
        }
        if (timeZoneString() != null) {
            sb.append("TimeZone: ").append(timeZoneString()).append(",");
        }
        if (file() != null) {
            sb.append("File: ").append(file()).append(",");
        }
        if (fileFingerprintLines() != null) {
            sb.append("FileFingerprintLines: ").append(fileFingerprintLines()).append(",");
        }
        if (multiLineStartPattern() != null) {
            sb.append("MultiLineStartPattern: ").append(multiLineStartPattern()).append(",");
        }
        if (initialPositionString() != null) {
            sb.append("InitialPosition: ").append(initialPositionString()).append(",");
        }
        if (encodingString() != null) {
            sb.append("Encoding: ").append(encodingString()).append(",");
        }
        if (bufferDuration() != null) {
            sb.append("BufferDuration: ").append(bufferDuration()).append(",");
        }
        if (batchCount() != null) {
            sb.append("BatchCount: ").append(batchCount()).append(",");
        }
        if (batchSize() != null) {
            sb.append("BatchSize: ").append(batchSize()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LogGroupName":
            return Optional.of(clazz.cast(logGroupName()));
        case "DatetimeFormat":
            return Optional.of(clazz.cast(datetimeFormat()));
        case "TimeZone":
            return Optional.of(clazz.cast(timeZoneString()));
        case "File":
            return Optional.of(clazz.cast(file()));
        case "FileFingerprintLines":
            return Optional.of(clazz.cast(fileFingerprintLines()));
        case "MultiLineStartPattern":
            return Optional.of(clazz.cast(multiLineStartPattern()));
        case "InitialPosition":
            return Optional.of(clazz.cast(initialPositionString()));
        case "Encoding":
            return Optional.of(clazz.cast(encodingString()));
        case "BufferDuration":
            return Optional.of(clazz.cast(bufferDuration()));
        case "BatchCount":
            return Optional.of(clazz.cast(batchCount()));
        case "BatchSize":
            return Optional.of(clazz.cast(batchSize()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CloudWatchLogsLogStreamMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, CloudWatchLogsLogStream> {
        /**
         * <p>
         * Specifies the destination log group. A log group is created automatically if it doesn't already exist. Log
         * group names can be between 1 and 512 characters long. Allowed characters include a-z, A-Z, 0-9, '_'
         * (underscore), '-' (hyphen), '/' (forward slash), and '.' (period).
         * </p>
         * 
         * @param logGroupName
         *        Specifies the destination log group. A log group is created automatically if it doesn't already exist.
         *        Log group names can be between 1 and 512 characters long. Allowed characters include a-z, A-Z, 0-9,
         *        '_' (underscore), '-' (hyphen), '/' (forward slash), and '.' (period).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * Specifies how the time stamp is extracted from logs. For more information, see the <a
         * href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AgentReference.html">CloudWatch Logs Agent
         * Reference</a>.
         * </p>
         * 
         * @param datetimeFormat
         *        Specifies how the time stamp is extracted from logs. For more information, see the <a
         *        href="http://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/AgentReference.html">CloudWatch Logs
         *        Agent Reference</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder datetimeFormat(String datetimeFormat);

        /**
         * <p>
         * Specifies the time zone of log event time stamps.
         * </p>
         * 
         * @param timeZone
         *        Specifies the time zone of log event time stamps.
         * @see CloudWatchLogsTimeZone
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchLogsTimeZone
         */
        Builder timeZone(String timeZone);

        /**
         * <p>
         * Specifies the time zone of log event time stamps.
         * </p>
         * 
         * @param timeZone
         *        Specifies the time zone of log event time stamps.
         * @see CloudWatchLogsTimeZone
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchLogsTimeZone
         */
        Builder timeZone(CloudWatchLogsTimeZone timeZone);

        /**
         * <p>
         * Specifies log files that you want to push to CloudWatch Logs.
         * </p>
         * <p>
         * <code>File</code> can point to a specific file or multiple files (by using wild card characters such as
         * <code>/var/log/system.log*</code>). Only the latest file is pushed to CloudWatch Logs, based on file
         * modification time. We recommend that you use wild card characters to specify a series of files of the same
         * type, such as <code>access_log.2014-06-01-01</code>, <code>access_log.2014-06-01-02</code>, and so on by
         * using a pattern like <code>access_log.*</code>. Don't use a wildcard to match multiple file types, such as
         * <code>access_log_80</code> and <code>access_log_443</code>. To specify multiple, different file types, add
         * another log stream entry to the configuration file, so that each log file type is stored in a different log
         * group.
         * </p>
         * <p>
         * Zipped files are not supported.
         * </p>
         * 
         * @param file
         *        Specifies log files that you want to push to CloudWatch Logs.</p>
         *        <p>
         *        <code>File</code> can point to a specific file or multiple files (by using wild card characters such
         *        as <code>/var/log/system.log*</code>). Only the latest file is pushed to CloudWatch Logs, based on
         *        file modification time. We recommend that you use wild card characters to specify a series of files of
         *        the same type, such as <code>access_log.2014-06-01-01</code>, <code>access_log.2014-06-01-02</code>,
         *        and so on by using a pattern like <code>access_log.*</code>. Don't use a wildcard to match multiple
         *        file types, such as <code>access_log_80</code> and <code>access_log_443</code>. To specify multiple,
         *        different file types, add another log stream entry to the configuration file, so that each log file
         *        type is stored in a different log group.
         *        </p>
         *        <p>
         *        Zipped files are not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder file(String file);

        /**
         * <p>
         * Specifies the range of lines for identifying a file. The valid values are one number, or two dash-delimited
         * numbers, such as '1', '2-5'. The default value is '1', meaning the first line is used to calculate the
         * fingerprint. Fingerprint lines are not sent to CloudWatch Logs unless all specified lines are available.
         * </p>
         * 
         * @param fileFingerprintLines
         *        Specifies the range of lines for identifying a file. The valid values are one number, or two
         *        dash-delimited numbers, such as '1', '2-5'. The default value is '1', meaning the first line is used
         *        to calculate the fingerprint. Fingerprint lines are not sent to CloudWatch Logs unless all specified
         *        lines are available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fileFingerprintLines(String fileFingerprintLines);

        /**
         * <p>
         * Specifies the pattern for identifying the start of a log message.
         * </p>
         * 
         * @param multiLineStartPattern
         *        Specifies the pattern for identifying the start of a log message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multiLineStartPattern(String multiLineStartPattern);

        /**
         * <p>
         * Specifies where to start to read data (start_of_file or end_of_file). The default is start_of_file. This
         * setting is only used if there is no state persisted for that log stream.
         * </p>
         * 
         * @param initialPosition
         *        Specifies where to start to read data (start_of_file or end_of_file). The default is start_of_file.
         *        This setting is only used if there is no state persisted for that log stream.
         * @see CloudWatchLogsInitialPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchLogsInitialPosition
         */
        Builder initialPosition(String initialPosition);

        /**
         * <p>
         * Specifies where to start to read data (start_of_file or end_of_file). The default is start_of_file. This
         * setting is only used if there is no state persisted for that log stream.
         * </p>
         * 
         * @param initialPosition
         *        Specifies where to start to read data (start_of_file or end_of_file). The default is start_of_file.
         *        This setting is only used if there is no state persisted for that log stream.
         * @see CloudWatchLogsInitialPosition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchLogsInitialPosition
         */
        Builder initialPosition(CloudWatchLogsInitialPosition initialPosition);

        /**
         * <p>
         * Specifies the encoding of the log file so that the file can be read correctly. The default is
         * <code>utf_8</code>. Encodings supported by Python <code>codecs.decode()</code> can be used here.
         * </p>
         * 
         * @param encoding
         *        Specifies the encoding of the log file so that the file can be read correctly. The default is
         *        <code>utf_8</code>. Encodings supported by Python <code>codecs.decode()</code> can be used here.
         * @see CloudWatchLogsEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchLogsEncoding
         */
        Builder encoding(String encoding);

        /**
         * <p>
         * Specifies the encoding of the log file so that the file can be read correctly. The default is
         * <code>utf_8</code>. Encodings supported by Python <code>codecs.decode()</code> can be used here.
         * </p>
         * 
         * @param encoding
         *        Specifies the encoding of the log file so that the file can be read correctly. The default is
         *        <code>utf_8</code>. Encodings supported by Python <code>codecs.decode()</code> can be used here.
         * @see CloudWatchLogsEncoding
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CloudWatchLogsEncoding
         */
        Builder encoding(CloudWatchLogsEncoding encoding);

        /**
         * <p>
         * Specifies the time duration for the batching of log events. The minimum value is 5000ms and default value is
         * 5000ms.
         * </p>
         * 
         * @param bufferDuration
         *        Specifies the time duration for the batching of log events. The minimum value is 5000ms and default
         *        value is 5000ms.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bufferDuration(Integer bufferDuration);

        /**
         * <p>
         * Specifies the max number of log events in a batch, up to 10000. The default value is 1000.
         * </p>
         * 
         * @param batchCount
         *        Specifies the max number of log events in a batch, up to 10000. The default value is 1000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchCount(Integer batchCount);

        /**
         * <p>
         * Specifies the maximum size of log events in a batch, in bytes, up to 1048576 bytes. The default value is
         * 32768 bytes. This size is calculated as the sum of all event messages in UTF-8, plus 26 bytes for each log
         * event.
         * </p>
         * 
         * @param batchSize
         *        Specifies the maximum size of log events in a batch, in bytes, up to 1048576 bytes. The default value
         *        is 32768 bytes. This size is calculated as the sum of all event messages in UTF-8, plus 26 bytes for
         *        each log event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchSize(Integer batchSize);
    }

    static final class BuilderImpl implements Builder {
        private String logGroupName;

        private String datetimeFormat;

        private String timeZone;

        private String file;

        private String fileFingerprintLines;

        private String multiLineStartPattern;

        private String initialPosition;

        private String encoding;

        private Integer bufferDuration;

        private Integer batchCount;

        private Integer batchSize;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLogsLogStream model) {
            logGroupName(model.logGroupName);
            datetimeFormat(model.datetimeFormat);
            timeZone(model.timeZone);
            file(model.file);
            fileFingerprintLines(model.fileFingerprintLines);
            multiLineStartPattern(model.multiLineStartPattern);
            initialPosition(model.initialPosition);
            encoding(model.encoding);
            bufferDuration(model.bufferDuration);
            batchCount(model.batchCount);
            batchSize(model.batchSize);
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final String getDatetimeFormat() {
            return datetimeFormat;
        }

        @Override
        public final Builder datetimeFormat(String datetimeFormat) {
            this.datetimeFormat = datetimeFormat;
            return this;
        }

        public final void setDatetimeFormat(String datetimeFormat) {
            this.datetimeFormat = datetimeFormat;
        }

        public final String getTimeZone() {
            return timeZone;
        }

        @Override
        public final Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        @Override
        public final Builder timeZone(CloudWatchLogsTimeZone timeZone) {
            this.timeZone(timeZone.toString());
            return this;
        }

        public final void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        public final String getFile() {
            return file;
        }

        @Override
        public final Builder file(String file) {
            this.file = file;
            return this;
        }

        public final void setFile(String file) {
            this.file = file;
        }

        public final String getFileFingerprintLines() {
            return fileFingerprintLines;
        }

        @Override
        public final Builder fileFingerprintLines(String fileFingerprintLines) {
            this.fileFingerprintLines = fileFingerprintLines;
            return this;
        }

        public final void setFileFingerprintLines(String fileFingerprintLines) {
            this.fileFingerprintLines = fileFingerprintLines;
        }

        public final String getMultiLineStartPattern() {
            return multiLineStartPattern;
        }

        @Override
        public final Builder multiLineStartPattern(String multiLineStartPattern) {
            this.multiLineStartPattern = multiLineStartPattern;
            return this;
        }

        public final void setMultiLineStartPattern(String multiLineStartPattern) {
            this.multiLineStartPattern = multiLineStartPattern;
        }

        public final String getInitialPosition() {
            return initialPosition;
        }

        @Override
        public final Builder initialPosition(String initialPosition) {
            this.initialPosition = initialPosition;
            return this;
        }

        @Override
        public final Builder initialPosition(CloudWatchLogsInitialPosition initialPosition) {
            this.initialPosition(initialPosition.toString());
            return this;
        }

        public final void setInitialPosition(String initialPosition) {
            this.initialPosition = initialPosition;
        }

        public final String getEncoding() {
            return encoding;
        }

        @Override
        public final Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        @Override
        public final Builder encoding(CloudWatchLogsEncoding encoding) {
            this.encoding(encoding.toString());
            return this;
        }

        public final void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public final Integer getBufferDuration() {
            return bufferDuration;
        }

        @Override
        public final Builder bufferDuration(Integer bufferDuration) {
            this.bufferDuration = bufferDuration;
            return this;
        }

        public final void setBufferDuration(Integer bufferDuration) {
            this.bufferDuration = bufferDuration;
        }

        public final Integer getBatchCount() {
            return batchCount;
        }

        @Override
        public final Builder batchCount(Integer batchCount) {
            this.batchCount = batchCount;
            return this;
        }

        public final void setBatchCount(Integer batchCount) {
            this.batchCount = batchCount;
        }

        public final Integer getBatchSize() {
            return batchSize;
        }

        @Override
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        @Override
        public CloudWatchLogsLogStream build() {
            return new CloudWatchLogsLogStream(this);
        }
    }
}
