/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import static java.util.stream.Collectors.toSet;

import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Generated;

/**
 * <p>
 * Specifies the encoding of the log file so that the file can be read correctly. The default is <code>utf_8</code>.
 * Encodings supported by Python <code>codecs.decode()</code> can be used here.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public enum CloudWatchLogsEncoding {
    ASCII("ascii"),

    BIG5("big5"),

    BIG5_HKSCS("big5hkscs"),

    CP037("cp037"),

    CP424("cp424"),

    CP437("cp437"),

    CP500("cp500"),

    CP720("cp720"),

    CP737("cp737"),

    CP775("cp775"),

    CP850("cp850"),

    CP852("cp852"),

    CP855("cp855"),

    CP856("cp856"),

    CP857("cp857"),

    CP858("cp858"),

    CP860("cp860"),

    CP861("cp861"),

    CP862("cp862"),

    CP863("cp863"),

    CP864("cp864"),

    CP865("cp865"),

    CP866("cp866"),

    CP869("cp869"),

    CP874("cp874"),

    CP875("cp875"),

    CP932("cp932"),

    CP949("cp949"),

    CP950("cp950"),

    CP1006("cp1006"),

    CP1026("cp1026"),

    CP1140("cp1140"),

    CP1250("cp1250"),

    CP1251("cp1251"),

    CP1252("cp1252"),

    CP1253("cp1253"),

    CP1254("cp1254"),

    CP1255("cp1255"),

    CP1256("cp1256"),

    CP1257("cp1257"),

    CP1258("cp1258"),

    EUC_JP("euc_jp"),

    EUC_JIS_2004("euc_jis_2004"),

    EUC_JISX0213("euc_jisx0213"),

    EUC_KR("euc_kr"),

    GB2312("gb2312"),

    GBK("gbk"),

    GB18030("gb18030"),

    HZ("hz"),

    ISO2022_JP("iso2022_jp"),

    ISO2022_JP_1("iso2022_jp_1"),

    ISO2022_JP_2("iso2022_jp_2"),

    ISO2022_JP_2004("iso2022_jp_2004"),

    ISO2022_JP_3("iso2022_jp_3"),

    ISO2022_JP_EXT("iso2022_jp_ext"),

    ISO2022_KR("iso2022_kr"),

    LATIN_1("latin_1"),

    ISO8859_2("iso8859_2"),

    ISO8859_3("iso8859_3"),

    ISO8859_4("iso8859_4"),

    ISO8859_5("iso8859_5"),

    ISO8859_6("iso8859_6"),

    ISO8859_7("iso8859_7"),

    ISO8859_8("iso8859_8"),

    ISO8859_9("iso8859_9"),

    ISO8859_10("iso8859_10"),

    ISO8859_13("iso8859_13"),

    ISO8859_14("iso8859_14"),

    ISO8859_15("iso8859_15"),

    ISO8859_16("iso8859_16"),

    JOHAB("johab"),

    KOI8_R("koi8_r"),

    KOI8_U("koi8_u"),

    MAC_CYRILLIC("mac_cyrillic"),

    MAC_GREEK("mac_greek"),

    MAC_ICELAND("mac_iceland"),

    MAC_LATIN2("mac_latin2"),

    MAC_ROMAN("mac_roman"),

    MAC_TURKISH("mac_turkish"),

    PTCP154("ptcp154"),

    SHIFT_JIS("shift_jis"),

    SHIFT_JIS_2004("shift_jis_2004"),

    SHIFT_JISX0213("shift_jisx0213"),

    UTF_32("utf_32"),

    UTF_32_BE("utf_32_be"),

    UTF_32_LE("utf_32_le"),

    UTF_16("utf_16"),

    UTF_16_BE("utf_16_be"),

    UTF_16_LE("utf_16_le"),

    UTF_7("utf_7"),

    UTF_8("utf_8"),

    UTF_8_SIG("utf_8_sig"),

    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private CloudWatchLogsEncoding(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return CloudWatchLogsEncoding corresponding to the value
     */
    public static CloudWatchLogsEncoding fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(CloudWatchLogsEncoding.values()).filter(e -> e.toString().equals(value)).findFirst()
                .orElse(UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link CloudWatchLogsEncoding}s
     */
    public static Set<CloudWatchLogsEncoding> knownValues() {
        return Stream.of(values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(toSet());
    }
}
