/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.ChefConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the Chef configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ChefConfiguration implements StructuredPojo, ToCopyableBuilder<ChefConfiguration.Builder, ChefConfiguration> {
    private final Boolean manageBerkshelf;

    private final String berkshelfVersion;

    private ChefConfiguration(BuilderImpl builder) {
        this.manageBerkshelf = builder.manageBerkshelf;
        this.berkshelfVersion = builder.berkshelfVersion;
    }

    /**
     * <p>
     * Whether to enable Berkshelf.
     * </p>
     * 
     * @return Whether to enable Berkshelf.
     */
    public Boolean manageBerkshelf() {
        return manageBerkshelf;
    }

    /**
     * <p>
     * The Berkshelf version.
     * </p>
     * 
     * @return The Berkshelf version.
     */
    public String berkshelfVersion() {
        return berkshelfVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((manageBerkshelf() == null) ? 0 : manageBerkshelf().hashCode());
        hashCode = 31 * hashCode + ((berkshelfVersion() == null) ? 0 : berkshelfVersion().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChefConfiguration)) {
            return false;
        }
        ChefConfiguration other = (ChefConfiguration) obj;
        if (other.manageBerkshelf() == null ^ this.manageBerkshelf() == null) {
            return false;
        }
        if (other.manageBerkshelf() != null && !other.manageBerkshelf().equals(this.manageBerkshelf())) {
            return false;
        }
        if (other.berkshelfVersion() == null ^ this.berkshelfVersion() == null) {
            return false;
        }
        if (other.berkshelfVersion() != null && !other.berkshelfVersion().equals(this.berkshelfVersion())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (manageBerkshelf() != null) {
            sb.append("ManageBerkshelf: ").append(manageBerkshelf()).append(",");
        }
        if (berkshelfVersion() != null) {
            sb.append("BerkshelfVersion: ").append(berkshelfVersion()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManageBerkshelf":
            return Optional.of(clazz.cast(manageBerkshelf()));
        case "BerkshelfVersion":
            return Optional.of(clazz.cast(berkshelfVersion()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ChefConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ChefConfiguration> {
        /**
         * <p>
         * Whether to enable Berkshelf.
         * </p>
         * 
         * @param manageBerkshelf
         *        Whether to enable Berkshelf.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manageBerkshelf(Boolean manageBerkshelf);

        /**
         * <p>
         * The Berkshelf version.
         * </p>
         * 
         * @param berkshelfVersion
         *        The Berkshelf version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder berkshelfVersion(String berkshelfVersion);
    }

    static final class BuilderImpl implements Builder {
        private Boolean manageBerkshelf;

        private String berkshelfVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ChefConfiguration model) {
            manageBerkshelf(model.manageBerkshelf);
            berkshelfVersion(model.berkshelfVersion);
        }

        public final Boolean getManageBerkshelf() {
            return manageBerkshelf;
        }

        @Override
        public final Builder manageBerkshelf(Boolean manageBerkshelf) {
            this.manageBerkshelf = manageBerkshelf;
            return this;
        }

        public final void setManageBerkshelf(Boolean manageBerkshelf) {
            this.manageBerkshelf = manageBerkshelf;
        }

        public final String getBerkshelfVersion() {
            return berkshelfVersion;
        }

        @Override
        public final Builder berkshelfVersion(String berkshelfVersion) {
            this.berkshelfVersion = berkshelfVersion;
            return this;
        }

        public final void setBerkshelfVersion(String berkshelfVersion) {
            this.berkshelfVersion = berkshelfVersion;
        }

        @Override
        public ChefConfiguration build() {
            return new ChefConfiguration(this);
        }
    }
}
