/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Optional;
import javax.annotation.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.BlockDeviceMappingMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a block device mapping. This data type maps directly to the Amazon EC2 <a
 * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_BlockDeviceMapping.html">BlockDeviceMapping</a> data
 * type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class BlockDeviceMapping implements StructuredPojo, ToCopyableBuilder<BlockDeviceMapping.Builder, BlockDeviceMapping> {
    private final String deviceName;

    private final String noDevice;

    private final String virtualName;

    private final EbsBlockDevice ebs;

    private BlockDeviceMapping(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.noDevice = builder.noDevice;
        this.virtualName = builder.virtualName;
        this.ebs = builder.ebs;
    }

    /**
     * <p>
     * The device name that is exposed to the instance, such as <code>/dev/sdh</code>. For the root device, you can use
     * the explicit device name or you can set this parameter to <code>ROOT_DEVICE</code> and AWS OpsWorks Stacks will
     * provide the correct device name.
     * </p>
     * 
     * @return The device name that is exposed to the instance, such as <code>/dev/sdh</code>. For the root device, you
     *         can use the explicit device name or you can set this parameter to <code>ROOT_DEVICE</code> and AWS
     *         OpsWorks Stacks will provide the correct device name.
     */
    public String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * Suppresses the specified device included in the AMI's block device mapping.
     * </p>
     * 
     * @return Suppresses the specified device included in the AMI's block device mapping.
     */
    public String noDevice() {
        return noDevice;
    }

    /**
     * <p>
     * The virtual device name. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_BlockDeviceMapping.html">BlockDeviceMapping</a>.
     * </p>
     * 
     * @return The virtual device name. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_BlockDeviceMapping.html"
     *         >BlockDeviceMapping</a>.
     */
    public String virtualName() {
        return virtualName;
    }

    /**
     * <p>
     * An <code>EBSBlockDevice</code> that defines how to configure an Amazon EBS volume when the instance is launched.
     * </p>
     * 
     * @return An <code>EBSBlockDevice</code> that defines how to configure an Amazon EBS volume when the instance is
     *         launched.
     */
    public EbsBlockDevice ebs() {
        return ebs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deviceName() == null) ? 0 : deviceName().hashCode());
        hashCode = 31 * hashCode + ((noDevice() == null) ? 0 : noDevice().hashCode());
        hashCode = 31 * hashCode + ((virtualName() == null) ? 0 : virtualName().hashCode());
        hashCode = 31 * hashCode + ((ebs() == null) ? 0 : ebs().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockDeviceMapping)) {
            return false;
        }
        BlockDeviceMapping other = (BlockDeviceMapping) obj;
        if (other.deviceName() == null ^ this.deviceName() == null) {
            return false;
        }
        if (other.deviceName() != null && !other.deviceName().equals(this.deviceName())) {
            return false;
        }
        if (other.noDevice() == null ^ this.noDevice() == null) {
            return false;
        }
        if (other.noDevice() != null && !other.noDevice().equals(this.noDevice())) {
            return false;
        }
        if (other.virtualName() == null ^ this.virtualName() == null) {
            return false;
        }
        if (other.virtualName() != null && !other.virtualName().equals(this.virtualName())) {
            return false;
        }
        if (other.ebs() == null ^ this.ebs() == null) {
            return false;
        }
        if (other.ebs() != null && !other.ebs().equals(this.ebs())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (deviceName() != null) {
            sb.append("DeviceName: ").append(deviceName()).append(",");
        }
        if (noDevice() != null) {
            sb.append("NoDevice: ").append(noDevice()).append(",");
        }
        if (virtualName() != null) {
            sb.append("VirtualName: ").append(virtualName()).append(",");
        }
        if (ebs() != null) {
            sb.append("Ebs: ").append(ebs()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeviceName":
            return Optional.of(clazz.cast(deviceName()));
        case "NoDevice":
            return Optional.of(clazz.cast(noDevice()));
        case "VirtualName":
            return Optional.of(clazz.cast(virtualName()));
        case "Ebs":
            return Optional.of(clazz.cast(ebs()));
        default:
            return Optional.empty();
        }
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BlockDeviceMappingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, BlockDeviceMapping> {
        /**
         * <p>
         * The device name that is exposed to the instance, such as <code>/dev/sdh</code>. For the root device, you can
         * use the explicit device name or you can set this parameter to <code>ROOT_DEVICE</code> and AWS OpsWorks
         * Stacks will provide the correct device name.
         * </p>
         * 
         * @param deviceName
         *        The device name that is exposed to the instance, such as <code>/dev/sdh</code>. For the root device,
         *        you can use the explicit device name or you can set this parameter to <code>ROOT_DEVICE</code> and AWS
         *        OpsWorks Stacks will provide the correct device name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * Suppresses the specified device included in the AMI's block device mapping.
         * </p>
         * 
         * @param noDevice
         *        Suppresses the specified device included in the AMI's block device mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noDevice(String noDevice);

        /**
         * <p>
         * The virtual device name. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_BlockDeviceMapping.html"
         * >BlockDeviceMapping</a>.
         * </p>
         * 
         * @param virtualName
         *        The virtual device name. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_BlockDeviceMapping.html"
         *        >BlockDeviceMapping</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualName(String virtualName);

        /**
         * <p>
         * An <code>EBSBlockDevice</code> that defines how to configure an Amazon EBS volume when the instance is
         * launched.
         * </p>
         * 
         * @param ebs
         *        An <code>EBSBlockDevice</code> that defines how to configure an Amazon EBS volume when the instance is
         *        launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebs(EbsBlockDevice ebs);
    }

    static final class BuilderImpl implements Builder {
        private String deviceName;

        private String noDevice;

        private String virtualName;

        private EbsBlockDevice ebs;

        private BuilderImpl() {
        }

        private BuilderImpl(BlockDeviceMapping model) {
            deviceName(model.deviceName);
            noDevice(model.noDevice);
            virtualName(model.virtualName);
            ebs(model.ebs);
        }

        public final String getDeviceName() {
            return deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final String getNoDevice() {
            return noDevice;
        }

        @Override
        public final Builder noDevice(String noDevice) {
            this.noDevice = noDevice;
            return this;
        }

        public final void setNoDevice(String noDevice) {
            this.noDevice = noDevice;
        }

        public final String getVirtualName() {
            return virtualName;
        }

        @Override
        public final Builder virtualName(String virtualName) {
            this.virtualName = virtualName;
            return this;
        }

        public final void setVirtualName(String virtualName) {
            this.virtualName = virtualName;
        }

        public final EbsBlockDevice.Builder getEbs() {
            return ebs != null ? ebs.toBuilder() : null;
        }

        @Override
        public final Builder ebs(EbsBlockDevice ebs) {
            this.ebs = ebs;
            return this;
        }

        public final void setEbs(EbsBlockDevice.BuilderImpl ebs) {
            this.ebs = ebs != null ? ebs.build() : null;
        }

        @Override
        public BlockDeviceMapping build() {
            return new BlockDeviceMapping(this);
        }
    }
}
