/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.AutoScalingThresholds;

@SdkInternalApi
public class AutoScalingThresholdsMarshaller {
    private static final MarshallingInfo<Integer> INSTANCECOUNT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceCount").build();
    private static final MarshallingInfo<Integer> THRESHOLDSWAITTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ThresholdsWaitTime").build();
    private static final MarshallingInfo<Integer> IGNOREMETRICSTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IgnoreMetricsTime").build();
    private static final MarshallingInfo<Double> CPUTHRESHOLD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CpuThreshold").build();
    private static final MarshallingInfo<Double> MEMORYTHRESHOLD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MemoryThreshold").build();
    private static final MarshallingInfo<Double> LOADTHRESHOLD_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DOUBLE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LoadThreshold").build();
    private static final MarshallingInfo<List> ALARMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Alarms").build();
    private static final AutoScalingThresholdsMarshaller INSTANCE = new AutoScalingThresholdsMarshaller();

    public static AutoScalingThresholdsMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(AutoScalingThresholds autoScalingThresholds, ProtocolMarshaller protocolMarshaller) {
        if (autoScalingThresholds == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)autoScalingThresholds.instanceCount(), INSTANCECOUNT_BINDING);
            protocolMarshaller.marshall((Object)autoScalingThresholds.thresholdsWaitTime(), THRESHOLDSWAITTIME_BINDING);
            protocolMarshaller.marshall((Object)autoScalingThresholds.ignoreMetricsTime(), IGNOREMETRICSTIME_BINDING);
            protocolMarshaller.marshall((Object)autoScalingThresholds.cpuThreshold(), CPUTHRESHOLD_BINDING);
            protocolMarshaller.marshall((Object)autoScalingThresholds.memoryThreshold(), MEMORYTHRESHOLD_BINDING);
            protocolMarshaller.marshall((Object)autoScalingThresholds.loadThreshold(), LOADTHRESHOLD_BINDING);
            protocolMarshaller.marshall(autoScalingThresholds.alarms(), ALARMS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

