/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.stream.Stream;
import software.amazon.awssdk.util.StringUtils;

public enum SourceType {
    Git("git"),
    Svn("svn"),
    Archive("archive"),
    S3("s3");

    private final String value;

    private SourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static SourceType fromValue(String value) {
        if (StringUtils.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(SourceType.values()).filter(e -> e.toString().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}

