/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.opsworks.model.App;
import software.amazon.awssdk.services.opsworks.model.AppsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAppsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeAppsResponse> {
    private final List<App> apps;

    private DescribeAppsResponse(BuilderImpl builder) {
        this.apps = builder.apps;
    }

    public List<App> apps() {
        return this.apps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.apps() == null ? 0 : this.apps().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAppsResponse)) {
            return false;
        }
        DescribeAppsResponse other = (DescribeAppsResponse)((Object)obj);
        if (other.apps() == null ^ this.apps() == null) {
            return false;
        }
        return other.apps() == null || other.apps().equals(this.apps());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apps() != null) {
            sb.append("Apps: ").append(this.apps()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<App> apps;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAppsResponse model) {
            this.setApps(model.apps);
        }

        public final Collection<App> getApps() {
            return this.apps;
        }

        @Override
        public final Builder apps(Collection<App> apps) {
            this.apps = AppsCopier.copy(apps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apps(App ... apps) {
            this.apps(Arrays.asList(apps));
            return this;
        }

        public final void setApps(Collection<App> apps) {
            this.apps = AppsCopier.copy(apps);
        }

        public DescribeAppsResponse build() {
            return new DescribeAppsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeAppsResponse> {
        public Builder apps(Collection<App> var1);

        public Builder apps(App ... var1);
    }
}

