/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.CloudWatchLogsEncoding;
import software.amazon.awssdk.services.opsworks.model.CloudWatchLogsInitialPosition;
import software.amazon.awssdk.services.opsworks.model.CloudWatchLogsTimeZone;
import software.amazon.awssdk.services.opsworks.transform.CloudWatchLogsLogStreamMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CloudWatchLogsLogStream
implements StructuredPojo,
ToCopyableBuilder<Builder, CloudWatchLogsLogStream> {
    private final String logGroupName;
    private final String datetimeFormat;
    private final String timeZone;
    private final String file;
    private final String fileFingerprintLines;
    private final String multiLineStartPattern;
    private final String initialPosition;
    private final String encoding;
    private final Integer bufferDuration;
    private final Integer batchCount;
    private final Integer batchSize;

    private CloudWatchLogsLogStream(BuilderImpl builder) {
        this.logGroupName = builder.logGroupName;
        this.datetimeFormat = builder.datetimeFormat;
        this.timeZone = builder.timeZone;
        this.file = builder.file;
        this.fileFingerprintLines = builder.fileFingerprintLines;
        this.multiLineStartPattern = builder.multiLineStartPattern;
        this.initialPosition = builder.initialPosition;
        this.encoding = builder.encoding;
        this.bufferDuration = builder.bufferDuration;
        this.batchCount = builder.batchCount;
        this.batchSize = builder.batchSize;
    }

    public String logGroupName() {
        return this.logGroupName;
    }

    public String datetimeFormat() {
        return this.datetimeFormat;
    }

    public String timeZone() {
        return this.timeZone;
    }

    public String file() {
        return this.file;
    }

    public String fileFingerprintLines() {
        return this.fileFingerprintLines;
    }

    public String multiLineStartPattern() {
        return this.multiLineStartPattern;
    }

    public String initialPosition() {
        return this.initialPosition;
    }

    public String encoding() {
        return this.encoding;
    }

    public Integer bufferDuration() {
        return this.bufferDuration;
    }

    public Integer batchCount() {
        return this.batchCount;
    }

    public Integer batchSize() {
        return this.batchSize;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.logGroupName() == null ? 0 : this.logGroupName().hashCode());
        hashCode = 31 * hashCode + (this.datetimeFormat() == null ? 0 : this.datetimeFormat().hashCode());
        hashCode = 31 * hashCode + (this.timeZone() == null ? 0 : this.timeZone().hashCode());
        hashCode = 31 * hashCode + (this.file() == null ? 0 : this.file().hashCode());
        hashCode = 31 * hashCode + (this.fileFingerprintLines() == null ? 0 : this.fileFingerprintLines().hashCode());
        hashCode = 31 * hashCode + (this.multiLineStartPattern() == null ? 0 : this.multiLineStartPattern().hashCode());
        hashCode = 31 * hashCode + (this.initialPosition() == null ? 0 : this.initialPosition().hashCode());
        hashCode = 31 * hashCode + (this.encoding() == null ? 0 : this.encoding().hashCode());
        hashCode = 31 * hashCode + (this.bufferDuration() == null ? 0 : this.bufferDuration().hashCode());
        hashCode = 31 * hashCode + (this.batchCount() == null ? 0 : this.batchCount().hashCode());
        hashCode = 31 * hashCode + (this.batchSize() == null ? 0 : this.batchSize().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudWatchLogsLogStream)) {
            return false;
        }
        CloudWatchLogsLogStream other = (CloudWatchLogsLogStream)obj;
        if (other.logGroupName() == null ^ this.logGroupName() == null) {
            return false;
        }
        if (other.logGroupName() != null && !other.logGroupName().equals(this.logGroupName())) {
            return false;
        }
        if (other.datetimeFormat() == null ^ this.datetimeFormat() == null) {
            return false;
        }
        if (other.datetimeFormat() != null && !other.datetimeFormat().equals(this.datetimeFormat())) {
            return false;
        }
        if (other.timeZone() == null ^ this.timeZone() == null) {
            return false;
        }
        if (other.timeZone() != null && !other.timeZone().equals(this.timeZone())) {
            return false;
        }
        if (other.file() == null ^ this.file() == null) {
            return false;
        }
        if (other.file() != null && !other.file().equals(this.file())) {
            return false;
        }
        if (other.fileFingerprintLines() == null ^ this.fileFingerprintLines() == null) {
            return false;
        }
        if (other.fileFingerprintLines() != null && !other.fileFingerprintLines().equals(this.fileFingerprintLines())) {
            return false;
        }
        if (other.multiLineStartPattern() == null ^ this.multiLineStartPattern() == null) {
            return false;
        }
        if (other.multiLineStartPattern() != null && !other.multiLineStartPattern().equals(this.multiLineStartPattern())) {
            return false;
        }
        if (other.initialPosition() == null ^ this.initialPosition() == null) {
            return false;
        }
        if (other.initialPosition() != null && !other.initialPosition().equals(this.initialPosition())) {
            return false;
        }
        if (other.encoding() == null ^ this.encoding() == null) {
            return false;
        }
        if (other.encoding() != null && !other.encoding().equals(this.encoding())) {
            return false;
        }
        if (other.bufferDuration() == null ^ this.bufferDuration() == null) {
            return false;
        }
        if (other.bufferDuration() != null && !other.bufferDuration().equals(this.bufferDuration())) {
            return false;
        }
        if (other.batchCount() == null ^ this.batchCount() == null) {
            return false;
        }
        if (other.batchCount() != null && !other.batchCount().equals(this.batchCount())) {
            return false;
        }
        if (other.batchSize() == null ^ this.batchSize() == null) {
            return false;
        }
        return other.batchSize() == null || other.batchSize().equals(this.batchSize());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.logGroupName() != null) {
            sb.append("LogGroupName: ").append(this.logGroupName()).append(",");
        }
        if (this.datetimeFormat() != null) {
            sb.append("DatetimeFormat: ").append(this.datetimeFormat()).append(",");
        }
        if (this.timeZone() != null) {
            sb.append("TimeZone: ").append(this.timeZone()).append(",");
        }
        if (this.file() != null) {
            sb.append("File: ").append(this.file()).append(",");
        }
        if (this.fileFingerprintLines() != null) {
            sb.append("FileFingerprintLines: ").append(this.fileFingerprintLines()).append(",");
        }
        if (this.multiLineStartPattern() != null) {
            sb.append("MultiLineStartPattern: ").append(this.multiLineStartPattern()).append(",");
        }
        if (this.initialPosition() != null) {
            sb.append("InitialPosition: ").append(this.initialPosition()).append(",");
        }
        if (this.encoding() != null) {
            sb.append("Encoding: ").append(this.encoding()).append(",");
        }
        if (this.bufferDuration() != null) {
            sb.append("BufferDuration: ").append(this.bufferDuration()).append(",");
        }
        if (this.batchCount() != null) {
            sb.append("BatchCount: ").append(this.batchCount()).append(",");
        }
        if (this.batchSize() != null) {
            sb.append("BatchSize: ").append(this.batchSize()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CloudWatchLogsLogStreamMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String logGroupName;
        private String datetimeFormat;
        private String timeZone;
        private String file;
        private String fileFingerprintLines;
        private String multiLineStartPattern;
        private String initialPosition;
        private String encoding;
        private Integer bufferDuration;
        private Integer batchCount;
        private Integer batchSize;

        private BuilderImpl() {
        }

        private BuilderImpl(CloudWatchLogsLogStream model) {
            this.setLogGroupName(model.logGroupName);
            this.setDatetimeFormat(model.datetimeFormat);
            this.setTimeZone(model.timeZone);
            this.setFile(model.file);
            this.setFileFingerprintLines(model.fileFingerprintLines);
            this.setMultiLineStartPattern(model.multiLineStartPattern);
            this.setInitialPosition(model.initialPosition);
            this.setEncoding(model.encoding);
            this.setBufferDuration(model.bufferDuration);
            this.setBatchCount(model.batchCount);
            this.setBatchSize(model.batchSize);
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final String getDatetimeFormat() {
            return this.datetimeFormat;
        }

        @Override
        public final Builder datetimeFormat(String datetimeFormat) {
            this.datetimeFormat = datetimeFormat;
            return this;
        }

        public final void setDatetimeFormat(String datetimeFormat) {
            this.datetimeFormat = datetimeFormat;
        }

        public final String getTimeZone() {
            return this.timeZone;
        }

        @Override
        public final Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        @Override
        public final Builder timeZone(CloudWatchLogsTimeZone timeZone) {
            this.timeZone(timeZone.toString());
            return this;
        }

        public final void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        public final String getFile() {
            return this.file;
        }

        @Override
        public final Builder file(String file) {
            this.file = file;
            return this;
        }

        public final void setFile(String file) {
            this.file = file;
        }

        public final String getFileFingerprintLines() {
            return this.fileFingerprintLines;
        }

        @Override
        public final Builder fileFingerprintLines(String fileFingerprintLines) {
            this.fileFingerprintLines = fileFingerprintLines;
            return this;
        }

        public final void setFileFingerprintLines(String fileFingerprintLines) {
            this.fileFingerprintLines = fileFingerprintLines;
        }

        public final String getMultiLineStartPattern() {
            return this.multiLineStartPattern;
        }

        @Override
        public final Builder multiLineStartPattern(String multiLineStartPattern) {
            this.multiLineStartPattern = multiLineStartPattern;
            return this;
        }

        public final void setMultiLineStartPattern(String multiLineStartPattern) {
            this.multiLineStartPattern = multiLineStartPattern;
        }

        public final String getInitialPosition() {
            return this.initialPosition;
        }

        @Override
        public final Builder initialPosition(String initialPosition) {
            this.initialPosition = initialPosition;
            return this;
        }

        @Override
        public final Builder initialPosition(CloudWatchLogsInitialPosition initialPosition) {
            this.initialPosition(initialPosition.toString());
            return this;
        }

        public final void setInitialPosition(String initialPosition) {
            this.initialPosition = initialPosition;
        }

        public final String getEncoding() {
            return this.encoding;
        }

        @Override
        public final Builder encoding(String encoding) {
            this.encoding = encoding;
            return this;
        }

        @Override
        public final Builder encoding(CloudWatchLogsEncoding encoding) {
            this.encoding(encoding.toString());
            return this;
        }

        public final void setEncoding(String encoding) {
            this.encoding = encoding;
        }

        public final Integer getBufferDuration() {
            return this.bufferDuration;
        }

        @Override
        public final Builder bufferDuration(Integer bufferDuration) {
            this.bufferDuration = bufferDuration;
            return this;
        }

        public final void setBufferDuration(Integer bufferDuration) {
            this.bufferDuration = bufferDuration;
        }

        public final Integer getBatchCount() {
            return this.batchCount;
        }

        @Override
        public final Builder batchCount(Integer batchCount) {
            this.batchCount = batchCount;
            return this;
        }

        public final void setBatchCount(Integer batchCount) {
            this.batchCount = batchCount;
        }

        public final Integer getBatchSize() {
            return this.batchSize;
        }

        @Override
        public final Builder batchSize(Integer batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public final void setBatchSize(Integer batchSize) {
            this.batchSize = batchSize;
        }

        public CloudWatchLogsLogStream build() {
            return new CloudWatchLogsLogStream(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CloudWatchLogsLogStream> {
        public Builder logGroupName(String var1);

        public Builder datetimeFormat(String var1);

        public Builder timeZone(String var1);

        public Builder timeZone(CloudWatchLogsTimeZone var1);

        public Builder file(String var1);

        public Builder fileFingerprintLines(String var1);

        public Builder multiLineStartPattern(String var1);

        public Builder initialPosition(String var1);

        public Builder initialPosition(CloudWatchLogsInitialPosition var1);

        public Builder encoding(String var1);

        public Builder encoding(CloudWatchLogsEncoding var1);

        public Builder bufferDuration(Integer var1);

        public Builder batchCount(Integer var1);

        public Builder batchSize(Integer var1);
    }
}

