/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.stream.Stream;
import software.amazon.awssdk.util.StringUtils;

public enum AppType {
    AwsFlowRuby("aws-flow-ruby"),
    Java("java"),
    Rails("rails"),
    Php("php"),
    Nodejs("nodejs"),
    Static("static"),
    Other("other");

    private final String value;

    private AppType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static AppType fromValue(String value) {
        if (StringUtils.isNullOrEmpty((String)value)) {
            throw new IllegalArgumentException("Value cannot be null or empty!");
        }
        return Stream.of(AppType.values()).filter(e -> e.toString().equals(value)).findFirst().orElseThrow(() -> new IllegalArgumentException("Cannot create enum from " + value + " value!"));
    }
}

