/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.opsworks.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * WeeklyAutoScalingSchedule JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class WeeklyAutoScalingScheduleUnmarshaller implements Unmarshaller<WeeklyAutoScalingSchedule, JsonUnmarshallerContext> {

    public WeeklyAutoScalingSchedule unmarshall(JsonUnmarshallerContext context) throws Exception {
        WeeklyAutoScalingSchedule.Builder weeklyAutoScalingScheduleBuilder = WeeklyAutoScalingSchedule.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("Monday", targetDepth)) {
                    context.nextToken();
                    weeklyAutoScalingScheduleBuilder.monday(new MapUnmarshaller<String, String>(context
                            .getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("Tuesday", targetDepth)) {
                    context.nextToken();
                    weeklyAutoScalingScheduleBuilder.tuesday(new MapUnmarshaller<String, String>(context
                            .getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("Wednesday", targetDepth)) {
                    context.nextToken();
                    weeklyAutoScalingScheduleBuilder.wednesday(new MapUnmarshaller<String, String>(context
                            .getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("Thursday", targetDepth)) {
                    context.nextToken();
                    weeklyAutoScalingScheduleBuilder.thursday(new MapUnmarshaller<String, String>(context
                            .getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("Friday", targetDepth)) {
                    context.nextToken();
                    weeklyAutoScalingScheduleBuilder.friday(new MapUnmarshaller<String, String>(context
                            .getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("Saturday", targetDepth)) {
                    context.nextToken();
                    weeklyAutoScalingScheduleBuilder.saturday(new MapUnmarshaller<String, String>(context
                            .getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("Sunday", targetDepth)) {
                    context.nextToken();
                    weeklyAutoScalingScheduleBuilder.sunday(new MapUnmarshaller<String, String>(context
                            .getUnmarshaller(String.class), context.getUnmarshaller(String.class)).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return weeklyAutoScalingScheduleBuilder.build();
    }

    private static final WeeklyAutoScalingScheduleUnmarshaller INSTANCE = new WeeklyAutoScalingScheduleUnmarshaller();

    public static WeeklyAutoScalingScheduleUnmarshaller getInstance() {
        return INSTANCE;
    }
}
