/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.transform;

import javax.annotation.Generated;

import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.services.opsworks.model.*;

import software.amazon.awssdk.protocol.*;
import software.amazon.awssdk.annotation.SdkInternalApi;

/**
 * InstancesCountMarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
@SdkInternalApi
public class InstancesCountMarshaller {

    private static final MarshallingInfo<Integer> ASSIGNING_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Assigning").build();
    private static final MarshallingInfo<Integer> BOOTING_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Booting").build();
    private static final MarshallingInfo<Integer> CONNECTIONLOST_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ConnectionLost").build();
    private static final MarshallingInfo<Integer> DEREGISTERING_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Deregistering").build();
    private static final MarshallingInfo<Integer> ONLINE_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Online").build();
    private static final MarshallingInfo<Integer> PENDING_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Pending").build();
    private static final MarshallingInfo<Integer> REBOOTING_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Rebooting").build();
    private static final MarshallingInfo<Integer> REGISTERED_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Registered").build();
    private static final MarshallingInfo<Integer> REGISTERING_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Registering").build();
    private static final MarshallingInfo<Integer> REQUESTED_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Requested").build();
    private static final MarshallingInfo<Integer> RUNNINGSETUP_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RunningSetup").build();
    private static final MarshallingInfo<Integer> SETUPFAILED_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SetupFailed").build();
    private static final MarshallingInfo<Integer> SHUTTINGDOWN_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ShuttingDown").build();
    private static final MarshallingInfo<Integer> STARTFAILED_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartFailed").build();
    private static final MarshallingInfo<Integer> STOPPED_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Stopped").build();
    private static final MarshallingInfo<Integer> STOPPING_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Stopping").build();
    private static final MarshallingInfo<Integer> TERMINATED_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Terminated").build();
    private static final MarshallingInfo<Integer> TERMINATING_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Terminating").build();
    private static final MarshallingInfo<Integer> UNASSIGNING_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER)
            .marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Unassigning").build();

    private static final InstancesCountMarshaller INSTANCE = new InstancesCountMarshaller();

    public static InstancesCountMarshaller getInstance() {
        return INSTANCE;
    }

    /**
     * Marshall the given parameter object.
     */
    public void marshall(InstancesCount instancesCount, ProtocolMarshaller protocolMarshaller) {

        if (instancesCount == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }

        try {

            protocolMarshaller.marshall(instancesCount.assigning(), ASSIGNING_BINDING);

            protocolMarshaller.marshall(instancesCount.booting(), BOOTING_BINDING);

            protocolMarshaller.marshall(instancesCount.connectionLost(), CONNECTIONLOST_BINDING);

            protocolMarshaller.marshall(instancesCount.deregistering(), DEREGISTERING_BINDING);

            protocolMarshaller.marshall(instancesCount.online(), ONLINE_BINDING);

            protocolMarshaller.marshall(instancesCount.pending(), PENDING_BINDING);

            protocolMarshaller.marshall(instancesCount.rebooting(), REBOOTING_BINDING);

            protocolMarshaller.marshall(instancesCount.registered(), REGISTERED_BINDING);

            protocolMarshaller.marshall(instancesCount.registering(), REGISTERING_BINDING);

            protocolMarshaller.marshall(instancesCount.requested(), REQUESTED_BINDING);

            protocolMarshaller.marshall(instancesCount.runningSetup(), RUNNINGSETUP_BINDING);

            protocolMarshaller.marshall(instancesCount.setupFailed(), SETUPFAILED_BINDING);

            protocolMarshaller.marshall(instancesCount.shuttingDown(), SHUTTINGDOWN_BINDING);

            protocolMarshaller.marshall(instancesCount.startFailed(), STARTFAILED_BINDING);

            protocolMarshaller.marshall(instancesCount.stopped(), STOPPED_BINDING);

            protocolMarshaller.marshall(instancesCount.stopping(), STOPPING_BINDING);

            protocolMarshaller.marshall(instancesCount.terminated(), TERMINATED_BINDING);

            protocolMarshaller.marshall(instancesCount.terminating(), TERMINATING_BINDING);

            protocolMarshaller.marshall(instancesCount.unassigning(), UNASSIGNING_BINDING);
        } catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }

}
