/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.TimeBasedAutoScalingConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an instance's time-based auto scaling configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class TimeBasedAutoScalingConfiguration implements StructuredPojo,
        ToCopyableBuilder<TimeBasedAutoScalingConfiguration.Builder, TimeBasedAutoScalingConfiguration> {
    private final String instanceId;

    private final WeeklyAutoScalingSchedule autoScalingSchedule;

    private TimeBasedAutoScalingConfiguration(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.autoScalingSchedule = builder.autoScalingSchedule;
    }

    /**
     * <p>
     * The instance ID.
     * </p>
     * 
     * @return The instance ID.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * A <code>WeeklyAutoScalingSchedule</code> object with the instance schedule.
     * </p>
     * 
     * @return A <code>WeeklyAutoScalingSchedule</code> object with the instance schedule.
     */
    public WeeklyAutoScalingSchedule autoScalingSchedule() {
        return autoScalingSchedule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((autoScalingSchedule() == null) ? 0 : autoScalingSchedule().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeBasedAutoScalingConfiguration)) {
            return false;
        }
        TimeBasedAutoScalingConfiguration other = (TimeBasedAutoScalingConfiguration) obj;
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.autoScalingSchedule() == null ^ this.autoScalingSchedule() == null) {
            return false;
        }
        if (other.autoScalingSchedule() != null && !other.autoScalingSchedule().equals(this.autoScalingSchedule())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (autoScalingSchedule() != null) {
            sb.append("AutoScalingSchedule: ").append(autoScalingSchedule()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TimeBasedAutoScalingConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, TimeBasedAutoScalingConfiguration> {
        /**
         * <p>
         * The instance ID.
         * </p>
         * 
         * @param instanceId
         *        The instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * A <code>WeeklyAutoScalingSchedule</code> object with the instance schedule.
         * </p>
         * 
         * @param autoScalingSchedule
         *        A <code>WeeklyAutoScalingSchedule</code> object with the instance schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder autoScalingSchedule(WeeklyAutoScalingSchedule autoScalingSchedule);
    }

    private static final class BuilderImpl implements Builder {
        private String instanceId;

        private WeeklyAutoScalingSchedule autoScalingSchedule;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeBasedAutoScalingConfiguration model) {
            setInstanceId(model.instanceId);
            setAutoScalingSchedule(model.autoScalingSchedule);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final WeeklyAutoScalingSchedule getAutoScalingSchedule() {
            return autoScalingSchedule;
        }

        @Override
        public final Builder autoScalingSchedule(WeeklyAutoScalingSchedule autoScalingSchedule) {
            this.autoScalingSchedule = autoScalingSchedule;
            return this;
        }

        public final void setAutoScalingSchedule(WeeklyAutoScalingSchedule autoScalingSchedule) {
            this.autoScalingSchedule = autoScalingSchedule;
        }

        @Override
        public TimeBasedAutoScalingConfiguration build() {
            return new TimeBasedAutoScalingConfiguration(this);
        }
    }
}
