/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.InstancesCountMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes how many instances a stack has for each status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstancesCount implements StructuredPojo, ToCopyableBuilder<InstancesCount.Builder, InstancesCount> {
    private final Integer assigning;

    private final Integer booting;

    private final Integer connectionLost;

    private final Integer deregistering;

    private final Integer online;

    private final Integer pending;

    private final Integer rebooting;

    private final Integer registered;

    private final Integer registering;

    private final Integer requested;

    private final Integer runningSetup;

    private final Integer setupFailed;

    private final Integer shuttingDown;

    private final Integer startFailed;

    private final Integer stopped;

    private final Integer stopping;

    private final Integer terminated;

    private final Integer terminating;

    private final Integer unassigning;

    private InstancesCount(BuilderImpl builder) {
        this.assigning = builder.assigning;
        this.booting = builder.booting;
        this.connectionLost = builder.connectionLost;
        this.deregistering = builder.deregistering;
        this.online = builder.online;
        this.pending = builder.pending;
        this.rebooting = builder.rebooting;
        this.registered = builder.registered;
        this.registering = builder.registering;
        this.requested = builder.requested;
        this.runningSetup = builder.runningSetup;
        this.setupFailed = builder.setupFailed;
        this.shuttingDown = builder.shuttingDown;
        this.startFailed = builder.startFailed;
        this.stopped = builder.stopped;
        this.stopping = builder.stopping;
        this.terminated = builder.terminated;
        this.terminating = builder.terminating;
        this.unassigning = builder.unassigning;
    }

    /**
     * <p>
     * The number of instances in the Assigning state.
     * </p>
     * 
     * @return The number of instances in the Assigning state.
     */
    public Integer assigning() {
        return assigning;
    }

    /**
     * <p>
     * The number of instances with <code>booting</code> status.
     * </p>
     * 
     * @return The number of instances with <code>booting</code> status.
     */
    public Integer booting() {
        return booting;
    }

    /**
     * <p>
     * The number of instances with <code>connection_lost</code> status.
     * </p>
     * 
     * @return The number of instances with <code>connection_lost</code> status.
     */
    public Integer connectionLost() {
        return connectionLost;
    }

    /**
     * <p>
     * The number of instances in the Deregistering state.
     * </p>
     * 
     * @return The number of instances in the Deregistering state.
     */
    public Integer deregistering() {
        return deregistering;
    }

    /**
     * <p>
     * The number of instances with <code>online</code> status.
     * </p>
     * 
     * @return The number of instances with <code>online</code> status.
     */
    public Integer online() {
        return online;
    }

    /**
     * <p>
     * The number of instances with <code>pending</code> status.
     * </p>
     * 
     * @return The number of instances with <code>pending</code> status.
     */
    public Integer pending() {
        return pending;
    }

    /**
     * <p>
     * The number of instances with <code>rebooting</code> status.
     * </p>
     * 
     * @return The number of instances with <code>rebooting</code> status.
     */
    public Integer rebooting() {
        return rebooting;
    }

    /**
     * <p>
     * The number of instances in the Registered state.
     * </p>
     * 
     * @return The number of instances in the Registered state.
     */
    public Integer registered() {
        return registered;
    }

    /**
     * <p>
     * The number of instances in the Registering state.
     * </p>
     * 
     * @return The number of instances in the Registering state.
     */
    public Integer registering() {
        return registering;
    }

    /**
     * <p>
     * The number of instances with <code>requested</code> status.
     * </p>
     * 
     * @return The number of instances with <code>requested</code> status.
     */
    public Integer requested() {
        return requested;
    }

    /**
     * <p>
     * The number of instances with <code>running_setup</code> status.
     * </p>
     * 
     * @return The number of instances with <code>running_setup</code> status.
     */
    public Integer runningSetup() {
        return runningSetup;
    }

    /**
     * <p>
     * The number of instances with <code>setup_failed</code> status.
     * </p>
     * 
     * @return The number of instances with <code>setup_failed</code> status.
     */
    public Integer setupFailed() {
        return setupFailed;
    }

    /**
     * <p>
     * The number of instances with <code>shutting_down</code> status.
     * </p>
     * 
     * @return The number of instances with <code>shutting_down</code> status.
     */
    public Integer shuttingDown() {
        return shuttingDown;
    }

    /**
     * <p>
     * The number of instances with <code>start_failed</code> status.
     * </p>
     * 
     * @return The number of instances with <code>start_failed</code> status.
     */
    public Integer startFailed() {
        return startFailed;
    }

    /**
     * <p>
     * The number of instances with <code>stopped</code> status.
     * </p>
     * 
     * @return The number of instances with <code>stopped</code> status.
     */
    public Integer stopped() {
        return stopped;
    }

    /**
     * <p>
     * The number of instances with <code>stopping</code> status.
     * </p>
     * 
     * @return The number of instances with <code>stopping</code> status.
     */
    public Integer stopping() {
        return stopping;
    }

    /**
     * <p>
     * The number of instances with <code>terminated</code> status.
     * </p>
     * 
     * @return The number of instances with <code>terminated</code> status.
     */
    public Integer terminated() {
        return terminated;
    }

    /**
     * <p>
     * The number of instances with <code>terminating</code> status.
     * </p>
     * 
     * @return The number of instances with <code>terminating</code> status.
     */
    public Integer terminating() {
        return terminating;
    }

    /**
     * <p>
     * The number of instances in the Unassigning state.
     * </p>
     * 
     * @return The number of instances in the Unassigning state.
     */
    public Integer unassigning() {
        return unassigning;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((assigning() == null) ? 0 : assigning().hashCode());
        hashCode = 31 * hashCode + ((booting() == null) ? 0 : booting().hashCode());
        hashCode = 31 * hashCode + ((connectionLost() == null) ? 0 : connectionLost().hashCode());
        hashCode = 31 * hashCode + ((deregistering() == null) ? 0 : deregistering().hashCode());
        hashCode = 31 * hashCode + ((online() == null) ? 0 : online().hashCode());
        hashCode = 31 * hashCode + ((pending() == null) ? 0 : pending().hashCode());
        hashCode = 31 * hashCode + ((rebooting() == null) ? 0 : rebooting().hashCode());
        hashCode = 31 * hashCode + ((registered() == null) ? 0 : registered().hashCode());
        hashCode = 31 * hashCode + ((registering() == null) ? 0 : registering().hashCode());
        hashCode = 31 * hashCode + ((requested() == null) ? 0 : requested().hashCode());
        hashCode = 31 * hashCode + ((runningSetup() == null) ? 0 : runningSetup().hashCode());
        hashCode = 31 * hashCode + ((setupFailed() == null) ? 0 : setupFailed().hashCode());
        hashCode = 31 * hashCode + ((shuttingDown() == null) ? 0 : shuttingDown().hashCode());
        hashCode = 31 * hashCode + ((startFailed() == null) ? 0 : startFailed().hashCode());
        hashCode = 31 * hashCode + ((stopped() == null) ? 0 : stopped().hashCode());
        hashCode = 31 * hashCode + ((stopping() == null) ? 0 : stopping().hashCode());
        hashCode = 31 * hashCode + ((terminated() == null) ? 0 : terminated().hashCode());
        hashCode = 31 * hashCode + ((terminating() == null) ? 0 : terminating().hashCode());
        hashCode = 31 * hashCode + ((unassigning() == null) ? 0 : unassigning().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstancesCount)) {
            return false;
        }
        InstancesCount other = (InstancesCount) obj;
        if (other.assigning() == null ^ this.assigning() == null) {
            return false;
        }
        if (other.assigning() != null && !other.assigning().equals(this.assigning())) {
            return false;
        }
        if (other.booting() == null ^ this.booting() == null) {
            return false;
        }
        if (other.booting() != null && !other.booting().equals(this.booting())) {
            return false;
        }
        if (other.connectionLost() == null ^ this.connectionLost() == null) {
            return false;
        }
        if (other.connectionLost() != null && !other.connectionLost().equals(this.connectionLost())) {
            return false;
        }
        if (other.deregistering() == null ^ this.deregistering() == null) {
            return false;
        }
        if (other.deregistering() != null && !other.deregistering().equals(this.deregistering())) {
            return false;
        }
        if (other.online() == null ^ this.online() == null) {
            return false;
        }
        if (other.online() != null && !other.online().equals(this.online())) {
            return false;
        }
        if (other.pending() == null ^ this.pending() == null) {
            return false;
        }
        if (other.pending() != null && !other.pending().equals(this.pending())) {
            return false;
        }
        if (other.rebooting() == null ^ this.rebooting() == null) {
            return false;
        }
        if (other.rebooting() != null && !other.rebooting().equals(this.rebooting())) {
            return false;
        }
        if (other.registered() == null ^ this.registered() == null) {
            return false;
        }
        if (other.registered() != null && !other.registered().equals(this.registered())) {
            return false;
        }
        if (other.registering() == null ^ this.registering() == null) {
            return false;
        }
        if (other.registering() != null && !other.registering().equals(this.registering())) {
            return false;
        }
        if (other.requested() == null ^ this.requested() == null) {
            return false;
        }
        if (other.requested() != null && !other.requested().equals(this.requested())) {
            return false;
        }
        if (other.runningSetup() == null ^ this.runningSetup() == null) {
            return false;
        }
        if (other.runningSetup() != null && !other.runningSetup().equals(this.runningSetup())) {
            return false;
        }
        if (other.setupFailed() == null ^ this.setupFailed() == null) {
            return false;
        }
        if (other.setupFailed() != null && !other.setupFailed().equals(this.setupFailed())) {
            return false;
        }
        if (other.shuttingDown() == null ^ this.shuttingDown() == null) {
            return false;
        }
        if (other.shuttingDown() != null && !other.shuttingDown().equals(this.shuttingDown())) {
            return false;
        }
        if (other.startFailed() == null ^ this.startFailed() == null) {
            return false;
        }
        if (other.startFailed() != null && !other.startFailed().equals(this.startFailed())) {
            return false;
        }
        if (other.stopped() == null ^ this.stopped() == null) {
            return false;
        }
        if (other.stopped() != null && !other.stopped().equals(this.stopped())) {
            return false;
        }
        if (other.stopping() == null ^ this.stopping() == null) {
            return false;
        }
        if (other.stopping() != null && !other.stopping().equals(this.stopping())) {
            return false;
        }
        if (other.terminated() == null ^ this.terminated() == null) {
            return false;
        }
        if (other.terminated() != null && !other.terminated().equals(this.terminated())) {
            return false;
        }
        if (other.terminating() == null ^ this.terminating() == null) {
            return false;
        }
        if (other.terminating() != null && !other.terminating().equals(this.terminating())) {
            return false;
        }
        if (other.unassigning() == null ^ this.unassigning() == null) {
            return false;
        }
        if (other.unassigning() != null && !other.unassigning().equals(this.unassigning())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (assigning() != null) {
            sb.append("Assigning: ").append(assigning()).append(",");
        }
        if (booting() != null) {
            sb.append("Booting: ").append(booting()).append(",");
        }
        if (connectionLost() != null) {
            sb.append("ConnectionLost: ").append(connectionLost()).append(",");
        }
        if (deregistering() != null) {
            sb.append("Deregistering: ").append(deregistering()).append(",");
        }
        if (online() != null) {
            sb.append("Online: ").append(online()).append(",");
        }
        if (pending() != null) {
            sb.append("Pending: ").append(pending()).append(",");
        }
        if (rebooting() != null) {
            sb.append("Rebooting: ").append(rebooting()).append(",");
        }
        if (registered() != null) {
            sb.append("Registered: ").append(registered()).append(",");
        }
        if (registering() != null) {
            sb.append("Registering: ").append(registering()).append(",");
        }
        if (requested() != null) {
            sb.append("Requested: ").append(requested()).append(",");
        }
        if (runningSetup() != null) {
            sb.append("RunningSetup: ").append(runningSetup()).append(",");
        }
        if (setupFailed() != null) {
            sb.append("SetupFailed: ").append(setupFailed()).append(",");
        }
        if (shuttingDown() != null) {
            sb.append("ShuttingDown: ").append(shuttingDown()).append(",");
        }
        if (startFailed() != null) {
            sb.append("StartFailed: ").append(startFailed()).append(",");
        }
        if (stopped() != null) {
            sb.append("Stopped: ").append(stopped()).append(",");
        }
        if (stopping() != null) {
            sb.append("Stopping: ").append(stopping()).append(",");
        }
        if (terminated() != null) {
            sb.append("Terminated: ").append(terminated()).append(",");
        }
        if (terminating() != null) {
            sb.append("Terminating: ").append(terminating()).append(",");
        }
        if (unassigning() != null) {
            sb.append("Unassigning: ").append(unassigning()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstancesCountMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, InstancesCount> {
        /**
         * <p>
         * The number of instances in the Assigning state.
         * </p>
         * 
         * @param assigning
         *        The number of instances in the Assigning state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assigning(Integer assigning);

        /**
         * <p>
         * The number of instances with <code>booting</code> status.
         * </p>
         * 
         * @param booting
         *        The number of instances with <code>booting</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booting(Integer booting);

        /**
         * <p>
         * The number of instances with <code>connection_lost</code> status.
         * </p>
         * 
         * @param connectionLost
         *        The number of instances with <code>connection_lost</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionLost(Integer connectionLost);

        /**
         * <p>
         * The number of instances in the Deregistering state.
         * </p>
         * 
         * @param deregistering
         *        The number of instances in the Deregistering state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deregistering(Integer deregistering);

        /**
         * <p>
         * The number of instances with <code>online</code> status.
         * </p>
         * 
         * @param online
         *        The number of instances with <code>online</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder online(Integer online);

        /**
         * <p>
         * The number of instances with <code>pending</code> status.
         * </p>
         * 
         * @param pending
         *        The number of instances with <code>pending</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pending(Integer pending);

        /**
         * <p>
         * The number of instances with <code>rebooting</code> status.
         * </p>
         * 
         * @param rebooting
         *        The number of instances with <code>rebooting</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rebooting(Integer rebooting);

        /**
         * <p>
         * The number of instances in the Registered state.
         * </p>
         * 
         * @param registered
         *        The number of instances in the Registered state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registered(Integer registered);

        /**
         * <p>
         * The number of instances in the Registering state.
         * </p>
         * 
         * @param registering
         *        The number of instances in the Registering state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registering(Integer registering);

        /**
         * <p>
         * The number of instances with <code>requested</code> status.
         * </p>
         * 
         * @param requested
         *        The number of instances with <code>requested</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requested(Integer requested);

        /**
         * <p>
         * The number of instances with <code>running_setup</code> status.
         * </p>
         * 
         * @param runningSetup
         *        The number of instances with <code>running_setup</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runningSetup(Integer runningSetup);

        /**
         * <p>
         * The number of instances with <code>setup_failed</code> status.
         * </p>
         * 
         * @param setupFailed
         *        The number of instances with <code>setup_failed</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder setupFailed(Integer setupFailed);

        /**
         * <p>
         * The number of instances with <code>shutting_down</code> status.
         * </p>
         * 
         * @param shuttingDown
         *        The number of instances with <code>shutting_down</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shuttingDown(Integer shuttingDown);

        /**
         * <p>
         * The number of instances with <code>start_failed</code> status.
         * </p>
         * 
         * @param startFailed
         *        The number of instances with <code>start_failed</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startFailed(Integer startFailed);

        /**
         * <p>
         * The number of instances with <code>stopped</code> status.
         * </p>
         * 
         * @param stopped
         *        The number of instances with <code>stopped</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopped(Integer stopped);

        /**
         * <p>
         * The number of instances with <code>stopping</code> status.
         * </p>
         * 
         * @param stopping
         *        The number of instances with <code>stopping</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopping(Integer stopping);

        /**
         * <p>
         * The number of instances with <code>terminated</code> status.
         * </p>
         * 
         * @param terminated
         *        The number of instances with <code>terminated</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminated(Integer terminated);

        /**
         * <p>
         * The number of instances with <code>terminating</code> status.
         * </p>
         * 
         * @param terminating
         *        The number of instances with <code>terminating</code> status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder terminating(Integer terminating);

        /**
         * <p>
         * The number of instances in the Unassigning state.
         * </p>
         * 
         * @param unassigning
         *        The number of instances in the Unassigning state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unassigning(Integer unassigning);
    }

    private static final class BuilderImpl implements Builder {
        private Integer assigning;

        private Integer booting;

        private Integer connectionLost;

        private Integer deregistering;

        private Integer online;

        private Integer pending;

        private Integer rebooting;

        private Integer registered;

        private Integer registering;

        private Integer requested;

        private Integer runningSetup;

        private Integer setupFailed;

        private Integer shuttingDown;

        private Integer startFailed;

        private Integer stopped;

        private Integer stopping;

        private Integer terminated;

        private Integer terminating;

        private Integer unassigning;

        private BuilderImpl() {
        }

        private BuilderImpl(InstancesCount model) {
            setAssigning(model.assigning);
            setBooting(model.booting);
            setConnectionLost(model.connectionLost);
            setDeregistering(model.deregistering);
            setOnline(model.online);
            setPending(model.pending);
            setRebooting(model.rebooting);
            setRegistered(model.registered);
            setRegistering(model.registering);
            setRequested(model.requested);
            setRunningSetup(model.runningSetup);
            setSetupFailed(model.setupFailed);
            setShuttingDown(model.shuttingDown);
            setStartFailed(model.startFailed);
            setStopped(model.stopped);
            setStopping(model.stopping);
            setTerminated(model.terminated);
            setTerminating(model.terminating);
            setUnassigning(model.unassigning);
        }

        public final Integer getAssigning() {
            return assigning;
        }

        @Override
        public final Builder assigning(Integer assigning) {
            this.assigning = assigning;
            return this;
        }

        public final void setAssigning(Integer assigning) {
            this.assigning = assigning;
        }

        public final Integer getBooting() {
            return booting;
        }

        @Override
        public final Builder booting(Integer booting) {
            this.booting = booting;
            return this;
        }

        public final void setBooting(Integer booting) {
            this.booting = booting;
        }

        public final Integer getConnectionLost() {
            return connectionLost;
        }

        @Override
        public final Builder connectionLost(Integer connectionLost) {
            this.connectionLost = connectionLost;
            return this;
        }

        public final void setConnectionLost(Integer connectionLost) {
            this.connectionLost = connectionLost;
        }

        public final Integer getDeregistering() {
            return deregistering;
        }

        @Override
        public final Builder deregistering(Integer deregistering) {
            this.deregistering = deregistering;
            return this;
        }

        public final void setDeregistering(Integer deregistering) {
            this.deregistering = deregistering;
        }

        public final Integer getOnline() {
            return online;
        }

        @Override
        public final Builder online(Integer online) {
            this.online = online;
            return this;
        }

        public final void setOnline(Integer online) {
            this.online = online;
        }

        public final Integer getPending() {
            return pending;
        }

        @Override
        public final Builder pending(Integer pending) {
            this.pending = pending;
            return this;
        }

        public final void setPending(Integer pending) {
            this.pending = pending;
        }

        public final Integer getRebooting() {
            return rebooting;
        }

        @Override
        public final Builder rebooting(Integer rebooting) {
            this.rebooting = rebooting;
            return this;
        }

        public final void setRebooting(Integer rebooting) {
            this.rebooting = rebooting;
        }

        public final Integer getRegistered() {
            return registered;
        }

        @Override
        public final Builder registered(Integer registered) {
            this.registered = registered;
            return this;
        }

        public final void setRegistered(Integer registered) {
            this.registered = registered;
        }

        public final Integer getRegistering() {
            return registering;
        }

        @Override
        public final Builder registering(Integer registering) {
            this.registering = registering;
            return this;
        }

        public final void setRegistering(Integer registering) {
            this.registering = registering;
        }

        public final Integer getRequested() {
            return requested;
        }

        @Override
        public final Builder requested(Integer requested) {
            this.requested = requested;
            return this;
        }

        public final void setRequested(Integer requested) {
            this.requested = requested;
        }

        public final Integer getRunningSetup() {
            return runningSetup;
        }

        @Override
        public final Builder runningSetup(Integer runningSetup) {
            this.runningSetup = runningSetup;
            return this;
        }

        public final void setRunningSetup(Integer runningSetup) {
            this.runningSetup = runningSetup;
        }

        public final Integer getSetupFailed() {
            return setupFailed;
        }

        @Override
        public final Builder setupFailed(Integer setupFailed) {
            this.setupFailed = setupFailed;
            return this;
        }

        public final void setSetupFailed(Integer setupFailed) {
            this.setupFailed = setupFailed;
        }

        public final Integer getShuttingDown() {
            return shuttingDown;
        }

        @Override
        public final Builder shuttingDown(Integer shuttingDown) {
            this.shuttingDown = shuttingDown;
            return this;
        }

        public final void setShuttingDown(Integer shuttingDown) {
            this.shuttingDown = shuttingDown;
        }

        public final Integer getStartFailed() {
            return startFailed;
        }

        @Override
        public final Builder startFailed(Integer startFailed) {
            this.startFailed = startFailed;
            return this;
        }

        public final void setStartFailed(Integer startFailed) {
            this.startFailed = startFailed;
        }

        public final Integer getStopped() {
            return stopped;
        }

        @Override
        public final Builder stopped(Integer stopped) {
            this.stopped = stopped;
            return this;
        }

        public final void setStopped(Integer stopped) {
            this.stopped = stopped;
        }

        public final Integer getStopping() {
            return stopping;
        }

        @Override
        public final Builder stopping(Integer stopping) {
            this.stopping = stopping;
            return this;
        }

        public final void setStopping(Integer stopping) {
            this.stopping = stopping;
        }

        public final Integer getTerminated() {
            return terminated;
        }

        @Override
        public final Builder terminated(Integer terminated) {
            this.terminated = terminated;
            return this;
        }

        public final void setTerminated(Integer terminated) {
            this.terminated = terminated;
        }

        public final Integer getTerminating() {
            return terminating;
        }

        @Override
        public final Builder terminating(Integer terminating) {
            this.terminating = terminating;
            return this;
        }

        public final void setTerminating(Integer terminating) {
            this.terminating = terminating;
        }

        public final Integer getUnassigning() {
            return unassigning;
        }

        @Override
        public final Builder unassigning(Integer unassigning) {
            this.unassigning = unassigning;
            return this;
        }

        public final void setUnassigning(Integer unassigning) {
            this.unassigning = unassigning;
        }

        @Override
        public InstancesCount build() {
            return new InstancesCount(this);
        }
    }
}
