/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.InstanceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Instance implements StructuredPojo, ToCopyableBuilder<Instance.Builder, Instance> {
    private final String agentVersion;

    private final String amiId;

    private final String architecture;

    private final String arn;

    private final String autoScalingType;

    private final String availabilityZone;

    private final List<BlockDeviceMapping> blockDeviceMappings;

    private final String createdAt;

    private final Boolean ebsOptimized;

    private final String ec2InstanceId;

    private final String ecsClusterArn;

    private final String ecsContainerInstanceArn;

    private final String elasticIp;

    private final String hostname;

    private final String infrastructureClass;

    private final Boolean installUpdatesOnBoot;

    private final String instanceId;

    private final String instanceProfileArn;

    private final String instanceType;

    private final String lastServiceErrorId;

    private final List<String> layerIds;

    private final String os;

    private final String platform;

    private final String privateDns;

    private final String privateIp;

    private final String publicDns;

    private final String publicIp;

    private final String registeredBy;

    private final String reportedAgentVersion;

    private final ReportedOs reportedOs;

    private final String rootDeviceType;

    private final String rootDeviceVolumeId;

    private final List<String> securityGroupIds;

    private final String sshHostDsaKeyFingerprint;

    private final String sshHostRsaKeyFingerprint;

    private final String sshKeyName;

    private final String stackId;

    private final String status;

    private final String subnetId;

    private final String tenancy;

    private final String virtualizationType;

    private Instance(BuilderImpl builder) {
        this.agentVersion = builder.agentVersion;
        this.amiId = builder.amiId;
        this.architecture = builder.architecture;
        this.arn = builder.arn;
        this.autoScalingType = builder.autoScalingType;
        this.availabilityZone = builder.availabilityZone;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.createdAt = builder.createdAt;
        this.ebsOptimized = builder.ebsOptimized;
        this.ec2InstanceId = builder.ec2InstanceId;
        this.ecsClusterArn = builder.ecsClusterArn;
        this.ecsContainerInstanceArn = builder.ecsContainerInstanceArn;
        this.elasticIp = builder.elasticIp;
        this.hostname = builder.hostname;
        this.infrastructureClass = builder.infrastructureClass;
        this.installUpdatesOnBoot = builder.installUpdatesOnBoot;
        this.instanceId = builder.instanceId;
        this.instanceProfileArn = builder.instanceProfileArn;
        this.instanceType = builder.instanceType;
        this.lastServiceErrorId = builder.lastServiceErrorId;
        this.layerIds = builder.layerIds;
        this.os = builder.os;
        this.platform = builder.platform;
        this.privateDns = builder.privateDns;
        this.privateIp = builder.privateIp;
        this.publicDns = builder.publicDns;
        this.publicIp = builder.publicIp;
        this.registeredBy = builder.registeredBy;
        this.reportedAgentVersion = builder.reportedAgentVersion;
        this.reportedOs = builder.reportedOs;
        this.rootDeviceType = builder.rootDeviceType;
        this.rootDeviceVolumeId = builder.rootDeviceVolumeId;
        this.securityGroupIds = builder.securityGroupIds;
        this.sshHostDsaKeyFingerprint = builder.sshHostDsaKeyFingerprint;
        this.sshHostRsaKeyFingerprint = builder.sshHostRsaKeyFingerprint;
        this.sshKeyName = builder.sshKeyName;
        this.stackId = builder.stackId;
        this.status = builder.status;
        this.subnetId = builder.subnetId;
        this.tenancy = builder.tenancy;
        this.virtualizationType = builder.virtualizationType;
    }

    /**
     * <p>
     * The agent version. This parameter is set to <code>INHERIT</code> if the instance inherits the default stack
     * setting or to a a version number for a fixed agent version.
     * </p>
     * 
     * @return The agent version. This parameter is set to <code>INHERIT</code> if the instance inherits the default
     *         stack setting or to a a version number for a fixed agent version.
     */
    public String agentVersion() {
        return agentVersion;
    }

    /**
     * <p>
     * A custom AMI ID to be used to create the instance. For more information, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Instances</a>
     * </p>
     * 
     * @return A custom AMI ID to be used to create the instance. For more information, see <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html"
     *         >Instances</a>
     */
    public String amiId() {
        return amiId;
    }

    /**
     * <p>
     * The instance architecture: "i386" or "x86_64".
     * </p>
     * 
     * @return The instance architecture: "i386" or "x86_64".
     * @see Architecture
     */
    public String architecture() {
        return architecture;
    }

    /**
     * Returns the value of the Arn property for this object.
     * 
     * @return The value of the Arn property for this object.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * For load-based or time-based instances, the type.
     * </p>
     * 
     * @return For load-based or time-based instances, the type.
     * @see AutoScalingType
     */
    public String autoScalingType() {
        return autoScalingType;
    }

    /**
     * <p>
     * The instance Availability Zone. For more information, see <a
     * href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
     * </p>
     * 
     * @return The instance Availability Zone. For more information, see <a
     *         href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * An array of <code>BlockDeviceMapping</code> objects that specify the instance's block device mappings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>BlockDeviceMapping</code> objects that specify the instance's block device mappings.
     */
    public List<BlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * The time that the instance was created.
     * </p>
     * 
     * @return The time that the instance was created.
     */
    public String createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Whether this is an Amazon EBS-optimized instance.
     * </p>
     * 
     * @return Whether this is an Amazon EBS-optimized instance.
     */
    public Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * The ID of the associated Amazon EC2 instance.
     * </p>
     * 
     * @return The ID of the associated Amazon EC2 instance.
     */
    public String ec2InstanceId() {
        return ec2InstanceId;
    }

    /**
     * <p>
     * For container instances, the Amazon ECS cluster's ARN.
     * </p>
     * 
     * @return For container instances, the Amazon ECS cluster's ARN.
     */
    public String ecsClusterArn() {
        return ecsClusterArn;
    }

    /**
     * <p>
     * For container instances, the instance's ARN.
     * </p>
     * 
     * @return For container instances, the instance's ARN.
     */
    public String ecsContainerInstanceArn() {
        return ecsContainerInstanceArn;
    }

    /**
     * <p>
     * The instance <a href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic
     * IP address </a>.
     * </p>
     * 
     * @return The instance <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP
     *         address </a>.
     */
    public String elasticIp() {
        return elasticIp;
    }

    /**
     * <p>
     * The instance host name.
     * </p>
     * 
     * @return The instance host name.
     */
    public String hostname() {
        return hostname;
    }

    /**
     * <p>
     * For registered instances, the infrastructure class: <code>ec2</code> or <code>on-premises</code>.
     * </p>
     * 
     * @return For registered instances, the infrastructure class: <code>ec2</code> or <code>on-premises</code>.
     */
    public String infrastructureClass() {
        return infrastructureClass;
    }

    /**
     * <p>
     * Whether to install operating system and package updates when the instance boots. The default value is
     * <code>true</code>. If this value is set to <code>false</code>, you must then update your instances manually by
     * using <a>CreateDeployment</a> to run the <code>update_dependencies</code> stack command or by manually running
     * <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances.
     * </p>
     * <note>
     * <p>
     * We strongly recommend using the default value of <code>true</code>, to ensure that your instances have the latest
     * security updates.
     * </p>
     * </note>
     * 
     * @return Whether to install operating system and package updates when the instance boots. The default value is
     *         <code>true</code>. If this value is set to <code>false</code>, you must then update your instances
     *         manually by using <a>CreateDeployment</a> to run the <code>update_dependencies</code> stack command or by
     *         manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances. </p>
     *         <note>
     *         <p>
     *         We strongly recommend using the default value of <code>true</code>, to ensure that your instances have
     *         the latest security updates.
     *         </p>
     */
    public Boolean installUpdatesOnBoot() {
        return installUpdatesOnBoot;
    }

    /**
     * <p>
     * The instance ID.
     * </p>
     * 
     * @return The instance ID.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The ARN of the instance's IAM profile. For more information about IAM ARNs, see <a
     * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
     * </p>
     * 
     * @return The ARN of the instance's IAM profile. For more information about IAM ARNs, see <a
     *         href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
     */
    public String instanceProfileArn() {
        return instanceProfileArn;
    }

    /**
     * <p>
     * The instance type, such as <code>t2.micro</code>.
     * </p>
     * 
     * @return The instance type, such as <code>t2.micro</code>.
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The ID of the last service error. For more information, call <a>DescribeServiceErrors</a>.
     * </p>
     * 
     * @return The ID of the last service error. For more information, call <a>DescribeServiceErrors</a>.
     */
    public String lastServiceErrorId() {
        return lastServiceErrorId;
    }

    /**
     * <p>
     * An array containing the instance layer IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array containing the instance layer IDs.
     */
    public List<String> layerIds() {
        return layerIds;
    }

    /**
     * <p>
     * The instance's operating system.
     * </p>
     * 
     * @return The instance's operating system.
     */
    public String os() {
        return os;
    }

    /**
     * <p>
     * The instance's platform.
     * </p>
     * 
     * @return The instance's platform.
     */
    public String platform() {
        return platform;
    }

    /**
     * <p>
     * The instance's private DNS name.
     * </p>
     * 
     * @return The instance's private DNS name.
     */
    public String privateDns() {
        return privateDns;
    }

    /**
     * <p>
     * The instance's private IP address.
     * </p>
     * 
     * @return The instance's private IP address.
     */
    public String privateIp() {
        return privateIp;
    }

    /**
     * <p>
     * The instance public DNS name.
     * </p>
     * 
     * @return The instance public DNS name.
     */
    public String publicDns() {
        return publicDns;
    }

    /**
     * <p>
     * The instance public IP address.
     * </p>
     * 
     * @return The instance public IP address.
     */
    public String publicIp() {
        return publicIp;
    }

    /**
     * <p>
     * For registered instances, who performed the registration.
     * </p>
     * 
     * @return For registered instances, who performed the registration.
     */
    public String registeredBy() {
        return registeredBy;
    }

    /**
     * <p>
     * The instance's reported AWS OpsWorks Stacks agent version.
     * </p>
     * 
     * @return The instance's reported AWS OpsWorks Stacks agent version.
     */
    public String reportedAgentVersion() {
        return reportedAgentVersion;
    }

    /**
     * <p>
     * For registered instances, the reported operating system.
     * </p>
     * 
     * @return For registered instances, the reported operating system.
     */
    public ReportedOs reportedOs() {
        return reportedOs;
    }

    /**
     * <p>
     * The instance's root device type. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device">Storage
     * for the Root Device</a>.
     * </p>
     * 
     * @return The instance's root device type. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
     *         >Storage for the Root Device</a>.
     * @see RootDeviceType
     */
    public String rootDeviceType() {
        return rootDeviceType;
    }

    /**
     * <p>
     * The root device volume ID.
     * </p>
     * 
     * @return The root device volume ID.
     */
    public String rootDeviceVolumeId() {
        return rootDeviceVolumeId;
    }

    /**
     * <p>
     * An array containing the instance security group IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array containing the instance security group IDs.
     */
    public List<String> securityGroupIds() {
        return securityGroupIds;
    }

    /**
     * <p>
     * The SSH key's Deep Security Agent (DSA) fingerprint.
     * </p>
     * 
     * @return The SSH key's Deep Security Agent (DSA) fingerprint.
     */
    public String sshHostDsaKeyFingerprint() {
        return sshHostDsaKeyFingerprint;
    }

    /**
     * <p>
     * The SSH key's RSA fingerprint.
     * </p>
     * 
     * @return The SSH key's RSA fingerprint.
     */
    public String sshHostRsaKeyFingerprint() {
        return sshHostRsaKeyFingerprint;
    }

    /**
     * <p>
     * The instance's Amazon EC2 key-pair name.
     * </p>
     * 
     * @return The instance's Amazon EC2 key-pair name.
     */
    public String sshKeyName() {
        return sshKeyName;
    }

    /**
     * <p>
     * The stack ID.
     * </p>
     * 
     * @return The stack ID.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The instance status:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>booting</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>connection_lost</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>online</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>pending</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>rebooting</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>requested</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>running_setup</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>setup_failed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>shutting_down</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>start_failed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stop_failed</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stopped</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stopping</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>terminated</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>terminating</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The instance status:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>booting</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>connection_lost</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>online</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>pending</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>rebooting</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>requested</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>running_setup</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>setup_failed</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>shutting_down</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>start_failed</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>stop_failed</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>stopped</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>stopping</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>terminated</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>terminating</code>
     *         </p>
     *         </li>
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The instance's subnet ID; applicable only if the stack is running in a VPC.
     * </p>
     * 
     * @return The instance's subnet ID; applicable only if the stack is running in a VPC.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The instance's tenancy option, such as <code>dedicated</code> or <code>host</code>.
     * </p>
     * 
     * @return The instance's tenancy option, such as <code>dedicated</code> or <code>host</code>.
     */
    public String tenancy() {
        return tenancy;
    }

    /**
     * <p>
     * The instance's virtualization type: <code>paravirtual</code> or <code>hvm</code>.
     * </p>
     * 
     * @return The instance's virtualization type: <code>paravirtual</code> or <code>hvm</code>.
     * @see VirtualizationType
     */
    public String virtualizationType() {
        return virtualizationType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((agentVersion() == null) ? 0 : agentVersion().hashCode());
        hashCode = 31 * hashCode + ((amiId() == null) ? 0 : amiId().hashCode());
        hashCode = 31 * hashCode + ((architecture() == null) ? 0 : architecture().hashCode());
        hashCode = 31 * hashCode + ((arn() == null) ? 0 : arn().hashCode());
        hashCode = 31 * hashCode + ((autoScalingType() == null) ? 0 : autoScalingType().hashCode());
        hashCode = 31 * hashCode + ((availabilityZone() == null) ? 0 : availabilityZone().hashCode());
        hashCode = 31 * hashCode + ((blockDeviceMappings() == null) ? 0 : blockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + ((createdAt() == null) ? 0 : createdAt().hashCode());
        hashCode = 31 * hashCode + ((ebsOptimized() == null) ? 0 : ebsOptimized().hashCode());
        hashCode = 31 * hashCode + ((ec2InstanceId() == null) ? 0 : ec2InstanceId().hashCode());
        hashCode = 31 * hashCode + ((ecsClusterArn() == null) ? 0 : ecsClusterArn().hashCode());
        hashCode = 31 * hashCode + ((ecsContainerInstanceArn() == null) ? 0 : ecsContainerInstanceArn().hashCode());
        hashCode = 31 * hashCode + ((elasticIp() == null) ? 0 : elasticIp().hashCode());
        hashCode = 31 * hashCode + ((hostname() == null) ? 0 : hostname().hashCode());
        hashCode = 31 * hashCode + ((infrastructureClass() == null) ? 0 : infrastructureClass().hashCode());
        hashCode = 31 * hashCode + ((installUpdatesOnBoot() == null) ? 0 : installUpdatesOnBoot().hashCode());
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((instanceProfileArn() == null) ? 0 : instanceProfileArn().hashCode());
        hashCode = 31 * hashCode + ((instanceType() == null) ? 0 : instanceType().hashCode());
        hashCode = 31 * hashCode + ((lastServiceErrorId() == null) ? 0 : lastServiceErrorId().hashCode());
        hashCode = 31 * hashCode + ((layerIds() == null) ? 0 : layerIds().hashCode());
        hashCode = 31 * hashCode + ((os() == null) ? 0 : os().hashCode());
        hashCode = 31 * hashCode + ((platform() == null) ? 0 : platform().hashCode());
        hashCode = 31 * hashCode + ((privateDns() == null) ? 0 : privateDns().hashCode());
        hashCode = 31 * hashCode + ((privateIp() == null) ? 0 : privateIp().hashCode());
        hashCode = 31 * hashCode + ((publicDns() == null) ? 0 : publicDns().hashCode());
        hashCode = 31 * hashCode + ((publicIp() == null) ? 0 : publicIp().hashCode());
        hashCode = 31 * hashCode + ((registeredBy() == null) ? 0 : registeredBy().hashCode());
        hashCode = 31 * hashCode + ((reportedAgentVersion() == null) ? 0 : reportedAgentVersion().hashCode());
        hashCode = 31 * hashCode + ((reportedOs() == null) ? 0 : reportedOs().hashCode());
        hashCode = 31 * hashCode + ((rootDeviceType() == null) ? 0 : rootDeviceType().hashCode());
        hashCode = 31 * hashCode + ((rootDeviceVolumeId() == null) ? 0 : rootDeviceVolumeId().hashCode());
        hashCode = 31 * hashCode + ((securityGroupIds() == null) ? 0 : securityGroupIds().hashCode());
        hashCode = 31 * hashCode + ((sshHostDsaKeyFingerprint() == null) ? 0 : sshHostDsaKeyFingerprint().hashCode());
        hashCode = 31 * hashCode + ((sshHostRsaKeyFingerprint() == null) ? 0 : sshHostRsaKeyFingerprint().hashCode());
        hashCode = 31 * hashCode + ((sshKeyName() == null) ? 0 : sshKeyName().hashCode());
        hashCode = 31 * hashCode + ((stackId() == null) ? 0 : stackId().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((subnetId() == null) ? 0 : subnetId().hashCode());
        hashCode = 31 * hashCode + ((tenancy() == null) ? 0 : tenancy().hashCode());
        hashCode = 31 * hashCode + ((virtualizationType() == null) ? 0 : virtualizationType().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Instance)) {
            return false;
        }
        Instance other = (Instance) obj;
        if (other.agentVersion() == null ^ this.agentVersion() == null) {
            return false;
        }
        if (other.agentVersion() != null && !other.agentVersion().equals(this.agentVersion())) {
            return false;
        }
        if (other.amiId() == null ^ this.amiId() == null) {
            return false;
        }
        if (other.amiId() != null && !other.amiId().equals(this.amiId())) {
            return false;
        }
        if (other.architecture() == null ^ this.architecture() == null) {
            return false;
        }
        if (other.architecture() != null && !other.architecture().equals(this.architecture())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.autoScalingType() == null ^ this.autoScalingType() == null) {
            return false;
        }
        if (other.autoScalingType() != null && !other.autoScalingType().equals(this.autoScalingType())) {
            return false;
        }
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.blockDeviceMappings() == null ^ this.blockDeviceMappings() == null) {
            return false;
        }
        if (other.blockDeviceMappings() != null && !other.blockDeviceMappings().equals(this.blockDeviceMappings())) {
            return false;
        }
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        if (other.createdAt() != null && !other.createdAt().equals(this.createdAt())) {
            return false;
        }
        if (other.ebsOptimized() == null ^ this.ebsOptimized() == null) {
            return false;
        }
        if (other.ebsOptimized() != null && !other.ebsOptimized().equals(this.ebsOptimized())) {
            return false;
        }
        if (other.ec2InstanceId() == null ^ this.ec2InstanceId() == null) {
            return false;
        }
        if (other.ec2InstanceId() != null && !other.ec2InstanceId().equals(this.ec2InstanceId())) {
            return false;
        }
        if (other.ecsClusterArn() == null ^ this.ecsClusterArn() == null) {
            return false;
        }
        if (other.ecsClusterArn() != null && !other.ecsClusterArn().equals(this.ecsClusterArn())) {
            return false;
        }
        if (other.ecsContainerInstanceArn() == null ^ this.ecsContainerInstanceArn() == null) {
            return false;
        }
        if (other.ecsContainerInstanceArn() != null && !other.ecsContainerInstanceArn().equals(this.ecsContainerInstanceArn())) {
            return false;
        }
        if (other.elasticIp() == null ^ this.elasticIp() == null) {
            return false;
        }
        if (other.elasticIp() != null && !other.elasticIp().equals(this.elasticIp())) {
            return false;
        }
        if (other.hostname() == null ^ this.hostname() == null) {
            return false;
        }
        if (other.hostname() != null && !other.hostname().equals(this.hostname())) {
            return false;
        }
        if (other.infrastructureClass() == null ^ this.infrastructureClass() == null) {
            return false;
        }
        if (other.infrastructureClass() != null && !other.infrastructureClass().equals(this.infrastructureClass())) {
            return false;
        }
        if (other.installUpdatesOnBoot() == null ^ this.installUpdatesOnBoot() == null) {
            return false;
        }
        if (other.installUpdatesOnBoot() != null && !other.installUpdatesOnBoot().equals(this.installUpdatesOnBoot())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.instanceProfileArn() == null ^ this.instanceProfileArn() == null) {
            return false;
        }
        if (other.instanceProfileArn() != null && !other.instanceProfileArn().equals(this.instanceProfileArn())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.lastServiceErrorId() == null ^ this.lastServiceErrorId() == null) {
            return false;
        }
        if (other.lastServiceErrorId() != null && !other.lastServiceErrorId().equals(this.lastServiceErrorId())) {
            return false;
        }
        if (other.layerIds() == null ^ this.layerIds() == null) {
            return false;
        }
        if (other.layerIds() != null && !other.layerIds().equals(this.layerIds())) {
            return false;
        }
        if (other.os() == null ^ this.os() == null) {
            return false;
        }
        if (other.os() != null && !other.os().equals(this.os())) {
            return false;
        }
        if (other.platform() == null ^ this.platform() == null) {
            return false;
        }
        if (other.platform() != null && !other.platform().equals(this.platform())) {
            return false;
        }
        if (other.privateDns() == null ^ this.privateDns() == null) {
            return false;
        }
        if (other.privateDns() != null && !other.privateDns().equals(this.privateDns())) {
            return false;
        }
        if (other.privateIp() == null ^ this.privateIp() == null) {
            return false;
        }
        if (other.privateIp() != null && !other.privateIp().equals(this.privateIp())) {
            return false;
        }
        if (other.publicDns() == null ^ this.publicDns() == null) {
            return false;
        }
        if (other.publicDns() != null && !other.publicDns().equals(this.publicDns())) {
            return false;
        }
        if (other.publicIp() == null ^ this.publicIp() == null) {
            return false;
        }
        if (other.publicIp() != null && !other.publicIp().equals(this.publicIp())) {
            return false;
        }
        if (other.registeredBy() == null ^ this.registeredBy() == null) {
            return false;
        }
        if (other.registeredBy() != null && !other.registeredBy().equals(this.registeredBy())) {
            return false;
        }
        if (other.reportedAgentVersion() == null ^ this.reportedAgentVersion() == null) {
            return false;
        }
        if (other.reportedAgentVersion() != null && !other.reportedAgentVersion().equals(this.reportedAgentVersion())) {
            return false;
        }
        if (other.reportedOs() == null ^ this.reportedOs() == null) {
            return false;
        }
        if (other.reportedOs() != null && !other.reportedOs().equals(this.reportedOs())) {
            return false;
        }
        if (other.rootDeviceType() == null ^ this.rootDeviceType() == null) {
            return false;
        }
        if (other.rootDeviceType() != null && !other.rootDeviceType().equals(this.rootDeviceType())) {
            return false;
        }
        if (other.rootDeviceVolumeId() == null ^ this.rootDeviceVolumeId() == null) {
            return false;
        }
        if (other.rootDeviceVolumeId() != null && !other.rootDeviceVolumeId().equals(this.rootDeviceVolumeId())) {
            return false;
        }
        if (other.securityGroupIds() == null ^ this.securityGroupIds() == null) {
            return false;
        }
        if (other.securityGroupIds() != null && !other.securityGroupIds().equals(this.securityGroupIds())) {
            return false;
        }
        if (other.sshHostDsaKeyFingerprint() == null ^ this.sshHostDsaKeyFingerprint() == null) {
            return false;
        }
        if (other.sshHostDsaKeyFingerprint() != null && !other.sshHostDsaKeyFingerprint().equals(this.sshHostDsaKeyFingerprint())) {
            return false;
        }
        if (other.sshHostRsaKeyFingerprint() == null ^ this.sshHostRsaKeyFingerprint() == null) {
            return false;
        }
        if (other.sshHostRsaKeyFingerprint() != null && !other.sshHostRsaKeyFingerprint().equals(this.sshHostRsaKeyFingerprint())) {
            return false;
        }
        if (other.sshKeyName() == null ^ this.sshKeyName() == null) {
            return false;
        }
        if (other.sshKeyName() != null && !other.sshKeyName().equals(this.sshKeyName())) {
            return false;
        }
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.subnetId() == null ^ this.subnetId() == null) {
            return false;
        }
        if (other.subnetId() != null && !other.subnetId().equals(this.subnetId())) {
            return false;
        }
        if (other.tenancy() == null ^ this.tenancy() == null) {
            return false;
        }
        if (other.tenancy() != null && !other.tenancy().equals(this.tenancy())) {
            return false;
        }
        if (other.virtualizationType() == null ^ this.virtualizationType() == null) {
            return false;
        }
        if (other.virtualizationType() != null && !other.virtualizationType().equals(this.virtualizationType())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (agentVersion() != null) {
            sb.append("AgentVersion: ").append(agentVersion()).append(",");
        }
        if (amiId() != null) {
            sb.append("AmiId: ").append(amiId()).append(",");
        }
        if (architecture() != null) {
            sb.append("Architecture: ").append(architecture()).append(",");
        }
        if (arn() != null) {
            sb.append("Arn: ").append(arn()).append(",");
        }
        if (autoScalingType() != null) {
            sb.append("AutoScalingType: ").append(autoScalingType()).append(",");
        }
        if (availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(availabilityZone()).append(",");
        }
        if (blockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(blockDeviceMappings()).append(",");
        }
        if (createdAt() != null) {
            sb.append("CreatedAt: ").append(createdAt()).append(",");
        }
        if (ebsOptimized() != null) {
            sb.append("EbsOptimized: ").append(ebsOptimized()).append(",");
        }
        if (ec2InstanceId() != null) {
            sb.append("Ec2InstanceId: ").append(ec2InstanceId()).append(",");
        }
        if (ecsClusterArn() != null) {
            sb.append("EcsClusterArn: ").append(ecsClusterArn()).append(",");
        }
        if (ecsContainerInstanceArn() != null) {
            sb.append("EcsContainerInstanceArn: ").append(ecsContainerInstanceArn()).append(",");
        }
        if (elasticIp() != null) {
            sb.append("ElasticIp: ").append(elasticIp()).append(",");
        }
        if (hostname() != null) {
            sb.append("Hostname: ").append(hostname()).append(",");
        }
        if (infrastructureClass() != null) {
            sb.append("InfrastructureClass: ").append(infrastructureClass()).append(",");
        }
        if (installUpdatesOnBoot() != null) {
            sb.append("InstallUpdatesOnBoot: ").append(installUpdatesOnBoot()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (instanceProfileArn() != null) {
            sb.append("InstanceProfileArn: ").append(instanceProfileArn()).append(",");
        }
        if (instanceType() != null) {
            sb.append("InstanceType: ").append(instanceType()).append(",");
        }
        if (lastServiceErrorId() != null) {
            sb.append("LastServiceErrorId: ").append(lastServiceErrorId()).append(",");
        }
        if (layerIds() != null) {
            sb.append("LayerIds: ").append(layerIds()).append(",");
        }
        if (os() != null) {
            sb.append("Os: ").append(os()).append(",");
        }
        if (platform() != null) {
            sb.append("Platform: ").append(platform()).append(",");
        }
        if (privateDns() != null) {
            sb.append("PrivateDns: ").append(privateDns()).append(",");
        }
        if (privateIp() != null) {
            sb.append("PrivateIp: ").append(privateIp()).append(",");
        }
        if (publicDns() != null) {
            sb.append("PublicDns: ").append(publicDns()).append(",");
        }
        if (publicIp() != null) {
            sb.append("PublicIp: ").append(publicIp()).append(",");
        }
        if (registeredBy() != null) {
            sb.append("RegisteredBy: ").append(registeredBy()).append(",");
        }
        if (reportedAgentVersion() != null) {
            sb.append("ReportedAgentVersion: ").append(reportedAgentVersion()).append(",");
        }
        if (reportedOs() != null) {
            sb.append("ReportedOs: ").append(reportedOs()).append(",");
        }
        if (rootDeviceType() != null) {
            sb.append("RootDeviceType: ").append(rootDeviceType()).append(",");
        }
        if (rootDeviceVolumeId() != null) {
            sb.append("RootDeviceVolumeId: ").append(rootDeviceVolumeId()).append(",");
        }
        if (securityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(securityGroupIds()).append(",");
        }
        if (sshHostDsaKeyFingerprint() != null) {
            sb.append("SshHostDsaKeyFingerprint: ").append(sshHostDsaKeyFingerprint()).append(",");
        }
        if (sshHostRsaKeyFingerprint() != null) {
            sb.append("SshHostRsaKeyFingerprint: ").append(sshHostRsaKeyFingerprint()).append(",");
        }
        if (sshKeyName() != null) {
            sb.append("SshKeyName: ").append(sshKeyName()).append(",");
        }
        if (stackId() != null) {
            sb.append("StackId: ").append(stackId()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (subnetId() != null) {
            sb.append("SubnetId: ").append(subnetId()).append(",");
        }
        if (tenancy() != null) {
            sb.append("Tenancy: ").append(tenancy()).append(",");
        }
        if (virtualizationType() != null) {
            sb.append("VirtualizationType: ").append(virtualizationType()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        InstanceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Instance> {
        /**
         * <p>
         * The agent version. This parameter is set to <code>INHERIT</code> if the instance inherits the default stack
         * setting or to a a version number for a fixed agent version.
         * </p>
         * 
         * @param agentVersion
         *        The agent version. This parameter is set to <code>INHERIT</code> if the instance inherits the default
         *        stack setting or to a a version number for a fixed agent version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersion(String agentVersion);

        /**
         * <p>
         * A custom AMI ID to be used to create the instance. For more information, see <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html">Instances</a>
         * </p>
         * 
         * @param amiId
         *        A custom AMI ID to be used to create the instance. For more information, see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/workinginstances-custom-ami.html"
         *        >Instances</a>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amiId(String amiId);

        /**
         * <p>
         * The instance architecture: "i386" or "x86_64".
         * </p>
         * 
         * @param architecture
         *        The instance architecture: "i386" or "x86_64".
         * @see Architecture
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Architecture
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The instance architecture: "i386" or "x86_64".
         * </p>
         * 
         * @param architecture
         *        The instance architecture: "i386" or "x86_64".
         * @see Architecture
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Architecture
         */
        Builder architecture(Architecture architecture);

        /**
         * Sets the value of the Arn property for this object.
         *
         * @param arn
         *        The new value for the Arn property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * For load-based or time-based instances, the type.
         * </p>
         * 
         * @param autoScalingType
         *        For load-based or time-based instances, the type.
         * @see AutoScalingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoScalingType
         */
        Builder autoScalingType(String autoScalingType);

        /**
         * <p>
         * For load-based or time-based instances, the type.
         * </p>
         * 
         * @param autoScalingType
         *        For load-based or time-based instances, the type.
         * @see AutoScalingType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoScalingType
         */
        Builder autoScalingType(AutoScalingType autoScalingType);

        /**
         * <p>
         * The instance Availability Zone. For more information, see <a
         * href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
         * </p>
         * 
         * @param availabilityZone
         *        The instance Availability Zone. For more information, see <a
         *        href="http://docs.aws.amazon.com/general/latest/gr/rande.html">Regions and Endpoints</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * An array of <code>BlockDeviceMapping</code> objects that specify the instance's block device mappings.
         * </p>
         * 
         * @param blockDeviceMappings
         *        An array of <code>BlockDeviceMapping</code> objects that specify the instance's block device mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * An array of <code>BlockDeviceMapping</code> objects that specify the instance's block device mappings.
         * </p>
         * 
         * @param blockDeviceMappings
         *        An array of <code>BlockDeviceMapping</code> objects that specify the instance's block device mappings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * The time that the instance was created.
         * </p>
         * 
         * @param createdAt
         *        The time that the instance was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(String createdAt);

        /**
         * <p>
         * Whether this is an Amazon EBS-optimized instance.
         * </p>
         * 
         * @param ebsOptimized
         *        Whether this is an Amazon EBS-optimized instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * The ID of the associated Amazon EC2 instance.
         * </p>
         * 
         * @param ec2InstanceId
         *        The ID of the associated Amazon EC2 instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceId(String ec2InstanceId);

        /**
         * <p>
         * For container instances, the Amazon ECS cluster's ARN.
         * </p>
         * 
         * @param ecsClusterArn
         *        For container instances, the Amazon ECS cluster's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsClusterArn(String ecsClusterArn);

        /**
         * <p>
         * For container instances, the instance's ARN.
         * </p>
         * 
         * @param ecsContainerInstanceArn
         *        For container instances, the instance's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsContainerInstanceArn(String ecsContainerInstanceArn);

        /**
         * <p>
         * The instance <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP address
         * </a>.
         * </p>
         * 
         * @param elasticIp
         *        The instance <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html">Elastic IP
         *        address </a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticIp(String elasticIp);

        /**
         * <p>
         * The instance host name.
         * </p>
         * 
         * @param hostname
         *        The instance host name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostname(String hostname);

        /**
         * <p>
         * For registered instances, the infrastructure class: <code>ec2</code> or <code>on-premises</code>.
         * </p>
         * 
         * @param infrastructureClass
         *        For registered instances, the infrastructure class: <code>ec2</code> or <code>on-premises</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder infrastructureClass(String infrastructureClass);

        /**
         * <p>
         * Whether to install operating system and package updates when the instance boots. The default value is
         * <code>true</code>. If this value is set to <code>false</code>, you must then update your instances manually
         * by using <a>CreateDeployment</a> to run the <code>update_dependencies</code> stack command or by manually
         * running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances.
         * </p>
         * <note>
         * <p>
         * We strongly recommend using the default value of <code>true</code>, to ensure that your instances have the
         * latest security updates.
         * </p>
         * </note>
         * 
         * @param installUpdatesOnBoot
         *        Whether to install operating system and package updates when the instance boots. The default value is
         *        <code>true</code>. If this value is set to <code>false</code>, you must then update your instances
         *        manually by using <a>CreateDeployment</a> to run the <code>update_dependencies</code> stack command or
         *        by manually running <code>yum</code> (Amazon Linux) or <code>apt-get</code> (Ubuntu) on the instances.
         *        </p> <note>
         *        <p>
         *        We strongly recommend using the default value of <code>true</code>, to ensure that your instances have
         *        the latest security updates.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder installUpdatesOnBoot(Boolean installUpdatesOnBoot);

        /**
         * <p>
         * The instance ID.
         * </p>
         * 
         * @param instanceId
         *        The instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The ARN of the instance's IAM profile. For more information about IAM ARNs, see <a
         * href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
         * </p>
         * 
         * @param instanceProfileArn
         *        The ARN of the instance's IAM profile. For more information about IAM ARNs, see <a
         *        href="http://docs.aws.amazon.com/IAM/latest/UserGuide/Using_Identifiers.html">Using Identifiers</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceProfileArn(String instanceProfileArn);

        /**
         * <p>
         * The instance type, such as <code>t2.micro</code>.
         * </p>
         * 
         * @param instanceType
         *        The instance type, such as <code>t2.micro</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The ID of the last service error. For more information, call <a>DescribeServiceErrors</a>.
         * </p>
         * 
         * @param lastServiceErrorId
         *        The ID of the last service error. For more information, call <a>DescribeServiceErrors</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastServiceErrorId(String lastServiceErrorId);

        /**
         * <p>
         * An array containing the instance layer IDs.
         * </p>
         * 
         * @param layerIds
         *        An array containing the instance layer IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerIds(Collection<String> layerIds);

        /**
         * <p>
         * An array containing the instance layer IDs.
         * </p>
         * 
         * @param layerIds
         *        An array containing the instance layer IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerIds(String... layerIds);

        /**
         * <p>
         * The instance's operating system.
         * </p>
         * 
         * @param os
         *        The instance's operating system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder os(String os);

        /**
         * <p>
         * The instance's platform.
         * </p>
         * 
         * @param platform
         *        The instance's platform.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder platform(String platform);

        /**
         * <p>
         * The instance's private DNS name.
         * </p>
         * 
         * @param privateDns
         *        The instance's private DNS name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateDns(String privateDns);

        /**
         * <p>
         * The instance's private IP address.
         * </p>
         * 
         * @param privateIp
         *        The instance's private IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIp(String privateIp);

        /**
         * <p>
         * The instance public DNS name.
         * </p>
         * 
         * @param publicDns
         *        The instance public DNS name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicDns(String publicDns);

        /**
         * <p>
         * The instance public IP address.
         * </p>
         * 
         * @param publicIp
         *        The instance public IP address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIp(String publicIp);

        /**
         * <p>
         * For registered instances, who performed the registration.
         * </p>
         * 
         * @param registeredBy
         *        For registered instances, who performed the registration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registeredBy(String registeredBy);

        /**
         * <p>
         * The instance's reported AWS OpsWorks Stacks agent version.
         * </p>
         * 
         * @param reportedAgentVersion
         *        The instance's reported AWS OpsWorks Stacks agent version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportedAgentVersion(String reportedAgentVersion);

        /**
         * <p>
         * For registered instances, the reported operating system.
         * </p>
         * 
         * @param reportedOs
         *        For registered instances, the reported operating system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reportedOs(ReportedOs reportedOs);

        /**
         * <p>
         * The instance's root device type. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
         * >Storage for the Root Device</a>.
         * </p>
         * 
         * @param rootDeviceType
         *        The instance's root device type. For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
         *        >Storage for the Root Device</a>.
         * @see RootDeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RootDeviceType
         */
        Builder rootDeviceType(String rootDeviceType);

        /**
         * <p>
         * The instance's root device type. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
         * >Storage for the Root Device</a>.
         * </p>
         * 
         * @param rootDeviceType
         *        The instance's root device type. For more information, see <a href=
         *        "http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ComponentsAMIs.html#storage-for-the-root-device"
         *        >Storage for the Root Device</a>.
         * @see RootDeviceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RootDeviceType
         */
        Builder rootDeviceType(RootDeviceType rootDeviceType);

        /**
         * <p>
         * The root device volume ID.
         * </p>
         * 
         * @param rootDeviceVolumeId
         *        The root device volume ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootDeviceVolumeId(String rootDeviceVolumeId);

        /**
         * <p>
         * An array containing the instance security group IDs.
         * </p>
         * 
         * @param securityGroupIds
         *        An array containing the instance security group IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(Collection<String> securityGroupIds);

        /**
         * <p>
         * An array containing the instance security group IDs.
         * </p>
         * 
         * @param securityGroupIds
         *        An array containing the instance security group IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityGroupIds(String... securityGroupIds);

        /**
         * <p>
         * The SSH key's Deep Security Agent (DSA) fingerprint.
         * </p>
         * 
         * @param sshHostDsaKeyFingerprint
         *        The SSH key's Deep Security Agent (DSA) fingerprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshHostDsaKeyFingerprint(String sshHostDsaKeyFingerprint);

        /**
         * <p>
         * The SSH key's RSA fingerprint.
         * </p>
         * 
         * @param sshHostRsaKeyFingerprint
         *        The SSH key's RSA fingerprint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshHostRsaKeyFingerprint(String sshHostRsaKeyFingerprint);

        /**
         * <p>
         * The instance's Amazon EC2 key-pair name.
         * </p>
         * 
         * @param sshKeyName
         *        The instance's Amazon EC2 key-pair name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sshKeyName(String sshKeyName);

        /**
         * <p>
         * The stack ID.
         * </p>
         * 
         * @param stackId
         *        The stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The instance status:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>booting</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>connection_lost</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>online</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>pending</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>rebooting</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requested</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>running_setup</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>setup_failed</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>shutting_down</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>start_failed</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>stop_failed</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>stopped</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>stopping</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>terminated</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>terminating</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The instance status:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>booting</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>connection_lost</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>online</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>pending</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>rebooting</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>requested</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>running_setup</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>setup_failed</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>shutting_down</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>start_failed</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>stop_failed</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>stopped</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>stopping</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>terminated</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>terminating</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The instance's subnet ID; applicable only if the stack is running in a VPC.
         * </p>
         * 
         * @param subnetId
         *        The instance's subnet ID; applicable only if the stack is running in a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The instance's tenancy option, such as <code>dedicated</code> or <code>host</code>.
         * </p>
         * 
         * @param tenancy
         *        The instance's tenancy option, such as <code>dedicated</code> or <code>host</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tenancy(String tenancy);

        /**
         * <p>
         * The instance's virtualization type: <code>paravirtual</code> or <code>hvm</code>.
         * </p>
         * 
         * @param virtualizationType
         *        The instance's virtualization type: <code>paravirtual</code> or <code>hvm</code>.
         * @see VirtualizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VirtualizationType
         */
        Builder virtualizationType(String virtualizationType);

        /**
         * <p>
         * The instance's virtualization type: <code>paravirtual</code> or <code>hvm</code>.
         * </p>
         * 
         * @param virtualizationType
         *        The instance's virtualization type: <code>paravirtual</code> or <code>hvm</code>.
         * @see VirtualizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VirtualizationType
         */
        Builder virtualizationType(VirtualizationType virtualizationType);
    }

    private static final class BuilderImpl implements Builder {
        private String agentVersion;

        private String amiId;

        private String architecture;

        private String arn;

        private String autoScalingType;

        private String availabilityZone;

        private List<BlockDeviceMapping> blockDeviceMappings;

        private String createdAt;

        private Boolean ebsOptimized;

        private String ec2InstanceId;

        private String ecsClusterArn;

        private String ecsContainerInstanceArn;

        private String elasticIp;

        private String hostname;

        private String infrastructureClass;

        private Boolean installUpdatesOnBoot;

        private String instanceId;

        private String instanceProfileArn;

        private String instanceType;

        private String lastServiceErrorId;

        private List<String> layerIds;

        private String os;

        private String platform;

        private String privateDns;

        private String privateIp;

        private String publicDns;

        private String publicIp;

        private String registeredBy;

        private String reportedAgentVersion;

        private ReportedOs reportedOs;

        private String rootDeviceType;

        private String rootDeviceVolumeId;

        private List<String> securityGroupIds;

        private String sshHostDsaKeyFingerprint;

        private String sshHostRsaKeyFingerprint;

        private String sshKeyName;

        private String stackId;

        private String status;

        private String subnetId;

        private String tenancy;

        private String virtualizationType;

        private BuilderImpl() {
        }

        private BuilderImpl(Instance model) {
            setAgentVersion(model.agentVersion);
            setAmiId(model.amiId);
            setArchitecture(model.architecture);
            setArn(model.arn);
            setAutoScalingType(model.autoScalingType);
            setAvailabilityZone(model.availabilityZone);
            setBlockDeviceMappings(model.blockDeviceMappings);
            setCreatedAt(model.createdAt);
            setEbsOptimized(model.ebsOptimized);
            setEc2InstanceId(model.ec2InstanceId);
            setEcsClusterArn(model.ecsClusterArn);
            setEcsContainerInstanceArn(model.ecsContainerInstanceArn);
            setElasticIp(model.elasticIp);
            setHostname(model.hostname);
            setInfrastructureClass(model.infrastructureClass);
            setInstallUpdatesOnBoot(model.installUpdatesOnBoot);
            setInstanceId(model.instanceId);
            setInstanceProfileArn(model.instanceProfileArn);
            setInstanceType(model.instanceType);
            setLastServiceErrorId(model.lastServiceErrorId);
            setLayerIds(model.layerIds);
            setOs(model.os);
            setPlatform(model.platform);
            setPrivateDns(model.privateDns);
            setPrivateIp(model.privateIp);
            setPublicDns(model.publicDns);
            setPublicIp(model.publicIp);
            setRegisteredBy(model.registeredBy);
            setReportedAgentVersion(model.reportedAgentVersion);
            setReportedOs(model.reportedOs);
            setRootDeviceType(model.rootDeviceType);
            setRootDeviceVolumeId(model.rootDeviceVolumeId);
            setSecurityGroupIds(model.securityGroupIds);
            setSshHostDsaKeyFingerprint(model.sshHostDsaKeyFingerprint);
            setSshHostRsaKeyFingerprint(model.sshHostRsaKeyFingerprint);
            setSshKeyName(model.sshKeyName);
            setStackId(model.stackId);
            setStatus(model.status);
            setSubnetId(model.subnetId);
            setTenancy(model.tenancy);
            setVirtualizationType(model.virtualizationType);
        }

        public final String getAgentVersion() {
            return agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        public final String getAmiId() {
            return amiId;
        }

        @Override
        public final Builder amiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public final void setAmiId(String amiId) {
            this.amiId = amiId;
        }

        public final String getArchitecture() {
            return architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(Architecture architecture) {
            this.architecture(architecture.toString());
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getAutoScalingType() {
            return autoScalingType;
        }

        @Override
        public final Builder autoScalingType(String autoScalingType) {
            this.autoScalingType = autoScalingType;
            return this;
        }

        @Override
        public final Builder autoScalingType(AutoScalingType autoScalingType) {
            this.autoScalingType(autoScalingType.toString());
            return this;
        }

        public final void setAutoScalingType(String autoScalingType) {
            this.autoScalingType = autoScalingType;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Collection<BlockDeviceMapping> getBlockDeviceMappings() {
            return blockDeviceMappings;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingsCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingsCopier.copy(blockDeviceMappings);
        }

        public final String getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final String getEc2InstanceId() {
            return ec2InstanceId;
        }

        @Override
        public final Builder ec2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
            return this;
        }

        public final void setEc2InstanceId(String ec2InstanceId) {
            this.ec2InstanceId = ec2InstanceId;
        }

        public final String getEcsClusterArn() {
            return ecsClusterArn;
        }

        @Override
        public final Builder ecsClusterArn(String ecsClusterArn) {
            this.ecsClusterArn = ecsClusterArn;
            return this;
        }

        public final void setEcsClusterArn(String ecsClusterArn) {
            this.ecsClusterArn = ecsClusterArn;
        }

        public final String getEcsContainerInstanceArn() {
            return ecsContainerInstanceArn;
        }

        @Override
        public final Builder ecsContainerInstanceArn(String ecsContainerInstanceArn) {
            this.ecsContainerInstanceArn = ecsContainerInstanceArn;
            return this;
        }

        public final void setEcsContainerInstanceArn(String ecsContainerInstanceArn) {
            this.ecsContainerInstanceArn = ecsContainerInstanceArn;
        }

        public final String getElasticIp() {
            return elasticIp;
        }

        @Override
        public final Builder elasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
            return this;
        }

        public final void setElasticIp(String elasticIp) {
            this.elasticIp = elasticIp;
        }

        public final String getHostname() {
            return hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public final String getInfrastructureClass() {
            return infrastructureClass;
        }

        @Override
        public final Builder infrastructureClass(String infrastructureClass) {
            this.infrastructureClass = infrastructureClass;
            return this;
        }

        public final void setInfrastructureClass(String infrastructureClass) {
            this.infrastructureClass = infrastructureClass;
        }

        public final Boolean getInstallUpdatesOnBoot() {
            return installUpdatesOnBoot;
        }

        @Override
        public final Builder installUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
            return this;
        }

        public final void setInstallUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getInstanceProfileArn() {
            return instanceProfileArn;
        }

        @Override
        public final Builder instanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
            return this;
        }

        public final void setInstanceProfileArn(String instanceProfileArn) {
            this.instanceProfileArn = instanceProfileArn;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getLastServiceErrorId() {
            return lastServiceErrorId;
        }

        @Override
        public final Builder lastServiceErrorId(String lastServiceErrorId) {
            this.lastServiceErrorId = lastServiceErrorId;
            return this;
        }

        public final void setLastServiceErrorId(String lastServiceErrorId) {
            this.lastServiceErrorId = lastServiceErrorId;
        }

        public final Collection<String> getLayerIds() {
            return layerIds;
        }

        @Override
        public final Builder layerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layerIds(String... layerIds) {
            layerIds(Arrays.asList(layerIds));
            return this;
        }

        public final void setLayerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
        }

        public final String getOs() {
            return os;
        }

        @Override
        public final Builder os(String os) {
            this.os = os;
            return this;
        }

        public final void setOs(String os) {
            this.os = os;
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final String getPrivateDns() {
            return privateDns;
        }

        @Override
        public final Builder privateDns(String privateDns) {
            this.privateDns = privateDns;
            return this;
        }

        public final void setPrivateDns(String privateDns) {
            this.privateDns = privateDns;
        }

        public final String getPrivateIp() {
            return privateIp;
        }

        @Override
        public final Builder privateIp(String privateIp) {
            this.privateIp = privateIp;
            return this;
        }

        public final void setPrivateIp(String privateIp) {
            this.privateIp = privateIp;
        }

        public final String getPublicDns() {
            return publicDns;
        }

        @Override
        public final Builder publicDns(String publicDns) {
            this.publicDns = publicDns;
            return this;
        }

        public final void setPublicDns(String publicDns) {
            this.publicDns = publicDns;
        }

        public final String getPublicIp() {
            return publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public final String getRegisteredBy() {
            return registeredBy;
        }

        @Override
        public final Builder registeredBy(String registeredBy) {
            this.registeredBy = registeredBy;
            return this;
        }

        public final void setRegisteredBy(String registeredBy) {
            this.registeredBy = registeredBy;
        }

        public final String getReportedAgentVersion() {
            return reportedAgentVersion;
        }

        @Override
        public final Builder reportedAgentVersion(String reportedAgentVersion) {
            this.reportedAgentVersion = reportedAgentVersion;
            return this;
        }

        public final void setReportedAgentVersion(String reportedAgentVersion) {
            this.reportedAgentVersion = reportedAgentVersion;
        }

        public final ReportedOs getReportedOs() {
            return reportedOs;
        }

        @Override
        public final Builder reportedOs(ReportedOs reportedOs) {
            this.reportedOs = reportedOs;
            return this;
        }

        public final void setReportedOs(ReportedOs reportedOs) {
            this.reportedOs = reportedOs;
        }

        public final String getRootDeviceType() {
            return rootDeviceType;
        }

        @Override
        public final Builder rootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
            return this;
        }

        @Override
        public final Builder rootDeviceType(RootDeviceType rootDeviceType) {
            this.rootDeviceType(rootDeviceType.toString());
            return this;
        }

        public final void setRootDeviceType(String rootDeviceType) {
            this.rootDeviceType = rootDeviceType;
        }

        public final String getRootDeviceVolumeId() {
            return rootDeviceVolumeId;
        }

        @Override
        public final Builder rootDeviceVolumeId(String rootDeviceVolumeId) {
            this.rootDeviceVolumeId = rootDeviceVolumeId;
            return this;
        }

        public final void setRootDeviceVolumeId(String rootDeviceVolumeId) {
            this.rootDeviceVolumeId = rootDeviceVolumeId;
        }

        public final Collection<String> getSecurityGroupIds() {
            return securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringsCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String... securityGroupIds) {
            securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringsCopier.copy(securityGroupIds);
        }

        public final String getSshHostDsaKeyFingerprint() {
            return sshHostDsaKeyFingerprint;
        }

        @Override
        public final Builder sshHostDsaKeyFingerprint(String sshHostDsaKeyFingerprint) {
            this.sshHostDsaKeyFingerprint = sshHostDsaKeyFingerprint;
            return this;
        }

        public final void setSshHostDsaKeyFingerprint(String sshHostDsaKeyFingerprint) {
            this.sshHostDsaKeyFingerprint = sshHostDsaKeyFingerprint;
        }

        public final String getSshHostRsaKeyFingerprint() {
            return sshHostRsaKeyFingerprint;
        }

        @Override
        public final Builder sshHostRsaKeyFingerprint(String sshHostRsaKeyFingerprint) {
            this.sshHostRsaKeyFingerprint = sshHostRsaKeyFingerprint;
            return this;
        }

        public final void setSshHostRsaKeyFingerprint(String sshHostRsaKeyFingerprint) {
            this.sshHostRsaKeyFingerprint = sshHostRsaKeyFingerprint;
        }

        public final String getSshKeyName() {
            return sshKeyName;
        }

        @Override
        public final Builder sshKeyName(String sshKeyName) {
            this.sshKeyName = sshKeyName;
            return this;
        }

        public final void setSshKeyName(String sshKeyName) {
            this.sshKeyName = sshKeyName;
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final String getTenancy() {
            return tenancy;
        }

        @Override
        public final Builder tenancy(String tenancy) {
            this.tenancy = tenancy;
            return this;
        }

        public final void setTenancy(String tenancy) {
            this.tenancy = tenancy;
        }

        public final String getVirtualizationType() {
            return virtualizationType;
        }

        @Override
        public final Builder virtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
            return this;
        }

        @Override
        public final Builder virtualizationType(VirtualizationType virtualizationType) {
            this.virtualizationType(virtualizationType.toString());
            return this;
        }

        public final void setVirtualizationType(String virtualizationType) {
            this.virtualizationType = virtualizationType;
        }

        @Override
        public Instance build() {
            return new Instance(this);
        }
    }
}
