/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeTimeBasedAutoScaling</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeTimeBasedAutoScalingResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeTimeBasedAutoScalingResponse.Builder, DescribeTimeBasedAutoScalingResponse> {
    private final List<TimeBasedAutoScalingConfiguration> timeBasedAutoScalingConfigurations;

    private DescribeTimeBasedAutoScalingResponse(BuilderImpl builder) {
        this.timeBasedAutoScalingConfigurations = builder.timeBasedAutoScalingConfigurations;
    }

    /**
     * <p>
     * An array of <code>TimeBasedAutoScalingConfiguration</code> objects that describe the configuration for the
     * specified instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>TimeBasedAutoScalingConfiguration</code> objects that describe the configuration for
     *         the specified instances.
     */
    public List<TimeBasedAutoScalingConfiguration> timeBasedAutoScalingConfigurations() {
        return timeBasedAutoScalingConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode
                + ((timeBasedAutoScalingConfigurations() == null) ? 0 : timeBasedAutoScalingConfigurations().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTimeBasedAutoScalingResponse)) {
            return false;
        }
        DescribeTimeBasedAutoScalingResponse other = (DescribeTimeBasedAutoScalingResponse) obj;
        if (other.timeBasedAutoScalingConfigurations() == null ^ this.timeBasedAutoScalingConfigurations() == null) {
            return false;
        }
        if (other.timeBasedAutoScalingConfigurations() != null
                && !other.timeBasedAutoScalingConfigurations().equals(this.timeBasedAutoScalingConfigurations())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (timeBasedAutoScalingConfigurations() != null) {
            sb.append("TimeBasedAutoScalingConfigurations: ").append(timeBasedAutoScalingConfigurations()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeTimeBasedAutoScalingResponse> {
        /**
         * <p>
         * An array of <code>TimeBasedAutoScalingConfiguration</code> objects that describe the configuration for the
         * specified instances.
         * </p>
         * 
         * @param timeBasedAutoScalingConfigurations
         *        An array of <code>TimeBasedAutoScalingConfiguration</code> objects that describe the configuration for
         *        the specified instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeBasedAutoScalingConfigurations(
                Collection<TimeBasedAutoScalingConfiguration> timeBasedAutoScalingConfigurations);

        /**
         * <p>
         * An array of <code>TimeBasedAutoScalingConfiguration</code> objects that describe the configuration for the
         * specified instances.
         * </p>
         * 
         * @param timeBasedAutoScalingConfigurations
         *        An array of <code>TimeBasedAutoScalingConfiguration</code> objects that describe the configuration for
         *        the specified instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeBasedAutoScalingConfigurations(TimeBasedAutoScalingConfiguration... timeBasedAutoScalingConfigurations);
    }

    private static final class BuilderImpl implements Builder {
        private List<TimeBasedAutoScalingConfiguration> timeBasedAutoScalingConfigurations;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTimeBasedAutoScalingResponse model) {
            setTimeBasedAutoScalingConfigurations(model.timeBasedAutoScalingConfigurations);
        }

        public final Collection<TimeBasedAutoScalingConfiguration> getTimeBasedAutoScalingConfigurations() {
            return timeBasedAutoScalingConfigurations;
        }

        @Override
        public final Builder timeBasedAutoScalingConfigurations(
                Collection<TimeBasedAutoScalingConfiguration> timeBasedAutoScalingConfigurations) {
            this.timeBasedAutoScalingConfigurations = TimeBasedAutoScalingConfigurationsCopier
                    .copy(timeBasedAutoScalingConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timeBasedAutoScalingConfigurations(
                TimeBasedAutoScalingConfiguration... timeBasedAutoScalingConfigurations) {
            timeBasedAutoScalingConfigurations(Arrays.asList(timeBasedAutoScalingConfigurations));
            return this;
        }

        public final void setTimeBasedAutoScalingConfigurations(
                Collection<TimeBasedAutoScalingConfiguration> timeBasedAutoScalingConfigurations) {
            this.timeBasedAutoScalingConfigurations = TimeBasedAutoScalingConfigurationsCopier
                    .copy(timeBasedAutoScalingConfigurations);
        }

        @Override
        public DescribeTimeBasedAutoScalingResponse build() {
            return new DescribeTimeBasedAutoScalingResponse(this);
        }
    }
}
