/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeServiceErrorsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeServiceErrorsRequest.Builder, DescribeServiceErrorsRequest> {
    private final String stackId;

    private final String instanceId;

    private final List<String> serviceErrorIds;

    private DescribeServiceErrorsRequest(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.instanceId = builder.instanceId;
        this.serviceErrorIds = builder.serviceErrorIds;
    }

    /**
     * <p>
     * The stack ID. If you use this parameter, <code>DescribeServiceErrors</code> returns descriptions of the errors
     * associated with the specified stack.
     * </p>
     * 
     * @return The stack ID. If you use this parameter, <code>DescribeServiceErrors</code> returns descriptions of the
     *         errors associated with the specified stack.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The instance ID. If you use this parameter, <code>DescribeServiceErrors</code> returns descriptions of the errors
     * associated with the specified instance.
     * </p>
     * 
     * @return The instance ID. If you use this parameter, <code>DescribeServiceErrors</code> returns descriptions of
     *         the errors associated with the specified instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * An array of service error IDs. If you use this parameter, <code>DescribeServiceErrors</code> returns descriptions
     * of the specified errors. Otherwise, it returns a description of every error.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of service error IDs. If you use this parameter, <code>DescribeServiceErrors</code> returns
     *         descriptions of the specified errors. Otherwise, it returns a description of every error.
     */
    public List<String> serviceErrorIds() {
        return serviceErrorIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stackId() == null) ? 0 : stackId().hashCode());
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((serviceErrorIds() == null) ? 0 : serviceErrorIds().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeServiceErrorsRequest)) {
            return false;
        }
        DescribeServiceErrorsRequest other = (DescribeServiceErrorsRequest) obj;
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.serviceErrorIds() == null ^ this.serviceErrorIds() == null) {
            return false;
        }
        if (other.serviceErrorIds() != null && !other.serviceErrorIds().equals(this.serviceErrorIds())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (stackId() != null) {
            sb.append("StackId: ").append(stackId()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (serviceErrorIds() != null) {
            sb.append("ServiceErrorIds: ").append(serviceErrorIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeServiceErrorsRequest> {
        /**
         * <p>
         * The stack ID. If you use this parameter, <code>DescribeServiceErrors</code> returns descriptions of the
         * errors associated with the specified stack.
         * </p>
         * 
         * @param stackId
         *        The stack ID. If you use this parameter, <code>DescribeServiceErrors</code> returns descriptions of
         *        the errors associated with the specified stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The instance ID. If you use this parameter, <code>DescribeServiceErrors</code> returns descriptions of the
         * errors associated with the specified instance.
         * </p>
         * 
         * @param instanceId
         *        The instance ID. If you use this parameter, <code>DescribeServiceErrors</code> returns descriptions of
         *        the errors associated with the specified instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * An array of service error IDs. If you use this parameter, <code>DescribeServiceErrors</code> returns
         * descriptions of the specified errors. Otherwise, it returns a description of every error.
         * </p>
         * 
         * @param serviceErrorIds
         *        An array of service error IDs. If you use this parameter, <code>DescribeServiceErrors</code> returns
         *        descriptions of the specified errors. Otherwise, it returns a description of every error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceErrorIds(Collection<String> serviceErrorIds);

        /**
         * <p>
         * An array of service error IDs. If you use this parameter, <code>DescribeServiceErrors</code> returns
         * descriptions of the specified errors. Otherwise, it returns a description of every error.
         * </p>
         * 
         * @param serviceErrorIds
         *        An array of service error IDs. If you use this parameter, <code>DescribeServiceErrors</code> returns
         *        descriptions of the specified errors. Otherwise, it returns a description of every error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceErrorIds(String... serviceErrorIds);
    }

    private static final class BuilderImpl implements Builder {
        private String stackId;

        private String instanceId;

        private List<String> serviceErrorIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeServiceErrorsRequest model) {
            setStackId(model.stackId);
            setInstanceId(model.instanceId);
            setServiceErrorIds(model.serviceErrorIds);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Collection<String> getServiceErrorIds() {
            return serviceErrorIds;
        }

        @Override
        public final Builder serviceErrorIds(Collection<String> serviceErrorIds) {
            this.serviceErrorIds = StringsCopier.copy(serviceErrorIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceErrorIds(String... serviceErrorIds) {
            serviceErrorIds(Arrays.asList(serviceErrorIds));
            return this;
        }

        public final void setServiceErrorIds(Collection<String> serviceErrorIds) {
            this.serviceErrorIds = StringsCopier.copy(serviceErrorIds);
        }

        @Override
        public DescribeServiceErrorsRequest build() {
            return new DescribeServiceErrorsRequest(this);
        }
    }
}
