/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeLayers</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeLayersResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeLayersResponse.Builder, DescribeLayersResponse> {
    private final List<Layer> layers;

    private DescribeLayersResponse(BuilderImpl builder) {
        this.layers = builder.layers;
    }

    /**
     * <p>
     * An array of <code>Layer</code> objects that describe the layers.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>Layer</code> objects that describe the layers.
     */
    public List<Layer> layers() {
        return layers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((layers() == null) ? 0 : layers().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLayersResponse)) {
            return false;
        }
        DescribeLayersResponse other = (DescribeLayersResponse) obj;
        if (other.layers() == null ^ this.layers() == null) {
            return false;
        }
        if (other.layers() != null && !other.layers().equals(this.layers())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (layers() != null) {
            sb.append("Layers: ").append(layers()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeLayersResponse> {
        /**
         * <p>
         * An array of <code>Layer</code> objects that describe the layers.
         * </p>
         * 
         * @param layers
         *        An array of <code>Layer</code> objects that describe the layers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layers(Collection<Layer> layers);

        /**
         * <p>
         * An array of <code>Layer</code> objects that describe the layers.
         * </p>
         * 
         * @param layers
         *        An array of <code>Layer</code> objects that describe the layers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layers(Layer... layers);
    }

    private static final class BuilderImpl implements Builder {
        private List<Layer> layers;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLayersResponse model) {
            setLayers(model.layers);
        }

        public final Collection<Layer> getLayers() {
            return layers;
        }

        @Override
        public final Builder layers(Collection<Layer> layers) {
            this.layers = LayersCopier.copy(layers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(Layer... layers) {
            layers(Arrays.asList(layers));
            return this;
        }

        public final void setLayers(Collection<Layer> layers) {
            this.layers = LayersCopier.copy(layers);
        }

        @Override
        public DescribeLayersResponse build() {
            return new DescribeLayersResponse(this);
        }
    }
}
