/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeDeployments</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeDeploymentsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeDeploymentsResponse.Builder, DescribeDeploymentsResponse> {
    private final List<Deployment> deployments;

    private DescribeDeploymentsResponse(BuilderImpl builder) {
        this.deployments = builder.deployments;
    }

    /**
     * <p>
     * An array of <code>Deployment</code> objects that describe the deployments.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>Deployment</code> objects that describe the deployments.
     */
    public List<Deployment> deployments() {
        return deployments;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deployments() == null) ? 0 : deployments().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeploymentsResponse)) {
            return false;
        }
        DescribeDeploymentsResponse other = (DescribeDeploymentsResponse) obj;
        if (other.deployments() == null ^ this.deployments() == null) {
            return false;
        }
        if (other.deployments() != null && !other.deployments().equals(this.deployments())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deployments() != null) {
            sb.append("Deployments: ").append(deployments()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeDeploymentsResponse> {
        /**
         * <p>
         * An array of <code>Deployment</code> objects that describe the deployments.
         * </p>
         * 
         * @param deployments
         *        An array of <code>Deployment</code> objects that describe the deployments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deployments(Collection<Deployment> deployments);

        /**
         * <p>
         * An array of <code>Deployment</code> objects that describe the deployments.
         * </p>
         * 
         * @param deployments
         *        An array of <code>Deployment</code> objects that describe the deployments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deployments(Deployment... deployments);
    }

    private static final class BuilderImpl implements Builder {
        private List<Deployment> deployments;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeploymentsResponse model) {
            setDeployments(model.deployments);
        }

        public final Collection<Deployment> getDeployments() {
            return deployments;
        }

        @Override
        public final Builder deployments(Collection<Deployment> deployments) {
            this.deployments = DeploymentsCopier.copy(deployments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deployments(Deployment... deployments) {
            deployments(Arrays.asList(deployments));
            return this;
        }

        public final void setDeployments(Collection<Deployment> deployments) {
            this.deployments = DeploymentsCopier.copy(deployments);
        }

        @Override
        public DescribeDeploymentsResponse build() {
            return new DescribeDeploymentsResponse(this);
        }
    }
}
