/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeApps</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAppsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeAppsResponse.Builder, DescribeAppsResponse> {
    private final List<App> apps;

    private DescribeAppsResponse(BuilderImpl builder) {
        this.apps = builder.apps;
    }

    /**
     * <p>
     * An array of <code>App</code> objects that describe the specified apps.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>App</code> objects that describe the specified apps.
     */
    public List<App> apps() {
        return apps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((apps() == null) ? 0 : apps().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAppsResponse)) {
            return false;
        }
        DescribeAppsResponse other = (DescribeAppsResponse) obj;
        if (other.apps() == null ^ this.apps() == null) {
            return false;
        }
        if (other.apps() != null && !other.apps().equals(this.apps())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (apps() != null) {
            sb.append("Apps: ").append(apps()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeAppsResponse> {
        /**
         * <p>
         * An array of <code>App</code> objects that describe the specified apps.
         * </p>
         * 
         * @param apps
         *        An array of <code>App</code> objects that describe the specified apps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apps(Collection<App> apps);

        /**
         * <p>
         * An array of <code>App</code> objects that describe the specified apps.
         * </p>
         * 
         * @param apps
         *        An array of <code>App</code> objects that describe the specified apps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apps(App... apps);
    }

    private static final class BuilderImpl implements Builder {
        private List<App> apps;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAppsResponse model) {
            setApps(model.apps);
        }

        public final Collection<App> getApps() {
            return apps;
        }

        @Override
        public final Builder apps(Collection<App> apps) {
            this.apps = AppsCopier.copy(apps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apps(App... apps) {
            apps(Arrays.asList(apps));
            return this;
        }

        public final void setApps(Collection<App> apps) {
            this.apps = AppsCopier.copy(apps);
        }

        @Override
        public DescribeAppsResponse build() {
            return new DescribeAppsResponse(this);
        }
    }
}
