/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DeregisterEcsClusterRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DeregisterEcsClusterRequest.Builder, DeregisterEcsClusterRequest> {
    private final String ecsClusterArn;

    private DeregisterEcsClusterRequest(BuilderImpl builder) {
        this.ecsClusterArn = builder.ecsClusterArn;
    }

    /**
     * <p>
     * The cluster's ARN.
     * </p>
     * 
     * @return The cluster's ARN.
     */
    public String ecsClusterArn() {
        return ecsClusterArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((ecsClusterArn() == null) ? 0 : ecsClusterArn().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeregisterEcsClusterRequest)) {
            return false;
        }
        DeregisterEcsClusterRequest other = (DeregisterEcsClusterRequest) obj;
        if (other.ecsClusterArn() == null ^ this.ecsClusterArn() == null) {
            return false;
        }
        if (other.ecsClusterArn() != null && !other.ecsClusterArn().equals(this.ecsClusterArn())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (ecsClusterArn() != null) {
            sb.append("EcsClusterArn: ").append(ecsClusterArn()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DeregisterEcsClusterRequest> {
        /**
         * <p>
         * The cluster's ARN.
         * </p>
         * 
         * @param ecsClusterArn
         *        The cluster's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsClusterArn(String ecsClusterArn);
    }

    private static final class BuilderImpl implements Builder {
        private String ecsClusterArn;

        private BuilderImpl() {
        }

        private BuilderImpl(DeregisterEcsClusterRequest model) {
            setEcsClusterArn(model.ecsClusterArn);
        }

        public final String getEcsClusterArn() {
            return ecsClusterArn;
        }

        @Override
        public final Builder ecsClusterArn(String ecsClusterArn) {
            this.ecsClusterArn = ecsClusterArn;
            return this;
        }

        public final void setEcsClusterArn(String ecsClusterArn) {
            this.ecsClusterArn = ecsClusterArn;
        }

        @Override
        public DeregisterEcsClusterRequest build() {
            return new DeregisterEcsClusterRequest(this);
        }
    }
}
