/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.transform;

import java.util.List;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.MarshallLocation;
import software.amazon.awssdk.protocol.MarshallingInfo;
import software.amazon.awssdk.protocol.MarshallingType;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.opsworks.model.CloudWatchLogsConfiguration;

@SdkInternalApi
public class CloudWatchLogsConfigurationMarshaller {
    private static final MarshallingInfo<Boolean> ENABLED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Enabled").build();
    private static final MarshallingInfo<List> LOGSTREAMS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LogStreams").build();
    private static final CloudWatchLogsConfigurationMarshaller INSTANCE = new CloudWatchLogsConfigurationMarshaller();

    public static CloudWatchLogsConfigurationMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(CloudWatchLogsConfiguration cloudWatchLogsConfiguration, ProtocolMarshaller protocolMarshaller) {
        if (cloudWatchLogsConfiguration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)cloudWatchLogsConfiguration.enabled(), ENABLED_BINDING);
            protocolMarshaller.marshall(cloudWatchLogsConfiguration.logStreams(), LOGSTREAMS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

