/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.opsworks.model.Architecture;
import software.amazon.awssdk.services.opsworks.model.AutoScalingType;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UpdateInstanceRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, UpdateInstanceRequest> {
    private final String instanceId;
    private final List<String> layerIds;
    private final String instanceType;
    private final String autoScalingType;
    private final String hostname;
    private final String os;
    private final String amiId;
    private final String sshKeyName;
    private final String architecture;
    private final Boolean installUpdatesOnBoot;
    private final Boolean ebsOptimized;
    private final String agentVersion;

    private UpdateInstanceRequest(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.layerIds = builder.layerIds;
        this.instanceType = builder.instanceType;
        this.autoScalingType = builder.autoScalingType;
        this.hostname = builder.hostname;
        this.os = builder.os;
        this.amiId = builder.amiId;
        this.sshKeyName = builder.sshKeyName;
        this.architecture = builder.architecture;
        this.installUpdatesOnBoot = builder.installUpdatesOnBoot;
        this.ebsOptimized = builder.ebsOptimized;
        this.agentVersion = builder.agentVersion;
    }

    public String instanceId() {
        return this.instanceId;
    }

    public List<String> layerIds() {
        return this.layerIds;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public String autoScalingType() {
        return this.autoScalingType;
    }

    public String hostname() {
        return this.hostname;
    }

    public String os() {
        return this.os;
    }

    public String amiId() {
        return this.amiId;
    }

    public String sshKeyName() {
        return this.sshKeyName;
    }

    public String architecture() {
        return this.architecture;
    }

    public Boolean installUpdatesOnBoot() {
        return this.installUpdatesOnBoot;
    }

    public Boolean ebsOptimized() {
        return this.ebsOptimized;
    }

    public String agentVersion() {
        return this.agentVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.instanceId() == null ? 0 : this.instanceId().hashCode());
        hashCode = 31 * hashCode + (this.layerIds() == null ? 0 : this.layerIds().hashCode());
        hashCode = 31 * hashCode + (this.instanceType() == null ? 0 : this.instanceType().hashCode());
        hashCode = 31 * hashCode + (this.autoScalingType() == null ? 0 : this.autoScalingType().hashCode());
        hashCode = 31 * hashCode + (this.hostname() == null ? 0 : this.hostname().hashCode());
        hashCode = 31 * hashCode + (this.os() == null ? 0 : this.os().hashCode());
        hashCode = 31 * hashCode + (this.amiId() == null ? 0 : this.amiId().hashCode());
        hashCode = 31 * hashCode + (this.sshKeyName() == null ? 0 : this.sshKeyName().hashCode());
        hashCode = 31 * hashCode + (this.architecture() == null ? 0 : this.architecture().hashCode());
        hashCode = 31 * hashCode + (this.installUpdatesOnBoot() == null ? 0 : this.installUpdatesOnBoot().hashCode());
        hashCode = 31 * hashCode + (this.ebsOptimized() == null ? 0 : this.ebsOptimized().hashCode());
        hashCode = 31 * hashCode + (this.agentVersion() == null ? 0 : this.agentVersion().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateInstanceRequest)) {
            return false;
        }
        UpdateInstanceRequest other = (UpdateInstanceRequest)((Object)obj);
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.layerIds() == null ^ this.layerIds() == null) {
            return false;
        }
        if (other.layerIds() != null && !other.layerIds().equals(this.layerIds())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.autoScalingType() == null ^ this.autoScalingType() == null) {
            return false;
        }
        if (other.autoScalingType() != null && !other.autoScalingType().equals(this.autoScalingType())) {
            return false;
        }
        if (other.hostname() == null ^ this.hostname() == null) {
            return false;
        }
        if (other.hostname() != null && !other.hostname().equals(this.hostname())) {
            return false;
        }
        if (other.os() == null ^ this.os() == null) {
            return false;
        }
        if (other.os() != null && !other.os().equals(this.os())) {
            return false;
        }
        if (other.amiId() == null ^ this.amiId() == null) {
            return false;
        }
        if (other.amiId() != null && !other.amiId().equals(this.amiId())) {
            return false;
        }
        if (other.sshKeyName() == null ^ this.sshKeyName() == null) {
            return false;
        }
        if (other.sshKeyName() != null && !other.sshKeyName().equals(this.sshKeyName())) {
            return false;
        }
        if (other.architecture() == null ^ this.architecture() == null) {
            return false;
        }
        if (other.architecture() != null && !other.architecture().equals(this.architecture())) {
            return false;
        }
        if (other.installUpdatesOnBoot() == null ^ this.installUpdatesOnBoot() == null) {
            return false;
        }
        if (other.installUpdatesOnBoot() != null && !other.installUpdatesOnBoot().equals(this.installUpdatesOnBoot())) {
            return false;
        }
        if (other.ebsOptimized() == null ^ this.ebsOptimized() == null) {
            return false;
        }
        if (other.ebsOptimized() != null && !other.ebsOptimized().equals(this.ebsOptimized())) {
            return false;
        }
        if (other.agentVersion() == null ^ this.agentVersion() == null) {
            return false;
        }
        return other.agentVersion() == null || other.agentVersion().equals(this.agentVersion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.instanceId() != null) {
            sb.append("InstanceId: ").append(this.instanceId()).append(",");
        }
        if (this.layerIds() != null) {
            sb.append("LayerIds: ").append(this.layerIds()).append(",");
        }
        if (this.instanceType() != null) {
            sb.append("InstanceType: ").append(this.instanceType()).append(",");
        }
        if (this.autoScalingType() != null) {
            sb.append("AutoScalingType: ").append(this.autoScalingType()).append(",");
        }
        if (this.hostname() != null) {
            sb.append("Hostname: ").append(this.hostname()).append(",");
        }
        if (this.os() != null) {
            sb.append("Os: ").append(this.os()).append(",");
        }
        if (this.amiId() != null) {
            sb.append("AmiId: ").append(this.amiId()).append(",");
        }
        if (this.sshKeyName() != null) {
            sb.append("SshKeyName: ").append(this.sshKeyName()).append(",");
        }
        if (this.architecture() != null) {
            sb.append("Architecture: ").append(this.architecture()).append(",");
        }
        if (this.installUpdatesOnBoot() != null) {
            sb.append("InstallUpdatesOnBoot: ").append(this.installUpdatesOnBoot()).append(",");
        }
        if (this.ebsOptimized() != null) {
            sb.append("EbsOptimized: ").append(this.ebsOptimized()).append(",");
        }
        if (this.agentVersion() != null) {
            sb.append("AgentVersion: ").append(this.agentVersion()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String instanceId;
        private List<String> layerIds;
        private String instanceType;
        private String autoScalingType;
        private String hostname;
        private String os;
        private String amiId;
        private String sshKeyName;
        private String architecture;
        private Boolean installUpdatesOnBoot;
        private Boolean ebsOptimized;
        private String agentVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateInstanceRequest model) {
            this.setInstanceId(model.instanceId);
            this.setLayerIds(model.layerIds);
            this.setInstanceType(model.instanceType);
            this.setAutoScalingType(model.autoScalingType);
            this.setHostname(model.hostname);
            this.setOs(model.os);
            this.setAmiId(model.amiId);
            this.setSshKeyName(model.sshKeyName);
            this.setArchitecture(model.architecture);
            this.setInstallUpdatesOnBoot(model.installUpdatesOnBoot);
            this.setEbsOptimized(model.ebsOptimized);
            this.setAgentVersion(model.agentVersion);
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final Collection<String> getLayerIds() {
            return this.layerIds;
        }

        @Override
        public final Builder layerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layerIds(String ... layerIds) {
            this.layerIds(Arrays.asList(layerIds));
            return this;
        }

        public final void setLayerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getAutoScalingType() {
            return this.autoScalingType;
        }

        @Override
        public final Builder autoScalingType(String autoScalingType) {
            this.autoScalingType = autoScalingType;
            return this;
        }

        @Override
        public final Builder autoScalingType(AutoScalingType autoScalingType) {
            this.autoScalingType(autoScalingType.toString());
            return this;
        }

        public final void setAutoScalingType(String autoScalingType) {
            this.autoScalingType = autoScalingType;
        }

        public final String getHostname() {
            return this.hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        public final String getOs() {
            return this.os;
        }

        @Override
        public final Builder os(String os) {
            this.os = os;
            return this;
        }

        public final void setOs(String os) {
            this.os = os;
        }

        public final String getAmiId() {
            return this.amiId;
        }

        @Override
        public final Builder amiId(String amiId) {
            this.amiId = amiId;
            return this;
        }

        public final void setAmiId(String amiId) {
            this.amiId = amiId;
        }

        public final String getSshKeyName() {
            return this.sshKeyName;
        }

        @Override
        public final Builder sshKeyName(String sshKeyName) {
            this.sshKeyName = sshKeyName;
            return this;
        }

        public final void setSshKeyName(String sshKeyName) {
            this.sshKeyName = sshKeyName;
        }

        public final String getArchitecture() {
            return this.architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(Architecture architecture) {
            this.architecture(architecture.toString());
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final Boolean getInstallUpdatesOnBoot() {
            return this.installUpdatesOnBoot;
        }

        @Override
        public final Builder installUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
            return this;
        }

        public final void setInstallUpdatesOnBoot(Boolean installUpdatesOnBoot) {
            this.installUpdatesOnBoot = installUpdatesOnBoot;
        }

        public final Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final String getAgentVersion() {
            return this.agentVersion;
        }

        @Override
        public final Builder agentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
            return this;
        }

        public final void setAgentVersion(String agentVersion) {
            this.agentVersion = agentVersion;
        }

        public UpdateInstanceRequest build() {
            return new UpdateInstanceRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, UpdateInstanceRequest> {
        public Builder instanceId(String var1);

        public Builder layerIds(Collection<String> var1);

        public Builder layerIds(String ... var1);

        public Builder instanceType(String var1);

        public Builder autoScalingType(String var1);

        public Builder autoScalingType(AutoScalingType var1);

        public Builder hostname(String var1);

        public Builder os(String var1);

        public Builder amiId(String var1);

        public Builder sshKeyName(String var1);

        public Builder architecture(String var1);

        public Builder architecture(Architecture var1);

        public Builder installUpdatesOnBoot(Boolean var1);

        public Builder ebsOptimized(Boolean var1);

        public Builder agentVersion(String var1);
    }
}

