/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.opsworks.model.Deployment;
import software.amazon.awssdk.services.opsworks.model.DeploymentsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDeploymentsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeDeploymentsResponse> {
    private final List<Deployment> deployments;

    private DescribeDeploymentsResponse(BuilderImpl builder) {
        this.deployments = builder.deployments;
    }

    public List<Deployment> deployments() {
        return this.deployments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.deployments() == null ? 0 : this.deployments().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDeploymentsResponse)) {
            return false;
        }
        DescribeDeploymentsResponse other = (DescribeDeploymentsResponse)((Object)obj);
        if (other.deployments() == null ^ this.deployments() == null) {
            return false;
        }
        return other.deployments() == null || other.deployments().equals(this.deployments());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.deployments() != null) {
            sb.append("Deployments: ").append(this.deployments()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<Deployment> deployments;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDeploymentsResponse model) {
            this.setDeployments(model.deployments);
        }

        public final Collection<Deployment> getDeployments() {
            return this.deployments;
        }

        @Override
        public final Builder deployments(Collection<Deployment> deployments) {
            this.deployments = DeploymentsCopier.copy(deployments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder deployments(Deployment ... deployments) {
            this.deployments(Arrays.asList(deployments));
            return this;
        }

        public final void setDeployments(Collection<Deployment> deployments) {
            this.deployments = DeploymentsCopier.copy(deployments);
        }

        public DescribeDeploymentsResponse build() {
            return new DescribeDeploymentsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeDeploymentsResponse> {
        public Builder deployments(Collection<Deployment> var1);

        public Builder deployments(Deployment ... var1);
    }
}

