/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.services.opsworks.model.AppAttributesCopier;
import software.amazon.awssdk.services.opsworks.model.AppType;
import software.amazon.awssdk.services.opsworks.model.DataSource;
import software.amazon.awssdk.services.opsworks.model.DataSourcesCopier;
import software.amazon.awssdk.services.opsworks.model.EnvironmentVariable;
import software.amazon.awssdk.services.opsworks.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.services.opsworks.model.Source;
import software.amazon.awssdk.services.opsworks.model.SslConfiguration;
import software.amazon.awssdk.services.opsworks.model.StringsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateAppRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CreateAppRequest> {
    private final String stackId;
    private final String shortname;
    private final String name;
    private final String description;
    private final List<DataSource> dataSources;
    private final String type;
    private final Source appSource;
    private final List<String> domains;
    private final Boolean enableSsl;
    private final SslConfiguration sslConfiguration;
    private final Map<String, String> attributes;
    private final List<EnvironmentVariable> environment;

    private CreateAppRequest(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.shortname = builder.shortname;
        this.name = builder.name;
        this.description = builder.description;
        this.dataSources = builder.dataSources;
        this.type = builder.type;
        this.appSource = builder.appSource;
        this.domains = builder.domains;
        this.enableSsl = builder.enableSsl;
        this.sslConfiguration = builder.sslConfiguration;
        this.attributes = builder.attributes;
        this.environment = builder.environment;
    }

    public String stackId() {
        return this.stackId;
    }

    public String shortname() {
        return this.shortname;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public List<DataSource> dataSources() {
        return this.dataSources;
    }

    public String type() {
        return this.type;
    }

    public Source appSource() {
        return this.appSource;
    }

    public List<String> domains() {
        return this.domains;
    }

    public Boolean enableSsl() {
        return this.enableSsl;
    }

    public SslConfiguration sslConfiguration() {
        return this.sslConfiguration;
    }

    public Map<String, String> attributes() {
        return this.attributes;
    }

    public List<EnvironmentVariable> environment() {
        return this.environment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stackId() == null ? 0 : this.stackId().hashCode());
        hashCode = 31 * hashCode + (this.shortname() == null ? 0 : this.shortname().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.description() == null ? 0 : this.description().hashCode());
        hashCode = 31 * hashCode + (this.dataSources() == null ? 0 : this.dataSources().hashCode());
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.appSource() == null ? 0 : this.appSource().hashCode());
        hashCode = 31 * hashCode + (this.domains() == null ? 0 : this.domains().hashCode());
        hashCode = 31 * hashCode + (this.enableSsl() == null ? 0 : this.enableSsl().hashCode());
        hashCode = 31 * hashCode + (this.sslConfiguration() == null ? 0 : this.sslConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.attributes() == null ? 0 : this.attributes().hashCode());
        hashCode = 31 * hashCode + (this.environment() == null ? 0 : this.environment().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAppRequest)) {
            return false;
        }
        CreateAppRequest other = (CreateAppRequest)((Object)obj);
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.shortname() == null ^ this.shortname() == null) {
            return false;
        }
        if (other.shortname() != null && !other.shortname().equals(this.shortname())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.dataSources() == null ^ this.dataSources() == null) {
            return false;
        }
        if (other.dataSources() != null && !other.dataSources().equals(this.dataSources())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.appSource() == null ^ this.appSource() == null) {
            return false;
        }
        if (other.appSource() != null && !other.appSource().equals(this.appSource())) {
            return false;
        }
        if (other.domains() == null ^ this.domains() == null) {
            return false;
        }
        if (other.domains() != null && !other.domains().equals(this.domains())) {
            return false;
        }
        if (other.enableSsl() == null ^ this.enableSsl() == null) {
            return false;
        }
        if (other.enableSsl() != null && !other.enableSsl().equals(this.enableSsl())) {
            return false;
        }
        if (other.sslConfiguration() == null ^ this.sslConfiguration() == null) {
            return false;
        }
        if (other.sslConfiguration() != null && !other.sslConfiguration().equals(this.sslConfiguration())) {
            return false;
        }
        if (other.attributes() == null ^ this.attributes() == null) {
            return false;
        }
        if (other.attributes() != null && !other.attributes().equals(this.attributes())) {
            return false;
        }
        if (other.environment() == null ^ this.environment() == null) {
            return false;
        }
        return other.environment() == null || other.environment().equals(this.environment());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.stackId() != null) {
            sb.append("StackId: ").append(this.stackId()).append(",");
        }
        if (this.shortname() != null) {
            sb.append("Shortname: ").append(this.shortname()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.dataSources() != null) {
            sb.append("DataSources: ").append(this.dataSources()).append(",");
        }
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.appSource() != null) {
            sb.append("AppSource: ").append(this.appSource()).append(",");
        }
        if (this.domains() != null) {
            sb.append("Domains: ").append(this.domains()).append(",");
        }
        if (this.enableSsl() != null) {
            sb.append("EnableSsl: ").append(this.enableSsl()).append(",");
        }
        if (this.sslConfiguration() != null) {
            sb.append("SslConfiguration: ").append(this.sslConfiguration()).append(",");
        }
        if (this.attributes() != null) {
            sb.append("Attributes: ").append(this.attributes()).append(",");
        }
        if (this.environment() != null) {
            sb.append("Environment: ").append(this.environment()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String stackId;
        private String shortname;
        private String name;
        private String description;
        private List<DataSource> dataSources;
        private String type;
        private Source appSource;
        private List<String> domains;
        private Boolean enableSsl;
        private SslConfiguration sslConfiguration;
        private Map<String, String> attributes;
        private List<EnvironmentVariable> environment;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAppRequest model) {
            this.setStackId(model.stackId);
            this.setShortname(model.shortname);
            this.setName(model.name);
            this.setDescription(model.description);
            this.setDataSources(model.dataSources);
            this.setType(model.type);
            this.setAppSource(model.appSource);
            this.setDomains(model.domains);
            this.setEnableSsl(model.enableSsl);
            this.setSslConfiguration(model.sslConfiguration);
            this.setAttributes(model.attributes);
            this.setEnvironment(model.environment);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getShortname() {
            return this.shortname;
        }

        @Override
        public final Builder shortname(String shortname) {
            this.shortname = shortname;
            return this;
        }

        public final void setShortname(String shortname) {
            this.shortname = shortname;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<DataSource> getDataSources() {
            return this.dataSources;
        }

        @Override
        public final Builder dataSources(Collection<DataSource> dataSources) {
            this.dataSources = DataSourcesCopier.copy(dataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(DataSource ... dataSources) {
            this.dataSources(Arrays.asList(dataSources));
            return this;
        }

        public final void setDataSources(Collection<DataSource> dataSources) {
            this.dataSources = DataSourcesCopier.copy(dataSources);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(AppType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final Source getAppSource() {
            return this.appSource;
        }

        @Override
        public final Builder appSource(Source appSource) {
            this.appSource = appSource;
            return this;
        }

        public final void setAppSource(Source appSource) {
            this.appSource = appSource;
        }

        public final Collection<String> getDomains() {
            return this.domains;
        }

        @Override
        public final Builder domains(Collection<String> domains) {
            this.domains = StringsCopier.copy(domains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domains(String ... domains) {
            this.domains(Arrays.asList(domains));
            return this;
        }

        public final void setDomains(Collection<String> domains) {
            this.domains = StringsCopier.copy(domains);
        }

        public final Boolean getEnableSsl() {
            return this.enableSsl;
        }

        @Override
        public final Builder enableSsl(Boolean enableSsl) {
            this.enableSsl = enableSsl;
            return this;
        }

        public final void setEnableSsl(Boolean enableSsl) {
            this.enableSsl = enableSsl;
        }

        public final SslConfiguration getSslConfiguration() {
            return this.sslConfiguration;
        }

        @Override
        public final Builder sslConfiguration(SslConfiguration sslConfiguration) {
            this.sslConfiguration = sslConfiguration;
            return this;
        }

        public final void setSslConfiguration(SslConfiguration sslConfiguration) {
            this.sslConfiguration = sslConfiguration;
        }

        public final Map<String, String> getAttributes() {
            return this.attributes;
        }

        @Override
        public final Builder attributes(Map<String, String> attributes) {
            this.attributes = AppAttributesCopier.copy(attributes);
            return this;
        }

        public final void setAttributes(Map<String, String> attributes) {
            this.attributes = AppAttributesCopier.copy(attributes);
        }

        public final Collection<EnvironmentVariable> getEnvironment() {
            return this.environment;
        }

        @Override
        public final Builder environment(Collection<EnvironmentVariable> environment) {
            this.environment = EnvironmentVariablesCopier.copy(environment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(EnvironmentVariable ... environment) {
            this.environment(Arrays.asList(environment));
            return this;
        }

        public final void setEnvironment(Collection<EnvironmentVariable> environment) {
            this.environment = EnvironmentVariablesCopier.copy(environment);
        }

        public CreateAppRequest build() {
            return new CreateAppRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CreateAppRequest> {
        public Builder stackId(String var1);

        public Builder shortname(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder dataSources(Collection<DataSource> var1);

        public Builder dataSources(DataSource ... var1);

        public Builder type(String var1);

        public Builder type(AppType var1);

        public Builder appSource(Source var1);

        public Builder domains(Collection<String> var1);

        public Builder domains(String ... var1);

        public Builder enableSsl(Boolean var1);

        public Builder sslConfiguration(SslConfiguration var1);

        public Builder attributes(Map<String, String> var1);

        public Builder environment(Collection<EnvironmentVariable> var1);

        public Builder environment(EnvironmentVariable ... var1);
    }
}

