/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.ChefConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ChefConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, ChefConfiguration> {
    private final Boolean manageBerkshelf;
    private final String berkshelfVersion;

    private ChefConfiguration(BuilderImpl builder) {
        this.manageBerkshelf = builder.manageBerkshelf;
        this.berkshelfVersion = builder.berkshelfVersion;
    }

    public Boolean manageBerkshelf() {
        return this.manageBerkshelf;
    }

    public String berkshelfVersion() {
        return this.berkshelfVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.manageBerkshelf() == null ? 0 : this.manageBerkshelf().hashCode());
        hashCode = 31 * hashCode + (this.berkshelfVersion() == null ? 0 : this.berkshelfVersion().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChefConfiguration)) {
            return false;
        }
        ChefConfiguration other = (ChefConfiguration)obj;
        if (other.manageBerkshelf() == null ^ this.manageBerkshelf() == null) {
            return false;
        }
        if (other.manageBerkshelf() != null && !other.manageBerkshelf().equals(this.manageBerkshelf())) {
            return false;
        }
        if (other.berkshelfVersion() == null ^ this.berkshelfVersion() == null) {
            return false;
        }
        return other.berkshelfVersion() == null || other.berkshelfVersion().equals(this.berkshelfVersion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.manageBerkshelf() != null) {
            sb.append("ManageBerkshelf: ").append(this.manageBerkshelf()).append(",");
        }
        if (this.berkshelfVersion() != null) {
            sb.append("BerkshelfVersion: ").append(this.berkshelfVersion()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ChefConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Boolean manageBerkshelf;
        private String berkshelfVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ChefConfiguration model) {
            this.setManageBerkshelf(model.manageBerkshelf);
            this.setBerkshelfVersion(model.berkshelfVersion);
        }

        public final Boolean getManageBerkshelf() {
            return this.manageBerkshelf;
        }

        @Override
        public final Builder manageBerkshelf(Boolean manageBerkshelf) {
            this.manageBerkshelf = manageBerkshelf;
            return this;
        }

        public final void setManageBerkshelf(Boolean manageBerkshelf) {
            this.manageBerkshelf = manageBerkshelf;
        }

        public final String getBerkshelfVersion() {
            return this.berkshelfVersion;
        }

        @Override
        public final Builder berkshelfVersion(String berkshelfVersion) {
            this.berkshelfVersion = berkshelfVersion;
            return this;
        }

        public final void setBerkshelfVersion(String berkshelfVersion) {
            this.berkshelfVersion = berkshelfVersion;
        }

        public ChefConfiguration build() {
            return new ChefConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ChefConfiguration> {
        public Builder manageBerkshelf(Boolean var1);

        public Builder berkshelfVersion(String var1);
    }
}

