/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.transform;

import java.math.*;

import javax.annotation.Generated;

import software.amazon.awssdk.services.opsworks.model.*;
import software.amazon.awssdk.runtime.transform.SimpleTypeJsonUnmarshallers.*;
import software.amazon.awssdk.runtime.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * CloudWatchLogsLogStream JSON Unmarshaller
 */
@Generated("software.amazon.awssdk:aws-java-sdk-code-generator")
public class CloudWatchLogsLogStreamUnmarshaller implements Unmarshaller<CloudWatchLogsLogStream, JsonUnmarshallerContext> {

    public CloudWatchLogsLogStream unmarshall(JsonUnmarshallerContext context) throws Exception {
        CloudWatchLogsLogStream.Builder cloudWatchLogsLogStreamBuilder = CloudWatchLogsLogStream.builder();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        while (true) {
            if (token == null)
                break;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("LogGroupName", targetDepth)) {
                    context.nextToken();
                    cloudWatchLogsLogStreamBuilder.logGroupName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("DatetimeFormat", targetDepth)) {
                    context.nextToken();
                    cloudWatchLogsLogStreamBuilder.datetimeFormat(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("TimeZone", targetDepth)) {
                    context.nextToken();
                    cloudWatchLogsLogStreamBuilder.timeZone(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("File", targetDepth)) {
                    context.nextToken();
                    cloudWatchLogsLogStreamBuilder.file(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("FileFingerprintLines", targetDepth)) {
                    context.nextToken();
                    cloudWatchLogsLogStreamBuilder
                            .fileFingerprintLines(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("MultiLineStartPattern", targetDepth)) {
                    context.nextToken();
                    cloudWatchLogsLogStreamBuilder.multiLineStartPattern(context.getUnmarshaller(String.class)
                            .unmarshall(context));
                }
                if (context.testExpression("InitialPosition", targetDepth)) {
                    context.nextToken();
                    cloudWatchLogsLogStreamBuilder.initialPosition(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("Encoding", targetDepth)) {
                    context.nextToken();
                    cloudWatchLogsLogStreamBuilder.encoding(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("BufferDuration", targetDepth)) {
                    context.nextToken();
                    cloudWatchLogsLogStreamBuilder.bufferDuration(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("BatchCount", targetDepth)) {
                    context.nextToken();
                    cloudWatchLogsLogStreamBuilder.batchCount(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
                if (context.testExpression("BatchSize", targetDepth)) {
                    context.nextToken();
                    cloudWatchLogsLogStreamBuilder.batchSize(context.getUnmarshaller(Integer.class).unmarshall(context));
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null
                        || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return cloudWatchLogsLogStreamBuilder.build();
    }

    private static final CloudWatchLogsLogStreamUnmarshaller INSTANCE = new CloudWatchLogsLogStreamUnmarshaller();

    public static CloudWatchLogsLogStreamUnmarshaller getInstance() {
        return INSTANCE;
    }
}
