/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.ElasticLoadBalancerMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Elastic Load Balancing instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ElasticLoadBalancer implements StructuredPojo, ToCopyableBuilder<ElasticLoadBalancer.Builder, ElasticLoadBalancer> {
    private final String elasticLoadBalancerName;

    private final String region;

    private final String dnsName;

    private final String stackId;

    private final String layerId;

    private final String vpcId;

    private final List<String> availabilityZones;

    private final List<String> subnetIds;

    private final List<String> ec2InstanceIds;

    private ElasticLoadBalancer(BuilderImpl builder) {
        this.elasticLoadBalancerName = builder.elasticLoadBalancerName;
        this.region = builder.region;
        this.dnsName = builder.dnsName;
        this.stackId = builder.stackId;
        this.layerId = builder.layerId;
        this.vpcId = builder.vpcId;
        this.availabilityZones = builder.availabilityZones;
        this.subnetIds = builder.subnetIds;
        this.ec2InstanceIds = builder.ec2InstanceIds;
    }

    /**
     * <p>
     * The Elastic Load Balancing instance's name.
     * </p>
     * 
     * @return The Elastic Load Balancing instance's name.
     */
    public String elasticLoadBalancerName() {
        return elasticLoadBalancerName;
    }

    /**
     * <p>
     * The instance's AWS region.
     * </p>
     * 
     * @return The instance's AWS region.
     */
    public String region() {
        return region;
    }

    /**
     * <p>
     * The instance's public DNS name.
     * </p>
     * 
     * @return The instance's public DNS name.
     */
    public String dnsName() {
        return dnsName;
    }

    /**
     * <p>
     * The ID of the stack that the instance is associated with.
     * </p>
     * 
     * @return The ID of the stack that the instance is associated with.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The ID of the layer that the instance is attached to.
     * </p>
     * 
     * @return The ID of the layer that the instance is attached to.
     */
    public String layerId() {
        return layerId;
    }

    /**
     * <p>
     * The VPC ID.
     * </p>
     * 
     * @return The VPC ID.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * <p>
     * A list of Availability Zones.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of Availability Zones.
     */
    public List<String> availabilityZones() {
        return availabilityZones;
    }

    /**
     * <p>
     * A list of subnet IDs, if the stack is running in a VPC.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of subnet IDs, if the stack is running in a VPC.
     */
    public List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * <p>
     * A list of the EC2 instances that the Elastic Load Balancing instance is managing traffic for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of the EC2 instances that the Elastic Load Balancing instance is managing traffic for.
     */
    public List<String> ec2InstanceIds() {
        return ec2InstanceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((elasticLoadBalancerName() == null) ? 0 : elasticLoadBalancerName().hashCode());
        hashCode = 31 * hashCode + ((region() == null) ? 0 : region().hashCode());
        hashCode = 31 * hashCode + ((dnsName() == null) ? 0 : dnsName().hashCode());
        hashCode = 31 * hashCode + ((stackId() == null) ? 0 : stackId().hashCode());
        hashCode = 31 * hashCode + ((layerId() == null) ? 0 : layerId().hashCode());
        hashCode = 31 * hashCode + ((vpcId() == null) ? 0 : vpcId().hashCode());
        hashCode = 31 * hashCode + ((availabilityZones() == null) ? 0 : availabilityZones().hashCode());
        hashCode = 31 * hashCode + ((subnetIds() == null) ? 0 : subnetIds().hashCode());
        hashCode = 31 * hashCode + ((ec2InstanceIds() == null) ? 0 : ec2InstanceIds().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ElasticLoadBalancer)) {
            return false;
        }
        ElasticLoadBalancer other = (ElasticLoadBalancer) obj;
        if (other.elasticLoadBalancerName() == null ^ this.elasticLoadBalancerName() == null) {
            return false;
        }
        if (other.elasticLoadBalancerName() != null && !other.elasticLoadBalancerName().equals(this.elasticLoadBalancerName())) {
            return false;
        }
        if (other.region() == null ^ this.region() == null) {
            return false;
        }
        if (other.region() != null && !other.region().equals(this.region())) {
            return false;
        }
        if (other.dnsName() == null ^ this.dnsName() == null) {
            return false;
        }
        if (other.dnsName() != null && !other.dnsName().equals(this.dnsName())) {
            return false;
        }
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.layerId() == null ^ this.layerId() == null) {
            return false;
        }
        if (other.layerId() != null && !other.layerId().equals(this.layerId())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        if (other.availabilityZones() == null ^ this.availabilityZones() == null) {
            return false;
        }
        if (other.availabilityZones() != null && !other.availabilityZones().equals(this.availabilityZones())) {
            return false;
        }
        if (other.subnetIds() == null ^ this.subnetIds() == null) {
            return false;
        }
        if (other.subnetIds() != null && !other.subnetIds().equals(this.subnetIds())) {
            return false;
        }
        if (other.ec2InstanceIds() == null ^ this.ec2InstanceIds() == null) {
            return false;
        }
        if (other.ec2InstanceIds() != null && !other.ec2InstanceIds().equals(this.ec2InstanceIds())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (elasticLoadBalancerName() != null) {
            sb.append("ElasticLoadBalancerName: ").append(elasticLoadBalancerName()).append(",");
        }
        if (region() != null) {
            sb.append("Region: ").append(region()).append(",");
        }
        if (dnsName() != null) {
            sb.append("DnsName: ").append(dnsName()).append(",");
        }
        if (stackId() != null) {
            sb.append("StackId: ").append(stackId()).append(",");
        }
        if (layerId() != null) {
            sb.append("LayerId: ").append(layerId()).append(",");
        }
        if (vpcId() != null) {
            sb.append("VpcId: ").append(vpcId()).append(",");
        }
        if (availabilityZones() != null) {
            sb.append("AvailabilityZones: ").append(availabilityZones()).append(",");
        }
        if (subnetIds() != null) {
            sb.append("SubnetIds: ").append(subnetIds()).append(",");
        }
        if (ec2InstanceIds() != null) {
            sb.append("Ec2InstanceIds: ").append(ec2InstanceIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ElasticLoadBalancerMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, ElasticLoadBalancer> {
        /**
         * <p>
         * The Elastic Load Balancing instance's name.
         * </p>
         * 
         * @param elasticLoadBalancerName
         *        The Elastic Load Balancing instance's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elasticLoadBalancerName(String elasticLoadBalancerName);

        /**
         * <p>
         * The instance's AWS region.
         * </p>
         * 
         * @param region
         *        The instance's AWS region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The instance's public DNS name.
         * </p>
         * 
         * @param dnsName
         *        The instance's public DNS name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dnsName(String dnsName);

        /**
         * <p>
         * The ID of the stack that the instance is associated with.
         * </p>
         * 
         * @param stackId
         *        The ID of the stack that the instance is associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The ID of the layer that the instance is attached to.
         * </p>
         * 
         * @param layerId
         *        The ID of the layer that the instance is attached to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerId(String layerId);

        /**
         * <p>
         * The VPC ID.
         * </p>
         * 
         * @param vpcId
         *        The VPC ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * A list of Availability Zones.
         * </p>
         * 
         * @param availabilityZones
         *        A list of Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(Collection<String> availabilityZones);

        /**
         * <p>
         * A list of Availability Zones.
         * </p>
         * 
         * @param availabilityZones
         *        A list of Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZones(String... availabilityZones);

        /**
         * <p>
         * A list of subnet IDs, if the stack is running in a VPC.
         * </p>
         * 
         * @param subnetIds
         *        A list of subnet IDs, if the stack is running in a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * A list of subnet IDs, if the stack is running in a VPC.
         * </p>
         * 
         * @param subnetIds
         *        A list of subnet IDs, if the stack is running in a VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * A list of the EC2 instances that the Elastic Load Balancing instance is managing traffic for.
         * </p>
         * 
         * @param ec2InstanceIds
         *        A list of the EC2 instances that the Elastic Load Balancing instance is managing traffic for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceIds(Collection<String> ec2InstanceIds);

        /**
         * <p>
         * A list of the EC2 instances that the Elastic Load Balancing instance is managing traffic for.
         * </p>
         * 
         * @param ec2InstanceIds
         *        A list of the EC2 instances that the Elastic Load Balancing instance is managing traffic for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceIds(String... ec2InstanceIds);
    }

    private static final class BuilderImpl implements Builder {
        private String elasticLoadBalancerName;

        private String region;

        private String dnsName;

        private String stackId;

        private String layerId;

        private String vpcId;

        private List<String> availabilityZones;

        private List<String> subnetIds;

        private List<String> ec2InstanceIds;

        private BuilderImpl() {
        }

        private BuilderImpl(ElasticLoadBalancer model) {
            setElasticLoadBalancerName(model.elasticLoadBalancerName);
            setRegion(model.region);
            setDnsName(model.dnsName);
            setStackId(model.stackId);
            setLayerId(model.layerId);
            setVpcId(model.vpcId);
            setAvailabilityZones(model.availabilityZones);
            setSubnetIds(model.subnetIds);
            setEc2InstanceIds(model.ec2InstanceIds);
        }

        public final String getElasticLoadBalancerName() {
            return elasticLoadBalancerName;
        }

        @Override
        public final Builder elasticLoadBalancerName(String elasticLoadBalancerName) {
            this.elasticLoadBalancerName = elasticLoadBalancerName;
            return this;
        }

        public final void setElasticLoadBalancerName(String elasticLoadBalancerName) {
            this.elasticLoadBalancerName = elasticLoadBalancerName;
        }

        public final String getRegion() {
            return region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getDnsName() {
            return dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getLayerId() {
            return layerId;
        }

        @Override
        public final Builder layerId(String layerId) {
            this.layerId = layerId;
            return this;
        }

        public final void setLayerId(String layerId) {
            this.layerId = layerId;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Collection<String> getAvailabilityZones() {
            return availabilityZones;
        }

        @Override
        public final Builder availabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = StringsCopier.copy(availabilityZones);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availabilityZones(String... availabilityZones) {
            availabilityZones(Arrays.asList(availabilityZones));
            return this;
        }

        public final void setAvailabilityZones(Collection<String> availabilityZones) {
            this.availabilityZones = StringsCopier.copy(availabilityZones);
        }

        public final Collection<String> getSubnetIds() {
            return subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringsCopier.copy(subnetIds);
        }

        public final Collection<String> getEc2InstanceIds() {
            return ec2InstanceIds;
        }

        @Override
        public final Builder ec2InstanceIds(Collection<String> ec2InstanceIds) {
            this.ec2InstanceIds = StringsCopier.copy(ec2InstanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ec2InstanceIds(String... ec2InstanceIds) {
            ec2InstanceIds(Arrays.asList(ec2InstanceIds));
            return this;
        }

        public final void setEc2InstanceIds(Collection<String> ec2InstanceIds) {
            this.ec2InstanceIds = StringsCopier.copy(ec2InstanceIds);
        }

        @Override
        public ElasticLoadBalancer build() {
            return new ElasticLoadBalancer(this);
        }
    }
}
