/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.VolumeConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class VolumeConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, VolumeConfiguration> {
    private final String mountPoint;
    private final Integer raidLevel;
    private final Integer numberOfDisks;
    private final Integer size;
    private final String volumeType;
    private final Integer iops;

    private VolumeConfiguration(BuilderImpl builder) {
        this.mountPoint = builder.mountPoint;
        this.raidLevel = builder.raidLevel;
        this.numberOfDisks = builder.numberOfDisks;
        this.size = builder.size;
        this.volumeType = builder.volumeType;
        this.iops = builder.iops;
    }

    public String mountPoint() {
        return this.mountPoint;
    }

    public Integer raidLevel() {
        return this.raidLevel;
    }

    public Integer numberOfDisks() {
        return this.numberOfDisks;
    }

    public Integer size() {
        return this.size;
    }

    public String volumeType() {
        return this.volumeType;
    }

    public Integer iops() {
        return this.iops;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.mountPoint() == null ? 0 : this.mountPoint().hashCode());
        hashCode = 31 * hashCode + (this.raidLevel() == null ? 0 : this.raidLevel().hashCode());
        hashCode = 31 * hashCode + (this.numberOfDisks() == null ? 0 : this.numberOfDisks().hashCode());
        hashCode = 31 * hashCode + (this.size() == null ? 0 : this.size().hashCode());
        hashCode = 31 * hashCode + (this.volumeType() == null ? 0 : this.volumeType().hashCode());
        hashCode = 31 * hashCode + (this.iops() == null ? 0 : this.iops().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VolumeConfiguration)) {
            return false;
        }
        VolumeConfiguration other = (VolumeConfiguration)obj;
        if (other.mountPoint() == null ^ this.mountPoint() == null) {
            return false;
        }
        if (other.mountPoint() != null && !other.mountPoint().equals(this.mountPoint())) {
            return false;
        }
        if (other.raidLevel() == null ^ this.raidLevel() == null) {
            return false;
        }
        if (other.raidLevel() != null && !other.raidLevel().equals(this.raidLevel())) {
            return false;
        }
        if (other.numberOfDisks() == null ^ this.numberOfDisks() == null) {
            return false;
        }
        if (other.numberOfDisks() != null && !other.numberOfDisks().equals(this.numberOfDisks())) {
            return false;
        }
        if (other.size() == null ^ this.size() == null) {
            return false;
        }
        if (other.size() != null && !other.size().equals(this.size())) {
            return false;
        }
        if (other.volumeType() == null ^ this.volumeType() == null) {
            return false;
        }
        if (other.volumeType() != null && !other.volumeType().equals(this.volumeType())) {
            return false;
        }
        if (other.iops() == null ^ this.iops() == null) {
            return false;
        }
        return other.iops() == null || other.iops().equals(this.iops());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.mountPoint() != null) {
            sb.append("MountPoint: ").append(this.mountPoint()).append(",");
        }
        if (this.raidLevel() != null) {
            sb.append("RaidLevel: ").append(this.raidLevel()).append(",");
        }
        if (this.numberOfDisks() != null) {
            sb.append("NumberOfDisks: ").append(this.numberOfDisks()).append(",");
        }
        if (this.size() != null) {
            sb.append("Size: ").append(this.size()).append(",");
        }
        if (this.volumeType() != null) {
            sb.append("VolumeType: ").append(this.volumeType()).append(",");
        }
        if (this.iops() != null) {
            sb.append("Iops: ").append(this.iops()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        VolumeConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String mountPoint;
        private Integer raidLevel;
        private Integer numberOfDisks;
        private Integer size;
        private String volumeType;
        private Integer iops;

        private BuilderImpl() {
        }

        private BuilderImpl(VolumeConfiguration model) {
            this.setMountPoint(model.mountPoint);
            this.setRaidLevel(model.raidLevel);
            this.setNumberOfDisks(model.numberOfDisks);
            this.setSize(model.size);
            this.setVolumeType(model.volumeType);
            this.setIops(model.iops);
        }

        public final String getMountPoint() {
            return this.mountPoint;
        }

        @Override
        public final Builder mountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
            return this;
        }

        public final void setMountPoint(String mountPoint) {
            this.mountPoint = mountPoint;
        }

        public final Integer getRaidLevel() {
            return this.raidLevel;
        }

        @Override
        public final Builder raidLevel(Integer raidLevel) {
            this.raidLevel = raidLevel;
            return this;
        }

        public final void setRaidLevel(Integer raidLevel) {
            this.raidLevel = raidLevel;
        }

        public final Integer getNumberOfDisks() {
            return this.numberOfDisks;
        }

        @Override
        public final Builder numberOfDisks(Integer numberOfDisks) {
            this.numberOfDisks = numberOfDisks;
            return this;
        }

        public final void setNumberOfDisks(Integer numberOfDisks) {
            this.numberOfDisks = numberOfDisks;
        }

        public final Integer getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        public final String getVolumeType() {
            return this.volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        public final Integer getIops() {
            return this.iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public VolumeConfiguration build() {
            return new VolumeConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, VolumeConfiguration> {
        public Builder mountPoint(String var1);

        public Builder raidLevel(Integer var1);

        public Builder numberOfDisks(Integer var1);

        public Builder size(Integer var1);

        public Builder volumeType(String var1);

        public Builder iops(Integer var1);
    }
}

