/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.model.InstancesCount;
import software.amazon.awssdk.services.opsworks.transform.StackSummaryMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StackSummary
implements StructuredPojo,
ToCopyableBuilder<Builder, StackSummary> {
    private final String stackId;
    private final String name;
    private final String arn;
    private final Integer layersCount;
    private final Integer appsCount;
    private final InstancesCount instancesCount;

    private StackSummary(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.name = builder.name;
        this.arn = builder.arn;
        this.layersCount = builder.layersCount;
        this.appsCount = builder.appsCount;
        this.instancesCount = builder.instancesCount;
    }

    public String stackId() {
        return this.stackId;
    }

    public String name() {
        return this.name;
    }

    public String arn() {
        return this.arn;
    }

    public Integer layersCount() {
        return this.layersCount;
    }

    public Integer appsCount() {
        return this.appsCount;
    }

    public InstancesCount instancesCount() {
        return this.instancesCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.stackId() == null ? 0 : this.stackId().hashCode());
        hashCode = 31 * hashCode + (this.name() == null ? 0 : this.name().hashCode());
        hashCode = 31 * hashCode + (this.arn() == null ? 0 : this.arn().hashCode());
        hashCode = 31 * hashCode + (this.layersCount() == null ? 0 : this.layersCount().hashCode());
        hashCode = 31 * hashCode + (this.appsCount() == null ? 0 : this.appsCount().hashCode());
        hashCode = 31 * hashCode + (this.instancesCount() == null ? 0 : this.instancesCount().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StackSummary)) {
            return false;
        }
        StackSummary other = (StackSummary)obj;
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.arn() == null ^ this.arn() == null) {
            return false;
        }
        if (other.arn() != null && !other.arn().equals(this.arn())) {
            return false;
        }
        if (other.layersCount() == null ^ this.layersCount() == null) {
            return false;
        }
        if (other.layersCount() != null && !other.layersCount().equals(this.layersCount())) {
            return false;
        }
        if (other.appsCount() == null ^ this.appsCount() == null) {
            return false;
        }
        if (other.appsCount() != null && !other.appsCount().equals(this.appsCount())) {
            return false;
        }
        if (other.instancesCount() == null ^ this.instancesCount() == null) {
            return false;
        }
        return other.instancesCount() == null || other.instancesCount().equals(this.instancesCount());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.stackId() != null) {
            sb.append("StackId: ").append(this.stackId()).append(",");
        }
        if (this.name() != null) {
            sb.append("Name: ").append(this.name()).append(",");
        }
        if (this.arn() != null) {
            sb.append("Arn: ").append(this.arn()).append(",");
        }
        if (this.layersCount() != null) {
            sb.append("LayersCount: ").append(this.layersCount()).append(",");
        }
        if (this.appsCount() != null) {
            sb.append("AppsCount: ").append(this.appsCount()).append(",");
        }
        if (this.instancesCount() != null) {
            sb.append("InstancesCount: ").append(this.instancesCount()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        StackSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String stackId;
        private String name;
        private String arn;
        private Integer layersCount;
        private Integer appsCount;
        private InstancesCount instancesCount;

        private BuilderImpl() {
        }

        private BuilderImpl(StackSummary model) {
            this.setStackId(model.stackId);
            this.setName(model.name);
            this.setArn(model.arn);
            this.setLayersCount(model.layersCount);
            this.setAppsCount(model.appsCount);
            this.setInstancesCount(model.instancesCount);
        }

        public final String getStackId() {
            return this.stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Integer getLayersCount() {
            return this.layersCount;
        }

        @Override
        public final Builder layersCount(Integer layersCount) {
            this.layersCount = layersCount;
            return this;
        }

        public final void setLayersCount(Integer layersCount) {
            this.layersCount = layersCount;
        }

        public final Integer getAppsCount() {
            return this.appsCount;
        }

        @Override
        public final Builder appsCount(Integer appsCount) {
            this.appsCount = appsCount;
            return this;
        }

        public final void setAppsCount(Integer appsCount) {
            this.appsCount = appsCount;
        }

        public final InstancesCount getInstancesCount() {
            return this.instancesCount;
        }

        @Override
        public final Builder instancesCount(InstancesCount instancesCount) {
            this.instancesCount = instancesCount;
            return this;
        }

        public final void setInstancesCount(InstancesCount instancesCount) {
            this.instancesCount = instancesCount;
        }

        public StackSummary build() {
            return new StackSummary(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StackSummary> {
        public Builder stackId(String var1);

        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder layersCount(Integer var1);

        public Builder appsCount(Integer var1);

        public Builder instancesCount(InstancesCount var1);
    }
}

