/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.SslConfigurationMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SslConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, SslConfiguration> {
    private final String certificate;
    private final String privateKey;
    private final String chain;

    private SslConfiguration(BuilderImpl builder) {
        this.certificate = builder.certificate;
        this.privateKey = builder.privateKey;
        this.chain = builder.chain;
    }

    public String certificate() {
        return this.certificate;
    }

    public String privateKey() {
        return this.privateKey;
    }

    public String chain() {
        return this.chain;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.certificate() == null ? 0 : this.certificate().hashCode());
        hashCode = 31 * hashCode + (this.privateKey() == null ? 0 : this.privateKey().hashCode());
        hashCode = 31 * hashCode + (this.chain() == null ? 0 : this.chain().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SslConfiguration)) {
            return false;
        }
        SslConfiguration other = (SslConfiguration)obj;
        if (other.certificate() == null ^ this.certificate() == null) {
            return false;
        }
        if (other.certificate() != null && !other.certificate().equals(this.certificate())) {
            return false;
        }
        if (other.privateKey() == null ^ this.privateKey() == null) {
            return false;
        }
        if (other.privateKey() != null && !other.privateKey().equals(this.privateKey())) {
            return false;
        }
        if (other.chain() == null ^ this.chain() == null) {
            return false;
        }
        return other.chain() == null || other.chain().equals(this.chain());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.certificate() != null) {
            sb.append("Certificate: ").append(this.certificate()).append(",");
        }
        if (this.privateKey() != null) {
            sb.append("PrivateKey: ").append(this.privateKey()).append(",");
        }
        if (this.chain() != null) {
            sb.append("Chain: ").append(this.chain()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SslConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String certificate;
        private String privateKey;
        private String chain;

        private BuilderImpl() {
        }

        private BuilderImpl(SslConfiguration model) {
            this.setCertificate(model.certificate);
            this.setPrivateKey(model.privateKey);
            this.setChain(model.chain);
        }

        public final String getCertificate() {
            return this.certificate;
        }

        @Override
        public final Builder certificate(String certificate) {
            this.certificate = certificate;
            return this;
        }

        public final void setCertificate(String certificate) {
            this.certificate = certificate;
        }

        public final String getPrivateKey() {
            return this.privateKey;
        }

        @Override
        public final Builder privateKey(String privateKey) {
            this.privateKey = privateKey;
            return this;
        }

        public final void setPrivateKey(String privateKey) {
            this.privateKey = privateKey;
        }

        public final String getChain() {
            return this.chain;
        }

        @Override
        public final Builder chain(String chain) {
            this.chain = chain;
            return this;
        }

        public final void setChain(String chain) {
            this.chain = chain;
        }

        public SslConfiguration build() {
            return new SslConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SslConfiguration> {
        public Builder certificate(String var1);

        public Builder privateKey(String var1);

        public Builder chain(String var1);
    }
}

