/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.opsworks.model.EcsCluster;
import software.amazon.awssdk.services.opsworks.model.EcsClustersCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeEcsClustersResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeEcsClustersResponse> {
    private final List<EcsCluster> ecsClusters;
    private final String nextToken;

    private DescribeEcsClustersResponse(BuilderImpl builder) {
        this.ecsClusters = builder.ecsClusters;
        this.nextToken = builder.nextToken;
    }

    public List<EcsCluster> ecsClusters() {
        return this.ecsClusters;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.ecsClusters() == null ? 0 : this.ecsClusters().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEcsClustersResponse)) {
            return false;
        }
        DescribeEcsClustersResponse other = (DescribeEcsClustersResponse)((Object)obj);
        if (other.ecsClusters() == null ^ this.ecsClusters() == null) {
            return false;
        }
        if (other.ecsClusters() != null && !other.ecsClusters().equals(this.ecsClusters())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ecsClusters() != null) {
            sb.append("EcsClusters: ").append(this.ecsClusters()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<EcsCluster> ecsClusters;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEcsClustersResponse model) {
            this.setEcsClusters(model.ecsClusters);
            this.setNextToken(model.nextToken);
        }

        public final Collection<EcsCluster> getEcsClusters() {
            return this.ecsClusters;
        }

        @Override
        public final Builder ecsClusters(Collection<EcsCluster> ecsClusters) {
            this.ecsClusters = EcsClustersCopier.copy(ecsClusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ecsClusters(EcsCluster ... ecsClusters) {
            this.ecsClusters(Arrays.asList(ecsClusters));
            return this;
        }

        public final void setEcsClusters(Collection<EcsCluster> ecsClusters) {
            this.ecsClusters = EcsClustersCopier.copy(ecsClusters);
        }

        @SafeVarargs
        public final void setEcsClusters(EcsCluster ... ecsClusters) {
            this.ecsClusters(Arrays.asList(ecsClusters));
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public DescribeEcsClustersResponse build() {
            return new DescribeEcsClustersResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeEcsClustersResponse> {
        public Builder ecsClusters(Collection<EcsCluster> var1);

        public Builder ecsClusters(EcsCluster ... var1);

        public Builder nextToken(String var1);
    }
}

