/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.EcsClusterMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a registered Amazon ECS cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class EcsCluster implements StructuredPojo, ToCopyableBuilder<EcsCluster.Builder, EcsCluster> {
    private final String ecsClusterArn;

    private final String ecsClusterName;

    private final String stackId;

    private final String registeredAt;

    private EcsCluster(BuilderImpl builder) {
        this.ecsClusterArn = builder.ecsClusterArn;
        this.ecsClusterName = builder.ecsClusterName;
        this.stackId = builder.stackId;
        this.registeredAt = builder.registeredAt;
    }

    /**
     * <p>
     * The cluster's ARN.
     * </p>
     * 
     * @return The cluster's ARN.
     */
    public String ecsClusterArn() {
        return ecsClusterArn;
    }

    /**
     * <p>
     * The cluster name.
     * </p>
     * 
     * @return The cluster name.
     */
    public String ecsClusterName() {
        return ecsClusterName;
    }

    /**
     * <p>
     * The stack ID.
     * </p>
     * 
     * @return The stack ID.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The time and date that the cluster was registered with the stack.
     * </p>
     * 
     * @return The time and date that the cluster was registered with the stack.
     */
    public String registeredAt() {
        return registeredAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((ecsClusterArn() == null) ? 0 : ecsClusterArn().hashCode());
        hashCode = 31 * hashCode + ((ecsClusterName() == null) ? 0 : ecsClusterName().hashCode());
        hashCode = 31 * hashCode + ((stackId() == null) ? 0 : stackId().hashCode());
        hashCode = 31 * hashCode + ((registeredAt() == null) ? 0 : registeredAt().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcsCluster)) {
            return false;
        }
        EcsCluster other = (EcsCluster) obj;
        if (other.ecsClusterArn() == null ^ this.ecsClusterArn() == null) {
            return false;
        }
        if (other.ecsClusterArn() != null && !other.ecsClusterArn().equals(this.ecsClusterArn())) {
            return false;
        }
        if (other.ecsClusterName() == null ^ this.ecsClusterName() == null) {
            return false;
        }
        if (other.ecsClusterName() != null && !other.ecsClusterName().equals(this.ecsClusterName())) {
            return false;
        }
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.registeredAt() == null ^ this.registeredAt() == null) {
            return false;
        }
        if (other.registeredAt() != null && !other.registeredAt().equals(this.registeredAt())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (ecsClusterArn() != null) {
            sb.append("EcsClusterArn: ").append(ecsClusterArn()).append(",");
        }
        if (ecsClusterName() != null) {
            sb.append("EcsClusterName: ").append(ecsClusterName()).append(",");
        }
        if (stackId() != null) {
            sb.append("StackId: ").append(stackId()).append(",");
        }
        if (registeredAt() != null) {
            sb.append("RegisteredAt: ").append(registeredAt()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EcsClusterMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, EcsCluster> {
        /**
         * <p>
         * The cluster's ARN.
         * </p>
         * 
         * @param ecsClusterArn
         *        The cluster's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsClusterArn(String ecsClusterArn);

        /**
         * <p>
         * The cluster name.
         * </p>
         * 
         * @param ecsClusterName
         *        The cluster name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsClusterName(String ecsClusterName);

        /**
         * <p>
         * The stack ID.
         * </p>
         * 
         * @param stackId
         *        The stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The time and date that the cluster was registered with the stack.
         * </p>
         * 
         * @param registeredAt
         *        The time and date that the cluster was registered with the stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registeredAt(String registeredAt);
    }

    private static final class BuilderImpl implements Builder {
        private String ecsClusterArn;

        private String ecsClusterName;

        private String stackId;

        private String registeredAt;

        private BuilderImpl() {
        }

        private BuilderImpl(EcsCluster model) {
            setEcsClusterArn(model.ecsClusterArn);
            setEcsClusterName(model.ecsClusterName);
            setStackId(model.stackId);
            setRegisteredAt(model.registeredAt);
        }

        public final String getEcsClusterArn() {
            return ecsClusterArn;
        }

        @Override
        public final Builder ecsClusterArn(String ecsClusterArn) {
            this.ecsClusterArn = ecsClusterArn;
            return this;
        }

        public final void setEcsClusterArn(String ecsClusterArn) {
            this.ecsClusterArn = ecsClusterArn;
        }

        public final String getEcsClusterName() {
            return ecsClusterName;
        }

        @Override
        public final Builder ecsClusterName(String ecsClusterName) {
            this.ecsClusterName = ecsClusterName;
            return this;
        }

        public final void setEcsClusterName(String ecsClusterName) {
            this.ecsClusterName = ecsClusterName;
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getRegisteredAt() {
            return registeredAt;
        }

        @Override
        public final Builder registeredAt(String registeredAt) {
            this.registeredAt = registeredAt;
            return this;
        }

        public final void setRegisteredAt(String registeredAt) {
            this.registeredAt = registeredAt;
        }

        @Override
        public EcsCluster build() {
            return new EcsCluster(this);
        }
    }
}
