/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeUserProfiles</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeUserProfilesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeUserProfilesResponse.Builder, DescribeUserProfilesResponse> {
    private final List<UserProfile> userProfiles;

    private DescribeUserProfilesResponse(BuilderImpl builder) {
        this.userProfiles = builder.userProfiles;
    }

    /**
     * <p>
     * A <code>Users</code> object that describes the specified users.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A <code>Users</code> object that describes the specified users.
     */
    public List<UserProfile> userProfiles() {
        return userProfiles;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((userProfiles() == null) ? 0 : userProfiles().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserProfilesResponse)) {
            return false;
        }
        DescribeUserProfilesResponse other = (DescribeUserProfilesResponse) obj;
        if (other.userProfiles() == null ^ this.userProfiles() == null) {
            return false;
        }
        if (other.userProfiles() != null && !other.userProfiles().equals(this.userProfiles())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (userProfiles() != null) {
            sb.append("UserProfiles: ").append(userProfiles()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeUserProfilesResponse> {
        /**
         * <p>
         * A <code>Users</code> object that describes the specified users.
         * </p>
         * 
         * @param userProfiles
         *        A <code>Users</code> object that describes the specified users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProfiles(Collection<UserProfile> userProfiles);

        /**
         * <p>
         * A <code>Users</code> object that describes the specified users.
         * </p>
         * 
         * @param userProfiles
         *        A <code>Users</code> object that describes the specified users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userProfiles(UserProfile... userProfiles);
    }

    private static final class BuilderImpl implements Builder {
        private List<UserProfile> userProfiles;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserProfilesResponse model) {
            setUserProfiles(model.userProfiles);
        }

        public final Collection<UserProfile> getUserProfiles() {
            return userProfiles;
        }

        @Override
        public final Builder userProfiles(Collection<UserProfile> userProfiles) {
            this.userProfiles = UserProfilesCopier.copy(userProfiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userProfiles(UserProfile... userProfiles) {
            userProfiles(Arrays.asList(userProfiles));
            return this;
        }

        public final void setUserProfiles(Collection<UserProfile> userProfiles) {
            this.userProfiles = UserProfilesCopier.copy(userProfiles);
        }

        @SafeVarargs
        public final void setUserProfiles(UserProfile... userProfiles) {
            userProfiles(Arrays.asList(userProfiles));
        }

        @Override
        public DescribeUserProfilesResponse build() {
            return new DescribeUserProfilesResponse(this);
        }
    }
}
