/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeLayersRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeLayersRequest.Builder, DescribeLayersRequest> {
    private final String stackId;

    private final List<String> layerIds;

    private DescribeLayersRequest(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.layerIds = builder.layerIds;
    }

    /**
     * <p>
     * The stack ID.
     * </p>
     * 
     * @return The stack ID.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * An array of layer IDs that specify the layers to be described. If you omit this parameter,
     * <code>DescribeLayers</code> returns a description of every layer in the specified stack.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of layer IDs that specify the layers to be described. If you omit this parameter,
     *         <code>DescribeLayers</code> returns a description of every layer in the specified stack.
     */
    public List<String> layerIds() {
        return layerIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stackId() == null) ? 0 : stackId().hashCode());
        hashCode = 31 * hashCode + ((layerIds() == null) ? 0 : layerIds().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLayersRequest)) {
            return false;
        }
        DescribeLayersRequest other = (DescribeLayersRequest) obj;
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.layerIds() == null ^ this.layerIds() == null) {
            return false;
        }
        if (other.layerIds() != null && !other.layerIds().equals(this.layerIds())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (stackId() != null) {
            sb.append("StackId: ").append(stackId()).append(",");
        }
        if (layerIds() != null) {
            sb.append("LayerIds: ").append(layerIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeLayersRequest> {
        /**
         * <p>
         * The stack ID.
         * </p>
         * 
         * @param stackId
         *        The stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * An array of layer IDs that specify the layers to be described. If you omit this parameter,
         * <code>DescribeLayers</code> returns a description of every layer in the specified stack.
         * </p>
         * 
         * @param layerIds
         *        An array of layer IDs that specify the layers to be described. If you omit this parameter,
         *        <code>DescribeLayers</code> returns a description of every layer in the specified stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerIds(Collection<String> layerIds);

        /**
         * <p>
         * An array of layer IDs that specify the layers to be described. If you omit this parameter,
         * <code>DescribeLayers</code> returns a description of every layer in the specified stack.
         * </p>
         * 
         * @param layerIds
         *        An array of layer IDs that specify the layers to be described. If you omit this parameter,
         *        <code>DescribeLayers</code> returns a description of every layer in the specified stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder layerIds(String... layerIds);
    }

    private static final class BuilderImpl implements Builder {
        private String stackId;

        private List<String> layerIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLayersRequest model) {
            setStackId(model.stackId);
            setLayerIds(model.layerIds);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final Collection<String> getLayerIds() {
            return layerIds;
        }

        @Override
        public final Builder layerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layerIds(String... layerIds) {
            layerIds(Arrays.asList(layerIds));
            return this;
        }

        public final void setLayerIds(Collection<String> layerIds) {
            this.layerIds = StringsCopier.copy(layerIds);
        }

        @SafeVarargs
        public final void setLayerIds(String... layerIds) {
            layerIds(Arrays.asList(layerIds));
        }

        @Override
        public DescribeLayersRequest build() {
            return new DescribeLayersRequest(this);
        }
    }
}
