/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeCommands</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeCommandsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeCommandsResponse.Builder, DescribeCommandsResponse> {
    private final List<Command> commands;

    private DescribeCommandsResponse(BuilderImpl builder) {
        this.commands = builder.commands;
    }

    /**
     * <p>
     * An array of <code>Command</code> objects that describe each of the specified commands.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>Command</code> objects that describe each of the specified commands.
     */
    public List<Command> commands() {
        return commands;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((commands() == null) ? 0 : commands().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCommandsResponse)) {
            return false;
        }
        DescribeCommandsResponse other = (DescribeCommandsResponse) obj;
        if (other.commands() == null ^ this.commands() == null) {
            return false;
        }
        if (other.commands() != null && !other.commands().equals(this.commands())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (commands() != null) {
            sb.append("Commands: ").append(commands()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeCommandsResponse> {
        /**
         * <p>
         * An array of <code>Command</code> objects that describe each of the specified commands.
         * </p>
         * 
         * @param commands
         *        An array of <code>Command</code> objects that describe each of the specified commands.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commands(Collection<Command> commands);

        /**
         * <p>
         * An array of <code>Command</code> objects that describe each of the specified commands.
         * </p>
         * 
         * @param commands
         *        An array of <code>Command</code> objects that describe each of the specified commands.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commands(Command... commands);
    }

    private static final class BuilderImpl implements Builder {
        private List<Command> commands;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCommandsResponse model) {
            setCommands(model.commands);
        }

        public final Collection<Command> getCommands() {
            return commands;
        }

        @Override
        public final Builder commands(Collection<Command> commands) {
            this.commands = CommandsCopier.copy(commands);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder commands(Command... commands) {
            commands(Arrays.asList(commands));
            return this;
        }

        public final void setCommands(Collection<Command> commands) {
            this.commands = CommandsCopier.copy(commands);
        }

        @SafeVarargs
        public final void setCommands(Command... commands) {
            commands(Arrays.asList(commands));
        }

        @Override
        public DescribeCommandsResponse build() {
            return new DescribeCommandsResponse(this);
        }
    }
}
