/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to a <code>DescribeAgentVersions</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAgentVersionsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeAgentVersionsResponse.Builder, DescribeAgentVersionsResponse> {
    private final List<AgentVersion> agentVersions;

    private DescribeAgentVersionsResponse(BuilderImpl builder) {
        this.agentVersions = builder.agentVersions;
    }

    /**
     * <p>
     * The agent versions for the specified stack or configuration manager. Note that this value is the complete version
     * number, not the abbreviated number used by the console.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The agent versions for the specified stack or configuration manager. Note that this value is the complete
     *         version number, not the abbreviated number used by the console.
     */
    public List<AgentVersion> agentVersions() {
        return agentVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((agentVersions() == null) ? 0 : agentVersions().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAgentVersionsResponse)) {
            return false;
        }
        DescribeAgentVersionsResponse other = (DescribeAgentVersionsResponse) obj;
        if (other.agentVersions() == null ^ this.agentVersions() == null) {
            return false;
        }
        if (other.agentVersions() != null && !other.agentVersions().equals(this.agentVersions())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (agentVersions() != null) {
            sb.append("AgentVersions: ").append(agentVersions()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeAgentVersionsResponse> {
        /**
         * <p>
         * The agent versions for the specified stack or configuration manager. Note that this value is the complete
         * version number, not the abbreviated number used by the console.
         * </p>
         * 
         * @param agentVersions
         *        The agent versions for the specified stack or configuration manager. Note that this value is the
         *        complete version number, not the abbreviated number used by the console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersions(Collection<AgentVersion> agentVersions);

        /**
         * <p>
         * The agent versions for the specified stack or configuration manager. Note that this value is the complete
         * version number, not the abbreviated number used by the console.
         * </p>
         * 
         * @param agentVersions
         *        The agent versions for the specified stack or configuration manager. Note that this value is the
         *        complete version number, not the abbreviated number used by the console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentVersions(AgentVersion... agentVersions);
    }

    private static final class BuilderImpl implements Builder {
        private List<AgentVersion> agentVersions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAgentVersionsResponse model) {
            setAgentVersions(model.agentVersions);
        }

        public final Collection<AgentVersion> getAgentVersions() {
            return agentVersions;
        }

        @Override
        public final Builder agentVersions(Collection<AgentVersion> agentVersions) {
            this.agentVersions = AgentVersionsCopier.copy(agentVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agentVersions(AgentVersion... agentVersions) {
            agentVersions(Arrays.asList(agentVersions));
            return this;
        }

        public final void setAgentVersions(Collection<AgentVersion> agentVersions) {
            this.agentVersions = AgentVersionsCopier.copy(agentVersions);
        }

        @SafeVarargs
        public final void setAgentVersions(AgentVersion... agentVersions) {
            agentVersions(Arrays.asList(agentVersions));
        }

        @Override
        public DescribeAgentVersionsResponse build() {
            return new DescribeAgentVersionsResponse(this);
        }
    }
}
