/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAgentVersionsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeAgentVersionsRequest.Builder, DescribeAgentVersionsRequest> {
    private final String stackId;

    private final StackConfigurationManager configurationManager;

    private DescribeAgentVersionsRequest(BuilderImpl builder) {
        this.stackId = builder.stackId;
        this.configurationManager = builder.configurationManager;
    }

    /**
     * <p>
     * The stack ID.
     * </p>
     * 
     * @return The stack ID.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The configuration manager.
     * </p>
     * 
     * @return The configuration manager.
     */
    public StackConfigurationManager configurationManager() {
        return configurationManager;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((stackId() == null) ? 0 : stackId().hashCode());
        hashCode = 31 * hashCode + ((configurationManager() == null) ? 0 : configurationManager().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAgentVersionsRequest)) {
            return false;
        }
        DescribeAgentVersionsRequest other = (DescribeAgentVersionsRequest) obj;
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.configurationManager() == null ^ this.configurationManager() == null) {
            return false;
        }
        if (other.configurationManager() != null && !other.configurationManager().equals(this.configurationManager())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (stackId() != null) {
            sb.append("StackId: ").append(stackId()).append(",");
        }
        if (configurationManager() != null) {
            sb.append("ConfigurationManager: ").append(configurationManager()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeAgentVersionsRequest> {
        /**
         * <p>
         * The stack ID.
         * </p>
         * 
         * @param stackId
         *        The stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The configuration manager.
         * </p>
         * 
         * @param configurationManager
         *        The configuration manager.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configurationManager(StackConfigurationManager configurationManager);
    }

    private static final class BuilderImpl implements Builder {
        private String stackId;

        private StackConfigurationManager configurationManager;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAgentVersionsRequest model) {
            setStackId(model.stackId);
            setConfigurationManager(model.configurationManager);
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final StackConfigurationManager getConfigurationManager() {
            return configurationManager;
        }

        @Override
        public final Builder configurationManager(StackConfigurationManager configurationManager) {
            this.configurationManager = configurationManager;
            return this;
        }

        public final void setConfigurationManager(StackConfigurationManager configurationManager) {
            this.configurationManager = configurationManager;
        }

        @Override
        public DescribeAgentVersionsRequest build() {
            return new DescribeAgentVersionsRequest(this);
        }
    }
}
