/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.DeploymentCommandMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Used to specify a stack or deployment command.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DeploymentCommand implements StructuredPojo, ToCopyableBuilder<DeploymentCommand.Builder, DeploymentCommand> {
    private final String name;

    private final Map<String, List<String>> args;

    private DeploymentCommand(BuilderImpl builder) {
        this.name = builder.name;
        this.args = builder.args;
    }

    /**
     * <p>
     * Specifies the operation. You can specify only one command.
     * </p>
     * <p>
     * For stacks, the following commands are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>execute_recipes</code>: Execute one or more recipes. To specify the recipes, set an <code>Args</code>
     * parameter named <code>recipes</code> to the list of recipes to be executed. For example, to execute
     * <code>phpapp::appsetup</code>, set <code>Args</code> to <code>{"recipes":["phpapp::appsetup"]}</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>install_dependencies</code>: Install the stack's dependencies.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>update_custom_cookbooks</code>: Update the stack's custom cookbooks.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>update_dependencies</code>: Update the stack's dependencies.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * The update_dependencies and install_dependencies commands are supported only for Linux instances. You can run the
     * commands successfully on Windows instances, but they do nothing.
     * </p>
     * </note>
     * <p>
     * For apps, the following commands are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>deploy</code>: Deploy an app. Ruby on Rails apps have an optional <code>Args</code> parameter named
     * <code>migrate</code>. Set <code>Args</code> to {"migrate":["true"]} to migrate the database. The default setting
     * is {"migrate":["false"]}.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>rollback</code> Roll the app back to the previous version. When you update an app, AWS OpsWorks Stacks
     * stores the previous version, up to a maximum of five versions. You can use this command to roll an app back as
     * many as four versions.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>start</code>: Start the app's web or application server.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>stop</code>: Stop the app's web or application server.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>restart</code>: Restart the app's web or application server.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>undeploy</code>: Undeploy the app.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies the operation. You can specify only one command.</p>
     *         <p>
     *         For stacks, the following commands are available:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>execute_recipes</code>: Execute one or more recipes. To specify the recipes, set an
     *         <code>Args</code> parameter named <code>recipes</code> to the list of recipes to be executed. For
     *         example, to execute <code>phpapp::appsetup</code>, set <code>Args</code> to
     *         <code>{"recipes":["phpapp::appsetup"]}</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>install_dependencies</code>: Install the stack's dependencies.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>update_custom_cookbooks</code>: Update the stack's custom cookbooks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>update_dependencies</code>: Update the stack's dependencies.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         The update_dependencies and install_dependencies commands are supported only for Linux instances. You can
     *         run the commands successfully on Windows instances, but they do nothing.
     *         </p>
     *         </note>
     *         <p>
     *         For apps, the following commands are available:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>deploy</code>: Deploy an app. Ruby on Rails apps have an optional <code>Args</code> parameter named
     *         <code>migrate</code>. Set <code>Args</code> to {"migrate":["true"]} to migrate the database. The default
     *         setting is {"migrate":["false"]}.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>rollback</code> Roll the app back to the previous version. When you update an app, AWS OpsWorks
     *         Stacks stores the previous version, up to a maximum of five versions. You can use this command to roll an
     *         app back as many as four versions.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>start</code>: Start the app's web or application server.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>stop</code>: Stop the app's web or application server.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>restart</code>: Restart the app's web or application server.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>undeploy</code>: Undeploy the app.
     *         </p>
     *         </li>
     * @see DeploymentCommandName
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The arguments of those commands that take arguments. It should be set to a JSON object with the following format:
     * </p>
     * <p>
     * <code>{"arg_name1" : ["value1", "value2", ...], "arg_name2" : ["value1", "value2", ...], ...}</code>
     * </p>
     * <p>
     * The <code>update_dependencies</code> command takes two arguments:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>upgrade_os_to</code> - Specifies the desired Amazon Linux version for instances whose OS you want to
     * upgrade, such as <code>Amazon Linux 2016.09</code>. You must also set the <code>allow_reboot</code> argument to
     * true.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>allow_reboot</code> - Specifies whether to allow AWS OpsWorks Stacks to reboot the instances if necessary,
     * after installing the updates. This argument can be set to either <code>true</code> or <code>false</code>. The
     * default value is <code>false</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For example, to upgrade an instance to Amazon Linux 2016.09, set <code>Args</code> to the following.
     * </p>
     * <p>
     * <code> { "upgrade_os_to":["Amazon Linux 2016.09"], "allow_reboot":["true"] } </code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The arguments of those commands that take arguments. It should be set to a JSON object with the following
     *         format:</p>
     *         <p>
     *         <code>{"arg_name1" : ["value1", "value2", ...], "arg_name2" : ["value1", "value2", ...], ...}</code>
     *         </p>
     *         <p>
     *         The <code>update_dependencies</code> command takes two arguments:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>upgrade_os_to</code> - Specifies the desired Amazon Linux version for instances whose OS you want
     *         to upgrade, such as <code>Amazon Linux 2016.09</code>. You must also set the <code>allow_reboot</code>
     *         argument to true.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>allow_reboot</code> - Specifies whether to allow AWS OpsWorks Stacks to reboot the instances if
     *         necessary, after installing the updates. This argument can be set to either <code>true</code> or
     *         <code>false</code>. The default value is <code>false</code>.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For example, to upgrade an instance to Amazon Linux 2016.09, set <code>Args</code> to the following.
     *         </p>
     *         <p>
     *         <code> { "upgrade_os_to":["Amazon Linux 2016.09"], "allow_reboot":["true"] } </code>
     */
    public Map<String, List<String>> args() {
        return args;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((args() == null) ? 0 : args().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentCommand)) {
            return false;
        }
        DeploymentCommand other = (DeploymentCommand) obj;
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.args() == null ^ this.args() == null) {
            return false;
        }
        if (other.args() != null && !other.args().equals(this.args())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (args() != null) {
            sb.append("Args: ").append(args()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeploymentCommandMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, DeploymentCommand> {
        /**
         * <p>
         * Specifies the operation. You can specify only one command.
         * </p>
         * <p>
         * For stacks, the following commands are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>execute_recipes</code>: Execute one or more recipes. To specify the recipes, set an <code>Args</code>
         * parameter named <code>recipes</code> to the list of recipes to be executed. For example, to execute
         * <code>phpapp::appsetup</code>, set <code>Args</code> to <code>{"recipes":["phpapp::appsetup"]}</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>install_dependencies</code>: Install the stack's dependencies.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>update_custom_cookbooks</code>: Update the stack's custom cookbooks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>update_dependencies</code>: Update the stack's dependencies.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The update_dependencies and install_dependencies commands are supported only for Linux instances. You can run
         * the commands successfully on Windows instances, but they do nothing.
         * </p>
         * </note>
         * <p>
         * For apps, the following commands are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>deploy</code>: Deploy an app. Ruby on Rails apps have an optional <code>Args</code> parameter named
         * <code>migrate</code>. Set <code>Args</code> to {"migrate":["true"]} to migrate the database. The default
         * setting is {"migrate":["false"]}.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>rollback</code> Roll the app back to the previous version. When you update an app, AWS OpsWorks Stacks
         * stores the previous version, up to a maximum of five versions. You can use this command to roll an app back
         * as many as four versions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>start</code>: Start the app's web or application server.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>stop</code>: Stop the app's web or application server.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>restart</code>: Restart the app's web or application server.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>undeploy</code>: Undeploy the app.
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        Specifies the operation. You can specify only one command.</p>
         *        <p>
         *        For stacks, the following commands are available:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>execute_recipes</code>: Execute one or more recipes. To specify the recipes, set an
         *        <code>Args</code> parameter named <code>recipes</code> to the list of recipes to be executed. For
         *        example, to execute <code>phpapp::appsetup</code>, set <code>Args</code> to
         *        <code>{"recipes":["phpapp::appsetup"]}</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>install_dependencies</code>: Install the stack's dependencies.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>update_custom_cookbooks</code>: Update the stack's custom cookbooks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>update_dependencies</code>: Update the stack's dependencies.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The update_dependencies and install_dependencies commands are supported only for Linux instances. You
         *        can run the commands successfully on Windows instances, but they do nothing.
         *        </p>
         *        </note>
         *        <p>
         *        For apps, the following commands are available:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>deploy</code>: Deploy an app. Ruby on Rails apps have an optional <code>Args</code> parameter
         *        named <code>migrate</code>. Set <code>Args</code> to {"migrate":["true"]} to migrate the database. The
         *        default setting is {"migrate":["false"]}.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>rollback</code> Roll the app back to the previous version. When you update an app, AWS OpsWorks
         *        Stacks stores the previous version, up to a maximum of five versions. You can use this command to roll
         *        an app back as many as four versions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>start</code>: Start the app's web or application server.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>stop</code>: Stop the app's web or application server.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>restart</code>: Restart the app's web or application server.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>undeploy</code>: Undeploy the app.
         *        </p>
         *        </li>
         * @see DeploymentCommandName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentCommandName
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies the operation. You can specify only one command.
         * </p>
         * <p>
         * For stacks, the following commands are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>execute_recipes</code>: Execute one or more recipes. To specify the recipes, set an <code>Args</code>
         * parameter named <code>recipes</code> to the list of recipes to be executed. For example, to execute
         * <code>phpapp::appsetup</code>, set <code>Args</code> to <code>{"recipes":["phpapp::appsetup"]}</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>install_dependencies</code>: Install the stack's dependencies.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>update_custom_cookbooks</code>: Update the stack's custom cookbooks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>update_dependencies</code>: Update the stack's dependencies.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * The update_dependencies and install_dependencies commands are supported only for Linux instances. You can run
         * the commands successfully on Windows instances, but they do nothing.
         * </p>
         * </note>
         * <p>
         * For apps, the following commands are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>deploy</code>: Deploy an app. Ruby on Rails apps have an optional <code>Args</code> parameter named
         * <code>migrate</code>. Set <code>Args</code> to {"migrate":["true"]} to migrate the database. The default
         * setting is {"migrate":["false"]}.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>rollback</code> Roll the app back to the previous version. When you update an app, AWS OpsWorks Stacks
         * stores the previous version, up to a maximum of five versions. You can use this command to roll an app back
         * as many as four versions.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>start</code>: Start the app's web or application server.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>stop</code>: Stop the app's web or application server.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>restart</code>: Restart the app's web or application server.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>undeploy</code>: Undeploy the app.
         * </p>
         * </li>
         * </ul>
         * 
         * @param name
         *        Specifies the operation. You can specify only one command.</p>
         *        <p>
         *        For stacks, the following commands are available:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>execute_recipes</code>: Execute one or more recipes. To specify the recipes, set an
         *        <code>Args</code> parameter named <code>recipes</code> to the list of recipes to be executed. For
         *        example, to execute <code>phpapp::appsetup</code>, set <code>Args</code> to
         *        <code>{"recipes":["phpapp::appsetup"]}</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>install_dependencies</code>: Install the stack's dependencies.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>update_custom_cookbooks</code>: Update the stack's custom cookbooks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>update_dependencies</code>: Update the stack's dependencies.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        The update_dependencies and install_dependencies commands are supported only for Linux instances. You
         *        can run the commands successfully on Windows instances, but they do nothing.
         *        </p>
         *        </note>
         *        <p>
         *        For apps, the following commands are available:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>deploy</code>: Deploy an app. Ruby on Rails apps have an optional <code>Args</code> parameter
         *        named <code>migrate</code>. Set <code>Args</code> to {"migrate":["true"]} to migrate the database. The
         *        default setting is {"migrate":["false"]}.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>rollback</code> Roll the app back to the previous version. When you update an app, AWS OpsWorks
         *        Stacks stores the previous version, up to a maximum of five versions. You can use this command to roll
         *        an app back as many as four versions.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>start</code>: Start the app's web or application server.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>stop</code>: Stop the app's web or application server.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>restart</code>: Restart the app's web or application server.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>undeploy</code>: Undeploy the app.
         *        </p>
         *        </li>
         * @see DeploymentCommandName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DeploymentCommandName
         */
        Builder name(DeploymentCommandName name);

        /**
         * <p>
         * The arguments of those commands that take arguments. It should be set to a JSON object with the following
         * format:
         * </p>
         * <p>
         * <code>{"arg_name1" : ["value1", "value2", ...], "arg_name2" : ["value1", "value2", ...], ...}</code>
         * </p>
         * <p>
         * The <code>update_dependencies</code> command takes two arguments:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>upgrade_os_to</code> - Specifies the desired Amazon Linux version for instances whose OS you want to
         * upgrade, such as <code>Amazon Linux 2016.09</code>. You must also set the <code>allow_reboot</code> argument
         * to true.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>allow_reboot</code> - Specifies whether to allow AWS OpsWorks Stacks to reboot the instances if
         * necessary, after installing the updates. This argument can be set to either <code>true</code> or
         * <code>false</code>. The default value is <code>false</code>.
         * </p>
         * </li>
         * </ul>
         * <p>
         * For example, to upgrade an instance to Amazon Linux 2016.09, set <code>Args</code> to the following.
         * </p>
         * <p>
         * <code> { "upgrade_os_to":["Amazon Linux 2016.09"], "allow_reboot":["true"] } </code>
         * </p>
         * 
         * @param args
         *        The arguments of those commands that take arguments. It should be set to a JSON object with the
         *        following format:</p>
         *        <p>
         *        <code>{"arg_name1" : ["value1", "value2", ...], "arg_name2" : ["value1", "value2", ...], ...}</code>
         *        </p>
         *        <p>
         *        The <code>update_dependencies</code> command takes two arguments:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>upgrade_os_to</code> - Specifies the desired Amazon Linux version for instances whose OS you
         *        want to upgrade, such as <code>Amazon Linux 2016.09</code>. You must also set the
         *        <code>allow_reboot</code> argument to true.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>allow_reboot</code> - Specifies whether to allow AWS OpsWorks Stacks to reboot the instances if
         *        necessary, after installing the updates. This argument can be set to either <code>true</code> or
         *        <code>false</code>. The default value is <code>false</code>.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For example, to upgrade an instance to Amazon Linux 2016.09, set <code>Args</code> to the following.
         *        </p>
         *        <p>
         *        <code> { "upgrade_os_to":["Amazon Linux 2016.09"], "allow_reboot":["true"] } </code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder args(Map<String, ? extends Collection<String>> args);
    }

    private static final class BuilderImpl implements Builder {
        private String name;

        private Map<String, List<String>> args;

        private BuilderImpl() {
        }

        private BuilderImpl(DeploymentCommand model) {
            setName(model.name);
            setArgs(model.args);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(DeploymentCommandName name) {
            this.name(name.toString());
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final void setName(DeploymentCommandName name) {
            this.name(name.toString());
        }

        public final Map<String, ? extends Collection<String>> getArgs() {
            return args;
        }

        @Override
        public final Builder args(Map<String, ? extends Collection<String>> args) {
            this.args = DeploymentCommandArgsCopier.copy(args);
            return this;
        }

        public final void setArgs(Map<String, ? extends Collection<String>> args) {
            this.args = DeploymentCommandArgsCopier.copy(args);
        }

        @Override
        public DeploymentCommand build() {
            return new DeploymentCommand(this);
        }
    }
}
