/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opsworks.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.opsworks.transform.DeploymentMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a deployment of a stack or app.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class Deployment implements StructuredPojo, ToCopyableBuilder<Deployment.Builder, Deployment> {
    private final String deploymentId;

    private final String stackId;

    private final String appId;

    private final String createdAt;

    private final String completedAt;

    private final Integer duration;

    private final String iamUserArn;

    private final String comment;

    private final DeploymentCommand command;

    private final String status;

    private final String customJson;

    private final List<String> instanceIds;

    private Deployment(BuilderImpl builder) {
        this.deploymentId = builder.deploymentId;
        this.stackId = builder.stackId;
        this.appId = builder.appId;
        this.createdAt = builder.createdAt;
        this.completedAt = builder.completedAt;
        this.duration = builder.duration;
        this.iamUserArn = builder.iamUserArn;
        this.comment = builder.comment;
        this.command = builder.command;
        this.status = builder.status;
        this.customJson = builder.customJson;
        this.instanceIds = builder.instanceIds;
    }

    /**
     * <p>
     * The deployment ID.
     * </p>
     * 
     * @return The deployment ID.
     */
    public String deploymentId() {
        return deploymentId;
    }

    /**
     * <p>
     * The stack ID.
     * </p>
     * 
     * @return The stack ID.
     */
    public String stackId() {
        return stackId;
    }

    /**
     * <p>
     * The app ID.
     * </p>
     * 
     * @return The app ID.
     */
    public String appId() {
        return appId;
    }

    /**
     * <p>
     * Date when the deployment was created.
     * </p>
     * 
     * @return Date when the deployment was created.
     */
    public String createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Date when the deployment completed.
     * </p>
     * 
     * @return Date when the deployment completed.
     */
    public String completedAt() {
        return completedAt;
    }

    /**
     * <p>
     * The deployment duration.
     * </p>
     * 
     * @return The deployment duration.
     */
    public Integer duration() {
        return duration;
    }

    /**
     * <p>
     * The user's IAM ARN.
     * </p>
     * 
     * @return The user's IAM ARN.
     */
    public String iamUserArn() {
        return iamUserArn;
    }

    /**
     * <p>
     * A user-defined comment.
     * </p>
     * 
     * @return A user-defined comment.
     */
    public String comment() {
        return comment;
    }

    /**
     * Returns the value of the Command property for this object.
     * 
     * @return The value of the Command property for this object.
     */
    public DeploymentCommand command() {
        return command;
    }

    /**
     * <p>
     * The deployment status:
     * </p>
     * <ul>
     * <li>
     * <p>
     * running
     * </p>
     * </li>
     * <li>
     * <p>
     * successful
     * </p>
     * </li>
     * <li>
     * <p>
     * failed
     * </p>
     * </li>
     * </ul>
     * 
     * @return The deployment status:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         running
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         successful
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         failed
     *         </p>
     *         </li>
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * A string that contains user-defined custom JSON. It can be used to override the corresponding default stack
     * configuration attribute values for stack or to pass data to recipes. The string should be in the following
     * format:
     * </p>
     * <p>
     * <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
     * </p>
     * <p>
     * For more information on custom JSON, see <a
     * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify the
     * Stack Configuration Attributes</a>.
     * </p>
     * 
     * @return A string that contains user-defined custom JSON. It can be used to override the corresponding default
     *         stack configuration attribute values for stack or to pass data to recipes. The string should be in the
     *         following format:</p>
     *         <p>
     *         <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
     *         </p>
     *         <p>
     *         For more information on custom JSON, see <a
     *         href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to
     *         Modify the Stack Configuration Attributes</a>.
     */
    public String customJson() {
        return customJson;
    }

    /**
     * <p>
     * The IDs of the target instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of the target instances.
     */
    public List<String> instanceIds() {
        return instanceIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deploymentId() == null) ? 0 : deploymentId().hashCode());
        hashCode = 31 * hashCode + ((stackId() == null) ? 0 : stackId().hashCode());
        hashCode = 31 * hashCode + ((appId() == null) ? 0 : appId().hashCode());
        hashCode = 31 * hashCode + ((createdAt() == null) ? 0 : createdAt().hashCode());
        hashCode = 31 * hashCode + ((completedAt() == null) ? 0 : completedAt().hashCode());
        hashCode = 31 * hashCode + ((duration() == null) ? 0 : duration().hashCode());
        hashCode = 31 * hashCode + ((iamUserArn() == null) ? 0 : iamUserArn().hashCode());
        hashCode = 31 * hashCode + ((comment() == null) ? 0 : comment().hashCode());
        hashCode = 31 * hashCode + ((command() == null) ? 0 : command().hashCode());
        hashCode = 31 * hashCode + ((status() == null) ? 0 : status().hashCode());
        hashCode = 31 * hashCode + ((customJson() == null) ? 0 : customJson().hashCode());
        hashCode = 31 * hashCode + ((instanceIds() == null) ? 0 : instanceIds().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Deployment)) {
            return false;
        }
        Deployment other = (Deployment) obj;
        if (other.deploymentId() == null ^ this.deploymentId() == null) {
            return false;
        }
        if (other.deploymentId() != null && !other.deploymentId().equals(this.deploymentId())) {
            return false;
        }
        if (other.stackId() == null ^ this.stackId() == null) {
            return false;
        }
        if (other.stackId() != null && !other.stackId().equals(this.stackId())) {
            return false;
        }
        if (other.appId() == null ^ this.appId() == null) {
            return false;
        }
        if (other.appId() != null && !other.appId().equals(this.appId())) {
            return false;
        }
        if (other.createdAt() == null ^ this.createdAt() == null) {
            return false;
        }
        if (other.createdAt() != null && !other.createdAt().equals(this.createdAt())) {
            return false;
        }
        if (other.completedAt() == null ^ this.completedAt() == null) {
            return false;
        }
        if (other.completedAt() != null && !other.completedAt().equals(this.completedAt())) {
            return false;
        }
        if (other.duration() == null ^ this.duration() == null) {
            return false;
        }
        if (other.duration() != null && !other.duration().equals(this.duration())) {
            return false;
        }
        if (other.iamUserArn() == null ^ this.iamUserArn() == null) {
            return false;
        }
        if (other.iamUserArn() != null && !other.iamUserArn().equals(this.iamUserArn())) {
            return false;
        }
        if (other.comment() == null ^ this.comment() == null) {
            return false;
        }
        if (other.comment() != null && !other.comment().equals(this.comment())) {
            return false;
        }
        if (other.command() == null ^ this.command() == null) {
            return false;
        }
        if (other.command() != null && !other.command().equals(this.command())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.customJson() == null ^ this.customJson() == null) {
            return false;
        }
        if (other.customJson() != null && !other.customJson().equals(this.customJson())) {
            return false;
        }
        if (other.instanceIds() == null ^ this.instanceIds() == null) {
            return false;
        }
        if (other.instanceIds() != null && !other.instanceIds().equals(this.instanceIds())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deploymentId() != null) {
            sb.append("DeploymentId: ").append(deploymentId()).append(",");
        }
        if (stackId() != null) {
            sb.append("StackId: ").append(stackId()).append(",");
        }
        if (appId() != null) {
            sb.append("AppId: ").append(appId()).append(",");
        }
        if (createdAt() != null) {
            sb.append("CreatedAt: ").append(createdAt()).append(",");
        }
        if (completedAt() != null) {
            sb.append("CompletedAt: ").append(completedAt()).append(",");
        }
        if (duration() != null) {
            sb.append("Duration: ").append(duration()).append(",");
        }
        if (iamUserArn() != null) {
            sb.append("IamUserArn: ").append(iamUserArn()).append(",");
        }
        if (comment() != null) {
            sb.append("Comment: ").append(comment()).append(",");
        }
        if (command() != null) {
            sb.append("Command: ").append(command()).append(",");
        }
        if (status() != null) {
            sb.append("Status: ").append(status()).append(",");
        }
        if (customJson() != null) {
            sb.append("CustomJson: ").append(customJson()).append(",");
        }
        if (instanceIds() != null) {
            sb.append("InstanceIds: ").append(instanceIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeploymentMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    public interface Builder extends CopyableBuilder<Builder, Deployment> {
        /**
         * <p>
         * The deployment ID.
         * </p>
         * 
         * @param deploymentId
         *        The deployment ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentId(String deploymentId);

        /**
         * <p>
         * The stack ID.
         * </p>
         * 
         * @param stackId
         *        The stack ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackId(String stackId);

        /**
         * <p>
         * The app ID.
         * </p>
         * 
         * @param appId
         *        The app ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appId(String appId);

        /**
         * <p>
         * Date when the deployment was created.
         * </p>
         * 
         * @param createdAt
         *        Date when the deployment was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(String createdAt);

        /**
         * <p>
         * Date when the deployment completed.
         * </p>
         * 
         * @param completedAt
         *        Date when the deployment completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedAt(String completedAt);

        /**
         * <p>
         * The deployment duration.
         * </p>
         * 
         * @param duration
         *        The deployment duration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder duration(Integer duration);

        /**
         * <p>
         * The user's IAM ARN.
         * </p>
         * 
         * @param iamUserArn
         *        The user's IAM ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamUserArn(String iamUserArn);

        /**
         * <p>
         * A user-defined comment.
         * </p>
         * 
         * @param comment
         *        A user-defined comment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * Sets the value of the Command property for this object.
         *
         * @param command
         *        The new value for the Command property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder command(DeploymentCommand command);

        /**
         * <p>
         * The deployment status:
         * </p>
         * <ul>
         * <li>
         * <p>
         * running
         * </p>
         * </li>
         * <li>
         * <p>
         * successful
         * </p>
         * </li>
         * <li>
         * <p>
         * failed
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The deployment status:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        running
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        successful
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        failed
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * A string that contains user-defined custom JSON. It can be used to override the corresponding default stack
         * configuration attribute values for stack or to pass data to recipes. The string should be in the following
         * format:
         * </p>
         * <p>
         * <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
         * </p>
         * <p>
         * For more information on custom JSON, see <a
         * href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to Modify
         * the Stack Configuration Attributes</a>.
         * </p>
         * 
         * @param customJson
         *        A string that contains user-defined custom JSON. It can be used to override the corresponding default
         *        stack configuration attribute values for stack or to pass data to recipes. The string should be in the
         *        following format:</p>
         *        <p>
         *        <code>"{\"key1\": \"value1\", \"key2\": \"value2\",...}"</code>
         *        </p>
         *        <p>
         *        For more information on custom JSON, see <a
         *        href="http://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-json.html">Use Custom JSON to
         *        Modify the Stack Configuration Attributes</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customJson(String customJson);

        /**
         * <p>
         * The IDs of the target instances.
         * </p>
         * 
         * @param instanceIds
         *        The IDs of the target instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(Collection<String> instanceIds);

        /**
         * <p>
         * The IDs of the target instances.
         * </p>
         * 
         * @param instanceIds
         *        The IDs of the target instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceIds(String... instanceIds);
    }

    private static final class BuilderImpl implements Builder {
        private String deploymentId;

        private String stackId;

        private String appId;

        private String createdAt;

        private String completedAt;

        private Integer duration;

        private String iamUserArn;

        private String comment;

        private DeploymentCommand command;

        private String status;

        private String customJson;

        private List<String> instanceIds;

        private BuilderImpl() {
        }

        private BuilderImpl(Deployment model) {
            setDeploymentId(model.deploymentId);
            setStackId(model.stackId);
            setAppId(model.appId);
            setCreatedAt(model.createdAt);
            setCompletedAt(model.completedAt);
            setDuration(model.duration);
            setIamUserArn(model.iamUserArn);
            setComment(model.comment);
            setCommand(model.command);
            setStatus(model.status);
            setCustomJson(model.customJson);
            setInstanceIds(model.instanceIds);
        }

        public final String getDeploymentId() {
            return deploymentId;
        }

        @Override
        public final Builder deploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = deploymentId;
        }

        public final String getStackId() {
            return stackId;
        }

        @Override
        public final Builder stackId(String stackId) {
            this.stackId = stackId;
            return this;
        }

        public final void setStackId(String stackId) {
            this.stackId = stackId;
        }

        public final String getAppId() {
            return appId;
        }

        @Override
        public final Builder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public final void setAppId(String appId) {
            this.appId = appId;
        }

        public final String getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(String createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(String createdAt) {
            this.createdAt = createdAt;
        }

        public final String getCompletedAt() {
            return completedAt;
        }

        @Override
        public final Builder completedAt(String completedAt) {
            this.completedAt = completedAt;
            return this;
        }

        public final void setCompletedAt(String completedAt) {
            this.completedAt = completedAt;
        }

        public final Integer getDuration() {
            return duration;
        }

        @Override
        public final Builder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public final void setDuration(Integer duration) {
            this.duration = duration;
        }

        public final String getIamUserArn() {
            return iamUserArn;
        }

        @Override
        public final Builder iamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
            return this;
        }

        public final void setIamUserArn(String iamUserArn) {
            this.iamUserArn = iamUserArn;
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final DeploymentCommand getCommand() {
            return command;
        }

        @Override
        public final Builder command(DeploymentCommand command) {
            this.command = command;
            return this;
        }

        public final void setCommand(DeploymentCommand command) {
            this.command = command;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getCustomJson() {
            return customJson;
        }

        @Override
        public final Builder customJson(String customJson) {
            this.customJson = customJson;
            return this;
        }

        public final void setCustomJson(String customJson) {
            this.customJson = customJson;
        }

        public final Collection<String> getInstanceIds() {
            return instanceIds;
        }

        @Override
        public final Builder instanceIds(Collection<String> instanceIds) {
            this.instanceIds = StringsCopier.copy(instanceIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceIds(String... instanceIds) {
            instanceIds(Arrays.asList(instanceIds));
            return this;
        }

        public final void setInstanceIds(Collection<String> instanceIds) {
            this.instanceIds = StringsCopier.copy(instanceIds);
        }

        @SafeVarargs
        public final void setInstanceIds(String... instanceIds) {
            instanceIds(Arrays.asList(instanceIds));
        }

        @Override
        public Deployment build() {
            return new Deployment(this);
        }
    }
}
